/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedObjectID;
import com.raplix.rolloutexpress.persist.VersionedPersistentBean;

public class VersionedSaveContext
extends PersistContext
implements RPCSerializable,
Cloneable {
    private VersionNumber mLatestVersion;
    private boolean mSaveAsNewMajor;
    private VersionedObjectID mHideObjectID;
    private boolean mHideLatest;

    public VersionedSaveContext() {
    }

    protected VersionedSaveContext(VersionedPersistentBean latestObject) {
        this.setLatestVersion(latestObject);
    }

    public VersionNumber getLatestVersion() {
        return this.mLatestVersion;
    }

    public void setLatestVersion(VersionNumber latestVersion) {
        this.mLatestVersion = latestVersion;
    }

    public void setLatestVersion(VersionedPersistentBean latestObject) {
        if (latestObject == null || latestObject.getRootObjectID() == null) {
            this.setLatestVersion((VersionNumber)null);
        } else {
            this.setLatestVersion(latestObject.getVersionNumber());
        }
    }

    public boolean getSaveAsNewMajor() {
        return this.mSaveAsNewMajor;
    }

    public void setSaveAsNewMajor(boolean saveAsNewMajor) {
        this.mSaveAsNewMajor = saveAsNewMajor;
    }

    public VersionedObjectID getHideObjectID() {
        return this.mHideObjectID;
    }

    public void setHideObjectID(VersionedObjectID hideObjectID) {
        this.mHideObjectID = hideObjectID;
    }

    public boolean getHideLatest() {
        return this.mHideLatest;
    }

    public void setHideLatest(boolean hideLatest) {
        this.mHideLatest = hideLatest;
    }

    public VersionNumber getVersionToSaveAs() {
        VersionNumber result = this.getLatestVersion();
        result = this.mLatestVersion == null ? VersionNumber.ROOT : (this.getSaveAsNewMajor() ? result.nextMajorVersionNumber() : result.nextMinorVersionNumber());
        return result;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }
}

