/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedData;
import com.raplix.rolloutexpress.persist.VersionedPersistentBean;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.query.RetrieveAllVersionsQuery;
import com.raplix.rolloutexpress.persist.query.RetrieveVersionedObjectQuery;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.logger.Logger;
import java.util.Date;

public abstract class VersionedPersistentObject
extends VersionedPersistentBean
implements RPCSerializable,
Messages,
VersionedData {
    public UserID getUserID() {
        return super.getUserID();
    }

    public ObjectID getRootID() {
        ObjectID result = this.getRootObjectID();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Returing root id:" + result, this);
        }
        return result;
    }

    public Date getTimeStamp() {
        return super.getTimeStamp();
    }

    public VersionNumber getVersionNumber() {
        return super.getVersionNumber();
    }

    public ObjectID getObjectID() {
        return super.getObjectID();
    }

    public void setObjectID(ObjectID inID) {
        super.setObjectID(inID);
    }

    public Visibility getVisibility() {
        return super.getVisibility();
    }

    public void setVisibility(Visibility visibility) {
        super.setVisibility(visibility);
    }

    public void save() throws PersistenceManagerException {
        this.save(null);
    }

    public void save(VersionedSaveContext inContext) throws PersistenceManagerException {
        this.safeSaveMS(inContext);
    }

    public void retrieve() throws PersistenceManagerException {
        PersistenceManager.getBeanManager().retrieve(this);
    }

    public VersionedPersistentObject retrieve(VersionNumber inVersionNumber) throws PersistenceManagerException {
        ClassMap classMap = this.getClassMap();
        RetrieveVersionedObjectQuery theQuery = new RetrieveVersionedObjectQuery(classMap.getDatabase(), classMap, this.getRootID(), inVersionNumber);
        theQuery.runQuery();
        return theQuery.getRetrievedObject();
    }

    public VersionedPersistentObject retrieveLatest() throws PersistenceManagerException {
        return (VersionedPersistentObject)this.retrieveLatestMS();
    }

    public VersionedPersistentObject[] retrieveAllVersions() throws PersistenceManagerException {
        ClassMap classMap = this.getClassMap();
        RetrieveAllVersionsQuery theQuery = new RetrieveAllVersionsQuery(classMap.getDatabase(), classMap, this.getRootID());
        theQuery.runQuery();
        return theQuery.getRetrievedObjects();
    }

    public ClassMap getClassMap() throws PersistenceManagerException {
        return this.getClassMapMS();
    }

    public boolean isPersistent() {
        return super.isPersistent();
    }

    public String toString() {
        return this.getClass().getName() + ":persistent:" + this.isPersistent() + ":updCnt:" + this.getUpdateCount();
    }
}

