/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.IllegalVersion;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.SaveResult;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.persist.VersionedObjectID;
import com.raplix.rolloutexpress.persist.VersionedSaveContext;
import com.raplix.rolloutexpress.persist.VersionedSaveResult;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.query.RetrieveLatestVersionQuery;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotSavedQueryException;
import com.raplix.rolloutexpress.systemmodel.userdb.Session;
import com.raplix.rolloutexpress.systemmodel.userdb.SessionTable;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.ObjectUtil;
import com.raplix.util.logger.Logger;
import java.util.Date;

public class VersionedPersistentBean
extends PersistentBean {
    public static final String VERSION_COL_NAME = "VERSION";
    public static final String VERSION_ATTRIB_NAME = "Version";
    public static final String ROOT_ID_ATTRIB_NAME = "RootID";
    public static final String ROOT_ID_COL_NAME = "ROOT_ID";
    public static final String USER_ID_ATTRIB_NAME = "UserID";
    public static final String USER_ID_COL_NAME = "USER_ID";
    public static final String TIMESTAMP_COLNAME = "C_TIMESTAMP";
    public static final String TIMESTAMP_ATTRIBNAME = "TimeStamp";
    private ObjectID mRootID;
    private VersionNumber mVersionNumber = VersionNumber.ROOT;
    private UserID mUserID;
    private Date mTimeStamp;

    protected VersionedPersistentBean() {
    }

    protected UserID getUserID() {
        return this.mUserID;
    }

    private void setUserID(UserID userID) {
        this.mUserID = userID;
    }

    protected ObjectID getRootObjectID() {
        return this.mRootID;
    }

    private void setRootObjectID(ObjectID rootID) {
        this.mRootID = rootID;
    }

    private void setTimeStamp(Date inTimeStamp) {
        this.mTimeStamp = inTimeStamp;
    }

    protected Date getTimeStamp() {
        return this.mTimeStamp == null ? null : (Date)this.mTimeStamp.clone();
    }

    protected VersionNumber getVersionNumber() {
        return this.mVersionNumber;
    }

    private void setVersionNumber(VersionNumber versionNumber) {
        this.mVersionNumber = versionNumber;
    }

    private int getVersion() {
        return this.mVersionNumber.getSingleVersionNumber();
    }

    private void setVersion(int inVersion) {
        this.mVersionNumber = new VersionNumber(inVersion);
    }

    void setObjectID(ObjectID inID) {
        super.setObjectID(inID);
        if (this.getRootObjectID() == null) {
            this.setRootObjectID(inID);
        }
    }

    protected Object getObjectDataClone() throws CloneNotSupportedException {
        VersionedPersistentBean result = (VersionedPersistentBean)super.getObjectDataClone();
        result.setRootObjectID(null);
        result.setUserID(null);
        result.setTimeStamp(null);
        result.setVersionNumber(VersionNumber.ROOT);
        return result;
    }

    protected final void saveRPC(PersistContext ctx) throws RPCException, PersistenceManagerException {
        this.saveRPC((VersionedSaveContext)ctx);
    }

    protected void saveRPC(VersionedSaveContext ctx) throws RPCException, PersistenceManagerException {
        super.saveRPC(ctx);
    }

    protected final void saveMS(PersistContext ctx) throws PersistenceManagerException {
        this.saveMS((VersionedSaveContext)ctx);
    }

    protected void saveSameVersionMS() throws PersistenceManagerException {
        if (!this.isPersistent()) {
            throw new PersistenceManagerException(new ROXMessage("pm.INVALID_VERSIONED_UPDATE"));
        }
        VersionedPersistentBean.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                VersionedPersistentBean.this.trSaveSameVersionMS();
                return null;
            }
        });
    }

    private void trSaveSameVersionMS() throws PersistenceManagerException {
        super.saveMS(null);
        Table t = this.getClassMapMS().getTable();
        Select thisID = Table.anonSelect(Table.sList(Table.v(this.getObjectID())));
        t.notifyDependenciesOfUpdate(thisID);
    }

    protected void saveMS(VersionedSaveContext saveContext) throws PersistenceManagerException {
        final VersionedSaveContext theContext = this.getValidContext(saveContext);
        this.setPersistent(false);
        this.setUserID(this.getCurrentUserID());
        VersionedPersistentBean.transactMS(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                VersionedPersistentBean vpo = null;
                if (VersionedPersistentBean.this.mRootID != null) {
                    VersionedPersistentBean.this.mRootID.lockForUpdateMS();
                    vpo = VersionedPersistentBean.this.retrieveLatestMS();
                    VersionedPersistentBean.this.checkAndMarkObjectDirtyMS();
                }
                VersionedPersistentBean.this.trSaveMS(vpo, theContext);
                return null;
            }
        });
    }

    private void checkAndMarkObjectDirtyMS() throws PersistenceManagerException {
        Table table = this.getClassMapMS().getTable();
        int rowsAffected = Table.execute(table.incrUpdateCountWhere(Table.and(Table.equals(table.ID, this.getObjectID()), Table.equals(table.UpdateCount, this.getUpdateCount()))));
        if (rowsAffected != 1) {
            throw new ObjectNotSavedQueryException(new ROXMessage("pm.OBJECT_COULD_NOT_BE_SAVED", (Object[])new String[]{PersistenceManager.getObjectName(this.getClass()).toString()}, 2000));
        }
    }

    private UserID getCurrentUserID() {
        UserID result;
        block3: {
            result = null;
            try {
                Session session;
                SessionTable sTable = PersistenceManager.getInstance().getApplication().getUserDBSubsystem().getSessionTable();
                if (sTable != null && (session = sTable.getCurrentSession()) != null) {
                    result = session.getUserID();
                }
            }
            catch (UnsupportedSubsystemException use) {
                if (!Logger.isErrorEnabled(this)) break block3;
                Logger.error("Cannot get the UserDBSubsystem to set the userID for the VersionedObject, Setting user-id to null", use, this);
            }
        }
        return result;
    }

    protected void trSaveMS(VersionedPersistentBean latest, VersionedSaveContext ctx) throws PersistenceManagerException {
        VersionNumber latestVersion;
        VersionNumber versionNumber = latestVersion = latest == null ? null : latest.getVersionNumber();
        if (!ObjectUtil.equals(latestVersion, ctx.getLatestVersion())) {
            String objectName = PersistenceManager.getObjectName(this.getClass()).getMessageString();
            String versionStr = VersionedPersistentBean.getAsString(latestVersion);
            ROXMessage msg = new ROXMessage("pm.vo.VERSION_NUMBER_INVALID", new Object[]{objectName, versionStr});
            throw new IllegalVersion(msg);
        }
        this.setVersionNumber(ctx.getVersionToSaveAs());
        this.setTimeStamp(new Date());
        super.saveMS(ctx);
        VersionedObjectID hideID = ctx.getHideObjectID();
        if (hideID != null) {
            hideID.updateVisibilityMS(Visibility.HIDDEN, null);
        }
        if (latest != null && ctx.getHideLatest()) {
            VersionedObjectID latestID = (VersionedObjectID)latest.getObjectID();
            latestID.updateVisibilityMS(Visibility.HIDDEN, null);
        }
    }

    protected VersionedPersistentBean retrieveLatestMS() throws PersistenceManagerException {
        ClassMap classMap = this.getClassMapMS();
        RetrieveLatestVersionQuery theQuery = new RetrieveLatestVersionQuery(classMap.getDatabase(), classMap, this.getRootObjectID());
        theQuery.runQuery();
        return theQuery.getRetrievedObject();
    }

    ClassMap getClassMapMS() throws PersistenceManagerException {
        return PersistenceManager.getBeanManager().getClassMap(this);
    }

    protected static String getAsString(VersionNumber version) {
        return version == null ? "0.0" : version.getAsString();
    }

    protected SaveResult createSaveResult() throws PersistenceManagerException {
        return new VersionedSaveResult(this, true);
    }

    protected void setSaveResult(SaveResult saveResult) throws PersistenceManagerException {
        VersionedSaveResult vsr = (VersionedSaveResult)saveResult;
        super.setSaveResult(saveResult);
        this.setRootObjectID(vsr.getRootObjectID());
        this.setUserID(vsr.getUserID());
        this.setTimeStamp(vsr.getTimeStamp());
        this.setVersionNumber(vsr.getVersionNumber());
    }

    protected void incrementUpdateCountInSave() throws PersistenceManagerException {
        this.getClassMapMS().getBeanManager().incrementUpdateCount(this);
    }

    protected VersionedSaveContext getValidContext(VersionedSaveContext cxt) {
        return cxt == null ? new VersionedSaveContext(this) : cxt;
    }
}

