/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.persist.VersionNumber;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import java.util.Comparator;
import java.util.Date;

public interface VersionedData {
    public static final TimeStampComparator TIMESTAMP_COMPARATOR = new TimeStampComparator();

    public UserID getUserID();

    public Date getTimeStamp();

    public VersionNumber getVersionNumber();

    public static class TimeStampComparator
    implements Comparator {
        public boolean equals(Object o) {
            return o instanceof TimeStampComparator;
        }

        public int compare(Object lhs, Object rhs) {
            VersionedData left = (VersionedData)lhs;
            VersionedData right = (VersionedData)rhs;
            if (left == null) {
                return right == null ? 0 : -1;
            }
            if (right == null) {
                return 1;
            }
            Date leftstamp = left.getTimeStamp();
            Date rightstamp = right.getTimeStamp();
            if (leftstamp == null) {
                return rightstamp == null ? 0 : -1;
            }
            if (rightstamp == null) {
                return 1;
            }
            if (!leftstamp.equals(rightstamp)) {
                return leftstamp.getTime() > rightstamp.getTime() ? 1 : -1;
            }
            return 0;
        }
    }
}

