/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;

public class VersionNumber
implements Comparable,
RPCSerializable {
    public static final short MIN_MINOR_NUMBER = 0;
    public static final short MIN_MAJOR_NUMBER = 1;
    private short mMajorNumber;
    private short mMinorNumber;
    public static final VersionNumber ROOT = new VersionNumber();

    public VersionNumber(String str) throws PersistenceManagerException {
        block5: {
            try {
                if (str != null && str.trim().length() > 0) {
                    int idx = str.indexOf(46);
                    if (idx != -1) {
                        this.mMajorNumber = Short.parseShort(str.substring(0, idx));
                        this.mMinorNumber = Short.parseShort(str.substring(idx + 1));
                    } else {
                        this.mMajorNumber = 1;
                        this.mMinorNumber = Short.parseShort(str);
                    }
                    break block5;
                }
                throw new PersistenceManagerException(new ROXMessage("pm.vo.VERSION_NUMBER_FORMAT_INVALID", new Object[]{str}));
            }
            catch (NumberFormatException nfe) {
                throw new PersistenceManagerException(new ROXMessage("pm.vo.VERSION_NUMBER_FORMAT_INVALID", new Object[]{str}));
            }
        }
    }

    public VersionNumber() {
        this.mMajorNumber = 1;
        this.mMinorNumber = 0;
    }

    public short getMajorNumber() {
        return this.mMajorNumber;
    }

    void setMajorNumber(short inMajorNumber) {
        this.mMajorNumber = inMajorNumber;
    }

    public short getMinorNumber() {
        return this.mMinorNumber;
    }

    void setMinorNumber(short inMinorNumber) {
        this.mMinorNumber = inMinorNumber;
    }

    public VersionNumber nextMinorVersionNumber() {
        return new VersionNumber(this.mMajorNumber, (short)(this.mMinorNumber + 1));
    }

    public int getSingleVersionNumber() {
        return (this.mMajorNumber & 0xFFFF) << 16 | this.mMinorNumber & 0xFFFF;
    }

    void setSingleVersionNumber(int version) {
        this.mMajorNumber = (short)(0xFFFF & version >> 16);
        this.mMinorNumber = (short)(0xFFFF & version);
    }

    public VersionNumber nextMajorVersionNumber() {
        return new VersionNumber((short)(this.mMajorNumber + 1), 0);
    }

    public VersionNumber(short inMajorNumber, short inMinorNumber) {
        this.mMajorNumber = inMajorNumber;
        this.mMinorNumber = inMinorNumber;
    }

    public VersionNumber(int singleVersionNumber) {
        this.setSingleVersionNumber(singleVersionNumber);
    }

    public int hashCode() {
        return this.mMajorNumber ^ this.mMinorNumber;
    }

    public String getAsString() {
        return this.mMajorNumber + "." + this.mMinorNumber;
    }

    public boolean isGreaterThan(VersionNumber inVersion) {
        if (this.mMajorNumber > inVersion.mMajorNumber) {
            return true;
        }
        return this.mMajorNumber == inVersion.mMajorNumber && this.mMinorNumber > inVersion.mMinorNumber;
    }

    public boolean isLessThan(VersionNumber inVersion) {
        if (this.mMajorNumber < inVersion.mMajorNumber) {
            return true;
        }
        return this.mMajorNumber == inVersion.mMajorNumber && this.mMinorNumber < inVersion.mMinorNumber;
    }

    public boolean equals(Object inVersionNumber) {
        if (inVersionNumber != null && inVersionNumber instanceof VersionNumber) {
            return ((VersionNumber)inVersionNumber).mMajorNumber == this.mMajorNumber && ((VersionNumber)inVersionNumber).mMinorNumber == this.mMinorNumber;
        }
        return false;
    }

    public String toString() {
        return "ver:" + this.getAsString();
    }

    public int compareTo(Object obj) {
        VersionNumber vn = (VersionNumber)obj;
        if (this.equals(vn)) {
            return 0;
        }
        if (this.isGreaterThan(vn)) {
            return 1;
        }
        return -1;
    }
}

