/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.AcquireLockTransaction;
import com.raplix.rolloutexpress.persist.AcquireReadLock;
import com.raplix.rolloutexpress.persist.AcquireWriteLock;
import com.raplix.rolloutexpress.persist.PMLockException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PreCommitException;
import com.raplix.rolloutexpress.persist.TopLevelTransactionListener;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.TransactionContext;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.exception.RollbackTransactionException;
import com.raplix.rolloutexpress.persist.exception.TransactionNonExistentException;
import com.raplix.rolloutexpress.persist.sql.ConnectionNotAvailable;
import com.raplix.rolloutexpress.persist.sql.DBConnection;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import com.raplix.util.logger.Logger;
import com.raplix.util.rwlock.LockContext;
import com.raplix.util.rwlock.RWLock;
import com.raplix.util.rwlock.RWLockException;
import java.security.AccessControlException;
import java.sql.SQLException;

public class TransactionManager {
    private ThreadLocal mTransactionContextTable = new ThreadLocal();

    public Object transact(Transaction inTransaction) throws PersistenceManagerException {
        return this.transact(inTransaction, PersistenceManager.getInstance().getDefaultDatabase());
    }

    public Object transact(final Transaction inTransaction, final Database inDatabase) throws PersistenceManagerException {
        final TransactionContext theTransContext = this.retrieveContext();
        if (inTransaction instanceof AcquireLockTransaction) {
            AcquireLockTransaction lockTx = (AcquireLockTransaction)((Object)inTransaction);
            RWLock lock = PersistenceManager.getInstance().getSystemLockObject();
            try {
                final Boolean shouldAcquireRead = this.shouldAcquireRead(lockTx, theTransContext);
                LockContext lockContext = new LockContext(){

                    public Object execute() throws PersistenceManagerException {
                        return TransactionManager.this.lockedTransact(theTransContext, inTransaction, inDatabase, shouldAcquireRead);
                    }
                };
                if (Boolean.TRUE.equals(shouldAcquireRead)) {
                    return lock.readLock(lockTx.getLockDescription(), lockContext);
                }
                return lock.writeLock(lockTx.getLockDescription(), lockContext);
            }
            catch (PersistenceManagerException e) {
                throw e;
            }
            catch (AccessControlException e) {
                throw e;
            }
            catch (RWLockException e) {
                throw new PMLockException(e);
            }
            catch (Exception e) {
                throw new PersistenceManagerException(e);
            }
        }
        return this.lockedTransact(theTransContext, inTransaction, inDatabase, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private Object lockedTransact(TransactionContext theTransContext, Transaction inTransaction, Database inDatabase, Boolean shouldAcquireRead) throws PersistenceManagerException {
        Object theResults;
        block38: {
            theResults = null;
            try {
                if (theTransContext == null) {
                    PersistenceManagerException txnError;
                    boolean commitSuccessful;
                    block35: {
                        commitSuccessful = false;
                        txnError = null;
                        try {
                            theTransContext = this.registerTransaction(inTransaction, inDatabase, shouldAcquireRead);
                            boolean success = false;
                            theResults = inTransaction.execute();
                            success = true;
                            Object var11_10 = null;
                            boolean commitTxn = false;
                            try {
                                Object v0;
                                try {
                                    try {
                                        theTransContext.aboutToComplete(success, txnError);
                                        commitTxn = success;
                                        v0 = null;
                                    }
                                    catch (PreCommitException e) {
                                        txnError = e;
                                        throw e;
                                    }
                                }
                                catch (Throwable throwable) {
                                    Object var15_22;
                                    v0 = var15_22 = null;
                                }
                                if (commitTxn) {
                                    theTransContext.getConnection().commit();
                                    commitSuccessful = true;
                                } else {
                                    theTransContext.getConnection().rollback();
                                }
                                break block35;
                            }
                            catch (Throwable throwable) {
                                Object var17_28 = null;
                                if (Logger.isDebugEnabled(this)) {
                                    Logger.debug("cmtTxn:" + commitTxn + ":cmtSucsfl:" + commitSuccessful, this);
                                }
                                ObjectCache.transactionComplete(commitSuccessful);
                                theTransContext.getDatabase().returnConnection(theTransContext.getConnection());
                                this.unregisterTransaction();
                                throw throwable;
                            }
                            {
                                catch (RollbackTransactionException rollbackException) {
                                    Object var11_11 = null;
                                    commitTxn = false;
                                    try {
                                        Object v1;
                                        try {
                                            try {
                                                theTransContext.aboutToComplete(success, txnError);
                                                commitTxn = success;
                                                v1 = null;
                                            }
                                            catch (PreCommitException e) {
                                                txnError = e;
                                                throw e;
                                            }
                                        }
                                        catch (Throwable throwable) {
                                            Object var15_23;
                                            v1 = var15_23 = null;
                                        }
                                        if (commitTxn) {
                                            theTransContext.getConnection().commit();
                                            commitSuccessful = true;
                                        } else {
                                            theTransContext.getConnection().rollback();
                                        }
                                        break block35;
                                    }
                                    catch (Throwable throwable) {
                                        Object var17_29 = null;
                                        if (Logger.isDebugEnabled(this)) {
                                            Logger.debug("cmtTxn:" + commitTxn + ":cmtSucsfl:" + commitSuccessful, this);
                                        }
                                        ObjectCache.transactionComplete(commitSuccessful);
                                        theTransContext.getDatabase().returnConnection(theTransContext.getConnection());
                                        this.unregisterTransaction();
                                        throw throwable;
                                    }
                                }
                                catch (SQLException se) {
                                    txnError = inDatabase.wrapSQLException(se);
                                    throw txnError;
                                }
                                catch (PersistenceManagerException e) {
                                    txnError = e;
                                    throw txnError;
                                }
                            }
                            catch (Throwable throwable) {
                                Object var11_12 = null;
                                commitTxn = false;
                                try {
                                    Object v2;
                                    try {
                                        try {
                                            theTransContext.aboutToComplete(success, txnError);
                                            commitTxn = success;
                                            v2 = null;
                                        }
                                        catch (PreCommitException e) {
                                            txnError = e;
                                            throw e;
                                        }
                                    }
                                    catch (Throwable throwable2) {
                                        Object var15_24;
                                        v2 = var15_24 = null;
                                    }
                                    if (commitTxn) {
                                        theTransContext.getConnection().commit();
                                        commitSuccessful = true;
                                    } else {
                                        theTransContext.getConnection().rollback();
                                    }
                                }
                                catch (Throwable throwable3) {
                                    Object var17_30 = null;
                                    if (Logger.isDebugEnabled(this)) {
                                        Logger.debug("cmtTxn:" + commitTxn + ":cmtSucsfl:" + commitSuccessful, this);
                                    }
                                    ObjectCache.transactionComplete(commitSuccessful);
                                    theTransContext.getDatabase().returnConnection(theTransContext.getConnection());
                                    this.unregisterTransaction();
                                    throw throwable3;
                                }
                                throw throwable;
                            }
                        }
                        catch (Throwable throwable) {
                            Object var19_36 = null;
                            if (theTransContext != null) {
                                theTransContext.executePostTransactionListeners(commitSuccessful, txnError);
                            }
                            throw throwable;
                        }
                    }
                    Object var19_35 = null;
                    if (theTransContext != null) {
                        theTransContext.executePostTransactionListeners(commitSuccessful, txnError);
                    }
                    break block38;
                }
                theResults = inTransaction.execute();
            }
            catch (SQLException sqle) {
                throw inDatabase.wrapSQLException(sqle);
            }
        }
        return theResults;
    }

    private Boolean shouldAcquireRead(AcquireLockTransaction tx, TransactionContext ctx) throws PersistenceManagerException {
        if (tx instanceof AcquireReadLock) {
            if (tx instanceof AcquireWriteLock) {
                throw this.invalidTransactionLock();
            }
            if (ctx != null && ctx.shouldAcquireRead() == null) {
                throw this.invalidTransactionLock();
            }
            return Boolean.TRUE;
        }
        if (tx instanceof AcquireWriteLock) {
            if (ctx != null && !Boolean.FALSE.equals(ctx.shouldAcquireRead())) {
                throw this.invalidTransactionLock();
            }
            return Boolean.FALSE;
        }
        throw this.invalidTransactionLock();
    }

    private PersistenceManagerException invalidTransactionLock() {
        ROXMessage msg = new ROXMessage("pm.INVALID_TRANSACTION_LOCK");
        return new PersistenceManagerException(msg);
    }

    public void registerTopLevelTransactionListener(TopLevelTransactionListener listener) throws PersistenceManagerException {
        TransactionContext context = this.retrieveContext();
        if (context == null) {
            throw new PersistenceManagerException(new ROXMessage("pm.qe.NO_TRANSACTION"));
        }
        context.registerListener(listener);
    }

    public void unregisterTopLevelTransactionListener(TopLevelTransactionListener listener) throws PersistenceManagerException {
        TransactionContext context = this.retrieveContext();
        if (context == null) {
            throw new PersistenceManagerException(new ROXMessage("pm.qe.NO_TRANSACTION"));
        }
        context.unregisterListener(listener);
    }

    protected TransactionContext retrieveContext() {
        return (TransactionContext)this.mTransactionContextTable.get();
    }

    protected TransactionContext registerTransaction(Transaction inTransaction, Database inDatabase, Boolean shouldAcquireRead) throws ConnectionNotAvailable, SQLException {
        DBConnection theConn = inDatabase.getConnection();
        theConn.setAutoCommit(false);
        TransactionContext theContext = new TransactionContext(inTransaction, inDatabase, theConn, shouldAcquireRead);
        this.mTransactionContextTable.set(theContext);
        return theContext;
    }

    protected void unregisterTransaction() {
        this.mTransactionContextTable.set(null);
    }

    public TransactionContext getTransactionContext() throws TransactionNonExistentException {
        TransactionContext theContext = (TransactionContext)this.mTransactionContextTable.get();
        if (theContext == null) {
            throw new TransactionNonExistentException();
        }
        return theContext;
    }

    public void addSQLStatement(SQLStatement inStatement) {
    }

    public void dumpAllTransactions() {
    }
}

