/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.persist.PostTransactionException;
import com.raplix.rolloutexpress.persist.PostTransactionMultipleException;
import com.raplix.rolloutexpress.persist.PreCommitException;
import com.raplix.rolloutexpress.persist.PreCommitMultipleException;
import com.raplix.rolloutexpress.persist.TopLevelTransactionListener;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.sql.DBConnection;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import java.util.LinkedList;

public class TransactionContext {
    private Transaction mTransaction;
    private Database mDatabase;
    private DBConnection mConnection;
    private LinkedList mStatements;
    private LinkedList mListeners;
    private Boolean mShouldAcquireRead;

    public TransactionContext(Transaction inTransaction, Database inDatabase, DBConnection inConnection, Boolean shouldAcquireRead) {
        this.mTransaction = inTransaction;
        this.mDatabase = inDatabase;
        this.mConnection = inConnection;
        this.mStatements = new LinkedList();
        this.mListeners = new LinkedList();
        this.mShouldAcquireRead = shouldAcquireRead;
    }

    public Transaction getTransaction() {
        return this.mTransaction;
    }

    public Database getDatabase() {
        return this.mDatabase;
    }

    public DBConnection getConnection() {
        return this.mConnection;
    }

    Boolean shouldAcquireRead() {
        return this.mShouldAcquireRead;
    }

    void addSQLStatement(SQLStatement inStatement) {
        this.mStatements.addLast(new SQLStatementExec(inStatement.getSQLString()));
    }

    void registerListener(TopLevelTransactionListener listener) {
        this.mListeners.add(listener);
    }

    void unregisterListener(TopLevelTransactionListener listener) {
        this.mListeners.remove(listener);
    }

    void executePostTransactionListeners(boolean isTransactionCommited, PersistenceManagerException currentError) throws PostTransactionException {
        if (this.mListeners.isEmpty()) {
            return;
        }
        TopLevelTransactionListener[] listeners = this.mListeners.toArray(new TopLevelTransactionListener[this.mListeners.size()]);
        LinkedList<PostTransactionException> errors = new LinkedList<PostTransactionException>();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].transactionComplete(isTransactionCommited);
                continue;
            }
            catch (PostTransactionException e) {
                e.setTransactionCommited(isTransactionCommited);
                errors.add(e);
            }
        }
        if (!errors.isEmpty()) {
            if (currentError == null && errors.size() == 1) {
                throw (PostTransactionException)errors.get(0);
            }
            throw new PostTransactionMultipleException(isTransactionCommited, errors.toArray(new PostTransactionException[errors.size()]), currentError);
        }
    }

    void aboutToComplete(boolean isCommitable, PersistenceManagerException currentError) throws PreCommitException {
        if (this.mListeners.isEmpty()) {
            return;
        }
        TopLevelTransactionListener[] listeners = this.mListeners.toArray(new TopLevelTransactionListener[this.mListeners.size()]);
        LinkedList<PreCommitException> errors = new LinkedList<PreCommitException>();
        for (int i = 0; i < listeners.length; ++i) {
            try {
                listeners[i].aboutToComplete(isCommitable);
                continue;
            }
            catch (PreCommitException e) {
                errors.add(e);
                isCommitable = false;
            }
        }
        if (!errors.isEmpty()) {
            if (currentError == null && errors.size() == 1) {
                throw (PreCommitException)errors.get(0);
            }
            throw new PreCommitMultipleException(errors.toArray(new PreCommitException[errors.size()]), (Throwable)currentError);
        }
    }

    LinkedList getAllStatements() {
        return (LinkedList)this.mStatements.clone();
    }

    static class SQLStatementExec
    implements Comparable {
        private String mOwnerThread;
        private String mStatement;
        private long mTimestamp;

        SQLStatementExec(String inStatement) {
            this.mStatement = inStatement;
            this.mTimestamp = System.currentTimeMillis();
            this.mOwnerThread = Thread.currentThread().getName();
        }

        public int compareTo(Object obj) {
            SQLStatementExec exe = (SQLStatementExec)obj;
            return (int)(this.mTimestamp - exe.mTimestamp);
        }

        public boolean equals(Object obj) {
            if (obj != null && obj instanceof SQLStatementExec) {
                return this.mTimestamp == ((SQLStatementExec)obj).mTimestamp;
            }
            return false;
        }

        public int hashCode() {
            return new Long(this.mTimestamp).hashCode();
        }

        public String toString() {
            return "TS:" + this.mTimestamp + ":TXN:" + this.mOwnerThread + ":SQL:" + this.mStatement;
        }
    }
}

