/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.util.Util;
import java.util.Enumeration;
import java.util.Hashtable;

public class SaveResult
implements RPCSerializable {
    private Hashtable mAssociationResultMap = new Hashtable();
    private Hashtable mObjectAssociationMap = new Hashtable();
    private ObjectID mObjectID;
    private boolean mPersistent;
    private int mUpdateCount;

    protected SaveResult() {
    }

    protected SaveResult(PersistentBean bean) {
        this.setObjectID(bean.getObjectID());
        this.setUpdateCount(bean.getUpdateCount());
        this.setPersistent(bean.isPersistent());
    }

    protected SaveResult(PersistentBean bean, boolean loadAssociations) throws PersistenceManagerException {
        this(bean);
        if (loadAssociations && PersistenceManager.beanManager() != null) {
            PersistenceManager.beanManager().addAssociationToSaveResult(bean, this);
        }
    }

    public ObjectID getObjectID() {
        return this.mObjectID;
    }

    private void setObjectID(ObjectID objectID) {
        this.mObjectID = objectID;
    }

    public int getUpdateCount() {
        return this.mUpdateCount;
    }

    public boolean isPersistent() {
        return this.mPersistent;
    }

    private void setPersistent(boolean inValue) {
        this.mPersistent = inValue;
    }

    private void setUpdateCount(int updateCount) {
        this.mUpdateCount = updateCount;
    }

    void setAssociationResult(String associationKey, SaveResult result) {
        this.mAssociationResultMap.put(associationKey, result);
    }

    SaveResult getAssociationResult(String associationKey) {
        return (SaveResult)this.mAssociationResultMap.get(associationKey);
    }

    void setAssociationResult(String associationKey, SaveResult[] result) {
        this.mAssociationResultMap.put(associationKey, result);
    }

    public void setObjectAssociationResult(String associationKey, Object value) {
        this.mObjectAssociationMap.put(associationKey, value);
    }

    public Object getObjectAssociationResult(String associationKey) {
        return this.mObjectAssociationMap.get(associationKey);
    }

    SaveResult[] getArrayAssociationResult(String associationKey) {
        return (SaveResult[])this.mAssociationResultMap.get(associationKey);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("SaveResult:ID:");
        sb.append(this.mObjectID).append(":persistent:").append(this.mPersistent);
        sb.append(":updCnt:").append(this.mUpdateCount).append(":assoc:");
        Enumeration enumeration = this.mAssociationResultMap.keys();
        while (enumeration.hasMoreElements()) {
            Object key = enumeration.nextElement();
            sb.append(key).append("=");
            Object val = this.mAssociationResultMap.get(key);
            if (val.getClass().isArray()) {
                sb.append(Util.getStringFromArray((Object[])val, ","));
                continue;
            }
            sb.append(val);
        }
        return sb.toString();
    }
}

