/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCInterface;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistentBeanManager;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.cache.CacheKey;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.BeanProcessor;
import com.raplix.rolloutexpress.persist.query.ResultProcessor;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import java.util.Vector;

public final class PersistentServicesInit
implements Messages {
    private static Initializer initializer;
    static /* synthetic */ Class class$com$raplix$rolloutexpress$persist$PersistentBeanManager;

    public static void setInitializer(Initializer init) {
        initializer = init;
    }

    public static Initializer getInitializer() {
        return initializer;
    }

    public static void initializeForMS(RPCManager rpc) {
        PersistentServicesInit.setInitializer(new MSInitializer(rpc));
    }

    public static PersistentBeanManager getServices() throws RPCException, PersistenceManagerException {
        return initializer.getPBMService();
    }

    public static Vector executeQuery(Select inQuery, ResultProcessor inProcessor) throws RPCException, PersistenceManagerException {
        return PersistentServicesInit.getServices().executeQuery(inQuery, inProcessor);
    }

    public static Vector executeSingleQuery(Select query, BeanProcessor processor, String cacheName, CacheKey key) throws PersistenceManagerException, RPCException {
        return PersistentServicesInit.getServices().executeSingleQuery(query, processor, cacheName, key);
    }

    public static boolean executeSingleExists(Select query, Table table, String cacheName, CacheKey key) throws PersistenceManagerException, RPCException {
        return PersistentServicesInit.getServices().executeSingleExists(query, table, cacheName, key);
    }

    public static Vector fetchByIDs(Table table, ObjectID[] inObjectIDs, BeanProcessor inProcessor) throws RPCException, PersistenceManagerException {
        return PersistentServicesInit.getServices().fetchByIDs(table, inObjectIDs, inProcessor);
    }

    public static PersistContext transact(RPCTransaction inTransaction) throws RPCException, PersistenceManagerException {
        return PersistentServicesInit.getServices().transact(inTransaction);
    }

    private PersistentServicesInit() {
    }

    private static class MSInitializer
    extends Initializer {
        public MSInitializer(RPCManager rpc) {
            super(rpc);
        }

        protected RPCInterface getServices() throws RPCException, PersistenceManagerException {
            return this.getLocalPersistService(RoxAddress.local);
        }
    }

    public static abstract class Initializer {
        private RPCManager rpcManager;
        private boolean mCacheServices = true;
        private PersistentBeanManager rpcServices = null;

        protected Initializer(RPCManager inMgr) {
            this.rpcManager = inMgr;
        }

        protected Initializer(RPCManager inMgr, boolean inCacheServices) {
            this.rpcManager = inMgr;
            this.mCacheServices = inCacheServices;
        }

        public final PersistentBeanManager getPBMService() throws RPCException, PersistenceManagerException {
            PersistentBeanManager beanServices = null;
            if (this.rpcServices == null) {
                beanServices = (PersistentBeanManager)this.getServices();
                if (this.mCacheServices) {
                    this.rpcServices = beanServices;
                }
                return beanServices;
            }
            return this.rpcServices;
        }

        protected abstract RPCInterface getServices() throws RPCException, PersistenceManagerException;

        protected RPCInterface getLocalPersistService(RoxAddress addr) throws RPCException {
            return this.rpcManager.getLocalService(addr, class$com$raplix$rolloutexpress$persist$PersistentBeanManager == null ? (class$com$raplix$rolloutexpress$persist$PersistentBeanManager = PersistentServicesInit.class$("com.raplix.rolloutexpress.persist.PersistentBeanManager")) : class$com$raplix$rolloutexpress$persist$PersistentBeanManager);
        }

        protected RPCInterface getPersistService(RoxAddress addr) throws RPCException {
            return this.rpcManager.getService(addr, class$com$raplix$rolloutexpress$persist$PersistentBeanManager == null ? (class$com$raplix$rolloutexpress$persist$PersistentBeanManager = PersistentServicesInit.class$("com.raplix.rolloutexpress.persist.PersistentBeanManager")) : class$com$raplix$rolloutexpress$persist$PersistentBeanManager);
        }
    }
}

