/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.message.ROXMessageManager;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.net.rpc.RPCUtils;
import com.raplix.rolloutexpress.persist.AcquireWriteLockTransaction;
import com.raplix.rolloutexpress.persist.DeleteSession;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionID;
import com.raplix.rolloutexpress.persist.DeleteSessionInfo;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.PersistentBeanManager;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.SaveResult;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.UsingObject;
import com.raplix.rolloutexpress.persist.VersionedObjectID;
import com.raplix.rolloutexpress.persist.VersionedPersistentBean;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.cache.CacheKey;
import com.raplix.rolloutexpress.persist.exception.DeleteSessionExpiredException;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.BeanProcessor;
import com.raplix.rolloutexpress.persist.query.BooleanProcessor;
import com.raplix.rolloutexpress.persist.query.DeleteObjectQuery;
import com.raplix.rolloutexpress.persist.query.LockObjectQuery;
import com.raplix.rolloutexpress.persist.query.NoResultsFoundException;
import com.raplix.rolloutexpress.persist.query.ResultProcessor;
import com.raplix.rolloutexpress.persist.query.RetrieveObjectQuery;
import com.raplix.rolloutexpress.persist.query.SaveMultiObjectQuery;
import com.raplix.rolloutexpress.persist.query.SaveObjectQuery;
import com.raplix.rolloutexpress.persist.query.builder.QueryBuilder;
import com.raplix.rolloutexpress.persist.query.builder.Select;
import com.raplix.rolloutexpress.persist.query.builder.SelectList;
import com.raplix.rolloutexpress.persist.query.builder.Table;
import com.raplix.rolloutexpress.persist.query.builder.VersionedTable;
import com.raplix.rolloutexpress.persist.query.builder.WhereClause;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.util.logger.Logger;
import com.raplix.util.threads.Context;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public final class PersistentBeanManagerImpl
extends QueryBuilder
implements PersistentBeanManager,
Messages {
    private Context mGlobalDeleteContext;
    private Hashtable mDeleteSessions = new Hashtable();
    ThreadLocal mRPCLocal = new ThreadLocal();
    private final String INF_NAME = "com.raplix.rolloutexpress.persist.PersistentBeanManager";
    private static final HashSet SAVE_OBJECT_METHOD = PersistentBeanManagerImpl.getSaveObjectMethod();
    private static final HashSet DELETE_OBJECT_METHOD = PersistentBeanManagerImpl.getDeleteObjectMethod();
    private static final HashSet SESSION_DELETE_METHODS = PersistentBeanManagerImpl.getAllDeleteSessionMethods();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SaveResult saveObject(PersistentBean bean, PersistContext context) throws PersistenceManagerException {
        boolean isValid = this.isRemoteRPCInvocation(PersistenceManager.getInstance().getApplication().getNetSubsystem().getRPC(), SAVE_OBJECT_METHOD);
        ClassMap classMap = this.getClassMap(bean);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Checking if " + bean.getClass().toString() + " is remotely RPC invoked:" + isValid, this);
        }
        try {
            if (isValid && this.preRPC() && !classMap.isRemoteSaveAllowed()) {
                throw new PersistenceManagerException(new ROXMessage("pm.REMOTE_SAVE_OBJECT_NOT_ALLOWED", PersistenceManager.getObjectName(bean.getClass()).toString(), PersistenceManager.getPluralObjectName(bean.getClass()).toString()));
            }
            bean.safeSaveMS(context);
            SaveResult saveResult = bean.createSaveResult();
            return saveResult;
        }
        finally {
            if (isValid) {
                this.postRPC();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteObject(final ObjectID inObjectID, final PersistContext context) throws PersistenceManagerException {
        boolean isValid = this.isRemoteRPCInvocation(PersistenceManager.getInstance().getApplication().getNetSubsystem().getRPC(), DELETE_OBJECT_METHOD);
        ClassMap classMap = this.getClassMap(inObjectID);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Checking if " + inObjectID.getClass().toString() + " is remotely RPC invoked:" + isValid, this);
        }
        try {
            if (isValid && this.preRPC() && !classMap.isRemoteDeleteAllowed()) {
                throw new PersistenceManagerException(new ROXMessage("pm.REMOTE_DELETE_OBJECT_NOT_ALLOWED", PersistenceManager.getObjectName(inObjectID.getClass()).toString(), PersistenceManager.getPluralObjectName(inObjectID.getClass()).toString()));
            }
            PersistenceManager.getInstance().getTransactionManager().transact(new AcquireWriteLockTransaction(){

                public Object execute() throws PersistenceManagerException {
                    inObjectID.deleteMS(context);
                    return null;
                }

                public ROXMessage getLockDescription() {
                    return DeleteSession.MSG_DELETE_LOCK;
                }
            });
        }
        finally {
            if (isValid) {
                this.postRPC();
            }
        }
    }

    public Vector executeQuery(Select query, ResultProcessor processor) throws PersistenceManagerException {
        QueryBuilder.execute(query, processor);
        return processor.getResults();
    }

    public Vector executeSingleQuery(Select query, BeanProcessor processor, String cacheName, CacheKey key) throws PersistenceManagerException {
        PersistentBean bean = null;
        if (cacheName != null) {
            ClassMap classMap = processor.getTable().getClassMap();
            bean = classMap.retrieveBeanFromCache(cacheName, key);
        }
        if (bean != null) {
            processor.addResult(bean);
        } else {
            QueryBuilder.execute(query, processor);
        }
        return processor.getResults();
    }

    public boolean executeSingleExists(Select query, Table table, String cacheName, CacheKey key) throws PersistenceManagerException {
        if (cacheName != null) {
            try {
                this.executeSingleQuery(query, new BeanProcessor(table, true), cacheName, key);
                return true;
            }
            catch (NoResultsFoundException e) {
                return false;
            }
        }
        return this.executeSelectExists(query);
    }

    private boolean executeSelectExists(Select query) throws PersistenceManagerException {
        query = QueryBuilder.selectExists(query);
        BooleanProcessor processor = new BooleanProcessor(true);
        QueryBuilder.execute(query, processor);
        return ((boolean[])processor.getResults().get(0))[0];
    }

    public Vector fetchByIDs(Table table, ObjectID[] inObjectIDs, BeanProcessor processor) throws PersistenceManagerException, RPCException {
        this.retrieve(table, inObjectIDs, processor);
        return processor.getResults();
    }

    public void updateVisibility(VersionedObjectID inObjectID, Visibility inVisibility, PersistContext context) throws RPCException, PersistenceManagerException {
        inObjectID.updateVisibilityMS(inVisibility, context);
    }

    public void updateVisibilityAllVersions(VersionedObjectID inObjectID, Visibility inVisibility, PersistContext context) throws RPCException, PersistenceManagerException {
        inObjectID.updateVisibilityAllVersionsMS(inVisibility, context);
    }

    public PersistContext transact(RPCTransaction inRPCTransaction) throws RPCException, PersistenceManagerException {
        if (inRPCTransaction.executeInDBTransaction()) {
            return (PersistContext)PersistenceManager.getInstance().getTransactionManager().transact(inRPCTransaction);
        }
        return (PersistContext)inRPCTransaction.execute();
    }

    Object transact(Transaction inTransaction) throws PersistenceManagerException {
        return PersistenceManager.getInstance().getTransactionManager().transact(inTransaction);
    }

    public void save(PersistentBean bean) throws PersistenceManagerException {
        ClassMap classMap = this.getClassMap(bean);
        classMap.checkWritePermission();
        final SaveObjectQuery theQuery = new SaveObjectQuery(classMap, bean);
        if (classMap.isPreLocking() && bean.isPersistent()) {
            final ObjectID beanID = bean.getObjectID();
            PersistenceManager.getInstance().getTransactionManager().transact(new Transaction(){

                public Object execute() throws ClassMapException, PersistenceManagerException, QueryException {
                    PersistentBeanManagerImpl.this.lockForUpdate(beanID);
                    theQuery.runQuery();
                    return null;
                }
            }, classMap.getDatabase());
        } else {
            theQuery.runQuery();
        }
    }

    public void save(PersistentBean[] beans) throws PersistenceManagerException {
        ClassMap classMap = this.getClassMap(beans[0]);
        SaveMultiObjectQuery theQuery = new SaveMultiObjectQuery(classMap, beans);
        theQuery.runQuery();
    }

    public void delete(PersistentBean inBean) throws PersistenceManagerException {
        this.delete(this.getClassMap(inBean), inBean.getObjectID());
    }

    void delete(ObjectID inObjectID) throws PersistenceManagerException {
        this.delete(this.getClassMap(inObjectID), inObjectID);
    }

    private void delete(ClassMap classMap, ObjectID inObjectID) throws PersistenceManagerException {
        if (Logger.isDebugEnabled("persist.objectdeletion")) {
            Logger.debug("Deleting object of type " + classMap + " with ID " + inObjectID, "persist.objectdeletion");
        }
        classMap.checkDeletePermission();
        DeleteObjectQuery theQuery = new DeleteObjectQuery(classMap, inObjectID);
        try {
            theQuery.runQuery();
        }
        catch (PersistenceManagerException pme) {
            Logger.debug("Deletion failed: " + pme, "persist.objectdeletion");
            throw pme;
        }
        Logger.debug("Deletion succeeded", "persist.objectdeletion");
    }

    public void retrieve(PersistentBean inBean) throws PersistenceManagerException, QueryException {
        ClassMap classMap = this.getClassMap(inBean);
        classMap.checkReadPermission();
        if (classMap.retrieveCachedObject(inBean)) {
            return;
        }
        RetrieveObjectQuery theQuery = new RetrieveObjectQuery(classMap, inBean);
        theQuery.runQuery();
    }

    public PersistentBean retrieve(ObjectID inObjectID) throws PersistenceManagerException {
        ClassMap classMap = this.getClassMap(inObjectID);
        classMap.checkReadPermission();
        PersistentBean bean = null;
        bean = classMap.retrieveCachedObject(inObjectID);
        if (bean != null) {
            return bean;
        }
        bean = classMap.newInstance();
        bean.setObjectID(inObjectID);
        RetrieveObjectQuery theQuery = new RetrieveObjectQuery(classMap, bean);
        theQuery.runQuery();
        return bean;
    }

    private void retrieve(Table t, ObjectID[] inObjectIDs, BeanProcessor processor) throws PersistenceManagerException {
        ClassMap classMap = t.getClassMap();
        classMap.checkReadPermission();
        ArrayList result = new ArrayList();
        HashSet<ObjectID> uncachedIDs = new HashSet<ObjectID>();
        HashSet<ObjectID> cachedIDs = new HashSet<ObjectID>();
        for (int i = 0; i < inObjectIDs.length; ++i) {
            ObjectID curID = inObjectIDs[i];
            if (cachedIDs.contains(curID)) continue;
            PersistentBean bean = classMap.retrieveCachedObject(curID);
            if (bean == null) {
                uncachedIDs.add(curID);
                continue;
            }
            processor.addResult(bean);
            cachedIDs.add(curID);
        }
        if (uncachedIDs.size() > 0) {
            ObjectID[] ids = uncachedIDs.toArray(new ObjectID[uncachedIDs.size()]);
            Table.execute(t.select(Table.where(Table.emptyIn(t.ID, Table.rList(ids)))), processor);
        }
    }

    void lockForUpdate(ObjectID inObjectID) throws PersistenceManagerException {
        ClassMap classMap = this.getClassMap(inObjectID);
        classMap.checkWritePermission();
        LockObjectQuery theQuery = new LockObjectQuery(classMap, inObjectID);
        theQuery.runQuery();
    }

    void updateVisibility(final VersionedObjectID inObjectID, final Visibility inVisibility) throws PersistenceManagerException {
        ClassMap map = this.getClassMap(inObjectID);
        map.checkWritePermission();
        final VersionedTable table = (VersionedTable)map.getTable();
        final Select idSel = PersistentBeanManagerImpl.anonSelect(PersistentBeanManagerImpl.sList(PersistentBeanManagerImpl.v(inObjectID)));
        table.checkFolderPerm(idSel);
        this.transact(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                table.updateVisibilityWhere(inVisibility, QueryBuilder.where(QueryBuilder.equals(table.cID(), inObjectID)));
                table.notifyDependenciesOfUpdate(idSel);
                return null;
            }
        });
    }

    void updateVisibilityAllVersions(VersionedObjectID inObjectID, final Visibility inVisibility) throws PersistenceManagerException {
        ClassMap map = this.getClassMap(inObjectID);
        map.checkWritePermission();
        final VersionedTable table = (VersionedTable)map.getTable();
        final WhereClause where = PersistentBeanManagerImpl.where(table.isVersionOf(inObjectID));
        final Select idSel = table.select(PersistentBeanManagerImpl.sList(table.ID), where);
        table.checkFolderPerm(idSel);
        this.transact(new Transaction(){

            public Object execute() throws PersistenceManagerException {
                table.updateVisibilityWhere(inVisibility, where);
                table.notifyDependenciesOfUpdate(idSel);
                return null;
            }
        });
    }

    public ClassMap getClassMap(PersistentBean inBean) throws ClassMapException {
        ClassMap theClassMap = PersistenceManager.getInstance().getClassMap(inBean.getClass().getName());
        if (theClassMap == null) {
            throw new ClassMapException(new ROXMessage("pm.cm.NO_CLASSMAP_FOR_CLASS", new String[]{inBean.getClass().getName()}));
        }
        return theClassMap;
    }

    public ObjectID getObjectID(PersistentBean inBean) {
        return inBean.getObjectID();
    }

    public void setObjectID(PersistentBean inBean, ObjectID inObjectID) {
        inBean.setObjectID(inObjectID);
    }

    public int getUpdateCount(PersistentBean inBean) {
        return inBean.getUpdateCount();
    }

    public void setUpdateCount(PersistentBean inBean, int inUpdateCount) {
        inBean.setUpdateCount(inUpdateCount);
    }

    public boolean isPersistent(PersistentBean inBean) {
        return inBean.isPersistent();
    }

    public void setPersistent(PersistentBean inBean, boolean inValue) {
        inBean.setPersistent(inValue);
    }

    public SaveResult createSaveResult(PersistentBean inBean) throws PersistenceManagerException {
        SaveResult result = inBean.createSaveResult();
        return result;
    }

    public void setSaveResult(PersistentBean inBean, SaveResult inValue) throws PersistenceManagerException {
        inBean.setSaveResult(inValue);
    }

    public void setAssociation(SaveResult result, String associationKey, SaveResult associationResult) {
        result.setAssociationResult(associationKey, associationResult);
    }

    public void setAssociation(SaveResult result, String associationKey, SaveResult[] associationResult) {
        result.setAssociationResult(associationKey, associationResult);
    }

    public SaveResult getAssociation(SaveResult result, String key) {
        return result.getAssociationResult(key);
    }

    public SaveResult[] getArrayAssociation(SaveResult result, String key) {
        return result.getArrayAssociationResult(key);
    }

    public void incrementUpdateCount(PersistentBean inBean) {
        inBean.setUpdateCount(PersistentBean.getNextUpdateCount(inBean.getUpdateCount()));
    }

    void addAssociationToSaveResult(PersistentBean inBean, SaveResult inResult) throws PersistenceManagerException {
        this.getClassMap(inBean).addAssociationToSaveResult(inBean, inResult);
    }

    void setAssociationFromSaveResult(PersistentBean inBean, SaveResult inResult) throws PersistenceManagerException {
        this.getClassMap(inBean).setAssociationFromSaveResult(inBean, inResult);
    }

    ClassMap getClassMap(ObjectID inObjectID) throws ClassMapException {
        ClassMap theClassMap = PersistenceManager.getInstance().getClassMap(inObjectID);
        if (theClassMap == null) {
            throw new ClassMapException(new ROXMessage("pm.cm.NO_CLASSMAP_FOR_OBJECTID", new String[]{inObjectID.getClass().getName()}));
        }
        return theClassMap;
    }

    synchronized Context getDeleteContext() {
        if (this.mGlobalDeleteContext == null) {
            this.setDeleteContext(new Context("Delete_Context"));
        }
        return this.mGlobalDeleteContext;
    }

    private synchronized void setDeleteContext(Context inContext) {
        this.mGlobalDeleteContext = inContext;
    }

    public DeleteSessionID delete(IDResolvingTypedSet inObjectsToDelete) throws PersistenceManagerException, RPCException {
        return this.delete(inObjectsToDelete, false, false);
    }

    public DeleteSessionID delete(IDResolvingTypedSet inObjectsToDelete, boolean inConfirmedDelete) throws PersistenceManagerException, RPCException {
        return this.delete(inObjectsToDelete, inConfirmedDelete, false);
    }

    public DeleteSessionID deleteSynchronous(IDResolvingTypedSet inObjectsToDelete) throws RPCException, PersistenceManagerException {
        return this.delete(inObjectsToDelete, true, true);
    }

    protected DeleteSessionID delete(IDResolvingTypedSet inObjectsToDelete, boolean inConfirmedDelete, boolean inSynchronous) throws PersistenceManagerException, RPCException {
        DeleteSessionID id = null;
        boolean isRemote = this.isRemoteRPCInvocation(PersistenceManager.getInstance().getApplication().getNetSubsystem().getRPC(), SESSION_DELETE_METHODS);
        try {
            DeleteSession session = new DeleteSession(DeleteSessionID.generateDeleteSessionID(), inObjectsToDelete, this.getDeleteContext(), inConfirmedDelete, isRemote);
            id = session.getID();
            this.mDeleteSessions.put(id, session);
            if (inSynchronous) {
                session.safeRun();
            } else {
                PersistenceManager.getInstance().startSubsystemTask(session);
            }
        }
        catch (Throwable t) {
            throw new PersistenceManagerException(t);
        }
        return id;
    }

    void removeDeleteSession(DeleteSessionID inSessionID) throws RPCException, PersistenceManagerException {
        this.mDeleteSessions.remove(inSessionID);
    }

    public void confirmDelete(DeleteSessionID inSessionID) throws RPCException, PersistenceManagerException {
        this.getDeleteSession(inSessionID).confirm();
    }

    public void cancelDelete(DeleteSessionID inSessionID) throws RPCException, PersistenceManagerException {
        this.getDeleteSession(inSessionID).cancel();
    }

    public Vector getDeleteCandidates(DeleteSessionID inSessionID) throws RPCException, PersistenceManagerException {
        return this.getDeleteSession(inSessionID).getCandidates();
    }

    protected DeleteSession getDeleteSession(DeleteSessionID inSessionID) throws PersistenceManagerException {
        DeleteSession session = (DeleteSession)this.mDeleteSessions.get(inSessionID);
        if (null == session) {
            throw new DeleteSessionExpiredException();
        }
        return session;
    }

    public void checkVersionedObjectInUse(ObjectID inObjectID, DeleteSessionContext inContext) throws PersistenceManagerException, RPCException {
        PersistentBean bean;
        if (Logger.isDebugEnabled("persist.objectdeletion")) {
            Logger.debug("Checking " + inObjectID + " to see if it is versioned and in use", "persist.objectdeletion");
        }
        if ((bean = this.retrieve(inObjectID)) instanceof VersionedPersistentBean) {
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("object is a versionedpersistentbean", "persist.objectdeletion");
            }
            try {
                VersionedPersistentBean vbean = (VersionedPersistentBean)bean;
                if (vbean.getRootObjectID().equals(vbean.getObjectID())) {
                    if (Logger.isDebugEnabled("persist.objectdeletion")) {
                        Logger.debug("object is the root of the family", "persist.objectdeletion");
                    }
                    ClassMap theMap = this.getClassMap(vbean);
                    VersionedTable table = (VersionedTable)theMap.getTable();
                    PersistentBean[] familyMembers = VersionedTable.executeMultiResult(VersionedTable.select((SelectList)table.allColumns(), VersionedTable.tList(table), VersionedTable.where(VersionedTable.equals(table.RootID, vbean.getRootObjectID())), VersionedTable.oList(VersionedTable.orderByDesc(table.Version))), table);
                    if (Logger.isDebugEnabled("persist.objectdeletion")) {
                        Logger.debug("family has " + familyMembers.length + " members", "persist.objectdeletion");
                    }
                    if (familyMembers.length > 1) {
                        Hashtable<ObjectID, PersistentBean> objectMap = new Hashtable<ObjectID, PersistentBean>();
                        for (int i = 0; i < familyMembers.length - 1; ++i) {
                            if (inContext.objectWillBeDeletedPriorTo(familyMembers[i].getObjectID(), inObjectID)) continue;
                            objectMap.put(familyMembers[i].getObjectID(), familyMembers[i]);
                        }
                        if (objectMap.size() > 0) {
                            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                                Logger.debug("The list of objects to delete included the root but did not include all the members of the family", "persist.objectdeletion");
                            }
                            if (vbean instanceof UsingObject) {
                                throw new ObjectInUseException((ROXMessage)ROXMessageManager.message("pm.ROOT_VERSION_IN_USE"), new UsingObject[]{(UsingObject)((Object)vbean)});
                            }
                            throw new ObjectInUseException((ROXMessage)ROXMessageManager.message("pm.ROOT_VERSION_IN_USE"));
                        }
                    }
                }
            }
            catch (ObjectInUseException oiue) {
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Object is in use", "persist.objectdeletion");
                }
                throw oiue;
            }
            catch (CommandException ce) {
                if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("caught exception: " + ce, "persist.objectdeletion");
                }
                throw new PersistenceManagerException(ce);
            }
        }
    }

    public DeleteSessionInfo getDeleteSessionInfo(DeleteSessionID inDeleteSessionID) throws PersistenceManagerException {
        return this.getDeleteSession(inDeleteSessionID).getSessionInfo();
    }

    boolean preRPC() {
        boolean returnValue = false;
        MutableInt value = (MutableInt)this.mRPCLocal.get();
        if (value == null) {
            value = new MutableInt();
            this.mRPCLocal.set(value);
        }
        if (value.mValue == 0) {
            returnValue = true;
        }
        ++value.mValue;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("preRPC returning " + returnValue + ":" + value.mValue, this);
        }
        return returnValue;
    }

    void postRPC() {
        MutableInt value = (MutableInt)this.mRPCLocal.get();
        if (value == null || value.mValue == 0) {
            throw new IllegalStateException("Error in postRPC");
        }
        --value.mValue;
    }

    private boolean isRemoteRPCInvocation(RPCManager inRPC, HashSet inMethodSigList) {
        boolean isRemote;
        boolean bl = isRemote = !inRPC.getInvokerTransportInfo().isLocal();
        if (isRemote) {
            boolean isCorrectMethodName;
            boolean isCorrectInterfaceName = inRPC.getInvokedInterfaceName() != null && inRPC.getInvokedInterfaceName().equals("com.raplix.rolloutexpress.persist.PersistentBeanManager");
            boolean bl2 = isCorrectMethodName = inRPC.getInvokedMethodSignature() != null && inMethodSigList.contains(inRPC.getInvokedMethodSignature());
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Returning:is Remote=" + isRemote + ", interface name=" + isCorrectInterfaceName + ", method name=" + isCorrectMethodName, this);
            }
            return isRemote && isCorrectInterfaceName && isCorrectMethodName;
        }
        return false;
    }

    private static HashSet getSaveObjectMethod() {
        HashSet<String> methodSigList = new HashSet<String>();
        try {
            methodSigList.add(RPCUtils.getMethodSignature(PersistentBeanManager.class.getMethod("saveObject", PersistentBean.class, PersistContext.class)));
        }
        catch (NoSuchMethodException nsm) {
            throw new IllegalStateException(nsm.getMessage());
        }
        return methodSigList;
    }

    private static HashSet getDeleteObjectMethod() {
        HashSet<String> methodSigList = new HashSet<String>();
        try {
            methodSigList.add(RPCUtils.getMethodSignature(PersistentBeanManager.class.getMethod("deleteObject", ObjectID.class, PersistContext.class)));
        }
        catch (NoSuchMethodException nsm) {
            throw new IllegalStateException(nsm.getMessage());
        }
        return methodSigList;
    }

    private static HashSet getAllDeleteSessionMethods() {
        HashSet<String> methodSigList = new HashSet<String>();
        try {
            methodSigList.add(RPCUtils.getMethodSignature(PersistentBeanManager.class.getMethod("delete", IDResolvingTypedSet.class)));
            methodSigList.add(RPCUtils.getMethodSignature(PersistentBeanManager.class.getMethod("delete", IDResolvingTypedSet.class, Boolean.TYPE)));
            methodSigList.add(RPCUtils.getMethodSignature(PersistentBeanManager.class.getMethod("deleteSynchronous", IDResolvingTypedSet.class)));
        }
        catch (NoSuchMethodException nsm) {
            throw new IllegalStateException(nsm.getMessage());
        }
        return methodSigList;
    }

    private static class MutableInt {
        int mValue = 0;

        private MutableInt() {
        }
    }
}

