/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBeanManager;
import com.raplix.rolloutexpress.persist.PersistentServicesInit;
import com.raplix.rolloutexpress.persist.ReEntrantTransaction;
import com.raplix.rolloutexpress.persist.SQLDeadlockException;
import com.raplix.rolloutexpress.persist.SaveResult;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.TransactionManager;
import com.raplix.rolloutexpress.persist.Visibility;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.util.logger.Logger;

public class PersistentBean
implements RPCSerializable,
HasObjectID {
    public static final int MAX_RETRIES_DEADLOCK = 3;
    private ObjectID mObjectID = null;
    private Visibility mVisibility = Visibility.VISIBLE;
    private int mUpdateCount = 0;
    public static final String UPDATE_COUNT_COL_NAME = "C_UPDATE_COUNT";
    public static final String UPDATE_COUNT_ATTRIB_NAME = "UpdateCount";
    public static final String VISIBILITY_COL_NAME = "C_VISIBILITY";
    public static final String VISIBILITY_ATTRIB_NAME = "Visibility";
    public static final int MAX_UPD_COUNT = Integer.MAX_VALUE;
    public static final int MIN_UPD_COUNT = 1;
    private boolean mIsPersistent = false;

    protected PersistentBean() {
    }

    public ObjectID getObjectID() {
        return this.mObjectID;
    }

    void setObjectID(ObjectID objectID) {
        this.mObjectID = objectID;
    }

    protected Visibility getVisibility() {
        return this.mVisibility;
    }

    protected void setVisibility(Visibility visibility) {
        if (visibility == null) {
            throw new NullPointerException();
        }
        this.mVisibility = visibility;
    }

    protected int getUpdateCount() {
        return this.mUpdateCount;
    }

    protected void setUpdateCount(int updateCount) {
        this.mUpdateCount = updateCount;
    }

    protected Object getObjectDataClone() throws CloneNotSupportedException {
        PersistentBean result = (PersistentBean)this.clone();
        result.setObjectID(null);
        result.setUpdateCount(0);
        result.setVisibility(Visibility.VISIBLE);
        result.setPersistent(false);
        return result;
    }

    protected void saveRPC(PersistContext context) throws PersistenceManagerException, RPCException {
        SaveResult result = PersistentBean.getRPCServices().saveObject(this, context);
        this.setSaveResult(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void safeSaveMS(PersistContext ctx) throws PersistenceManagerException {
        SaveResult initialState = this.createSaveResult();
        boolean success = false;
        try {
            this.saveMS(ctx);
            success = true;
        }
        finally {
            if (!success) {
                this.setSaveResult(initialState);
            }
        }
    }

    protected void saveMS(PersistContext context) throws PersistenceManagerException {
        PersistenceManager.getBeanManager().save(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected static void saveMultipleMS(PersistentBean[] beans) throws PersistenceManagerException {
        if (beans == null || beans.length <= 0) return;
        SaveResult[] initStates = new SaveResult[beans.length];
        for (int i = 0; i < beans.length; ++i) {
            initStates[i] = beans[i].createSaveResult();
        }
        boolean success = false;
        try {
            PersistenceManager.getBeanManager().save(beans);
            return;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            if (success) throw throwable;
            for (int i = 0; i < beans.length; ++i) {
                beans[i].setSaveResult(initStates[i]);
            }
            throw throwable;
        }
    }

    protected SaveResult createSaveResult() throws PersistenceManagerException {
        return new SaveResult(this, true);
    }

    protected void setSaveResult(SaveResult saveResult) throws PersistenceManagerException {
        this.setObjectID(saveResult.getObjectID());
        this.setUpdateCount(saveResult.getUpdateCount());
        this.setPersistent(saveResult.isPersistent());
        if (PersistenceManager.beanManager() != null) {
            PersistenceManager.beanManager().setAssociationFromSaveResult(this, saveResult);
        }
    }

    protected static Object retryOnDeadlock(ReEntrantTransaction inTransaction) throws PersistenceManagerException {
        SQLDeadlockException exp = null;
        for (int i = 0; i < 3; ++i) {
            try {
                exp = null;
                return inTransaction.execute();
            }
            catch (SQLDeadlockException sde) {
                exp = sde;
                if (!Logger.isWarnEnabled(class$com$raplix$rolloutexpress$persist$PersistentBean == null ? PersistentBean.class$("com.raplix.rolloutexpress.persist.PersistentBean") : class$com$raplix$rolloutexpress$persist$PersistentBean)) continue;
                Logger.warn(new ROXMessage("pm.txn.deadlock_detected_recommit").getMessageString(), sde, class$com$raplix$rolloutexpress$persist$PersistentBean == null ? PersistentBean.class$("com.raplix.rolloutexpress.persist.PersistentBean") : class$com$raplix$rolloutexpress$persist$PersistentBean);
                continue;
            }
        }
        if (exp != null) {
            if (Logger.isErrorEnabled(PersistentBean.class)) {
                Logger.error(new ROXMessage("pm.txn.deadlock_recommit_abort", String.valueOf(3)).getMessageString(), exp, PersistentBean.class);
            }
            throw exp;
        }
        return null;
    }

    public static int getNextUpdateCount(int inUpdateCount) {
        return inUpdateCount < Integer.MAX_VALUE ? ++inUpdateCount : 1;
    }

    static PersistentBeanManager getRPCServices() throws RPCException, PersistenceManagerException {
        return PersistentServicesInit.getServices();
    }

    boolean isPersistent() {
        return this.mIsPersistent;
    }

    void setPersistent(boolean inIsPersistent) {
        this.mIsPersistent = inIsPersistent;
    }

    protected static Object transactMS(Transaction inTxn) throws PersistenceManagerException {
        return PersistentBean.getTransactionManagerMS().transact(inTxn);
    }

    protected static TransactionManager getTransactionManagerMS() {
        return PersistenceManager.getInstance().getTransactionManager();
    }
}

