/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.persist.AcquireWriteLockTransaction;
import com.raplix.rolloutexpress.persist.DebugDeadlockTransactionManager;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PMSQLException;
import com.raplix.rolloutexpress.persist.PersistentBeanManager;
import com.raplix.rolloutexpress.persist.PersistentBeanManagerImpl;
import com.raplix.rolloutexpress.persist.PersistentServicesInit;
import com.raplix.rolloutexpress.persist.TransactionManager;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.persist.map.MapXMLReader;
import com.raplix.rolloutexpress.persist.map.TableMap;
import com.raplix.rolloutexpress.persist.map.attribute.AttributeMap;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.RawSQLQuery;
import com.raplix.rolloutexpress.persist.query.RetriveTableInformationQuery;
import com.raplix.rolloutexpress.persist.query.SystemDataQuery;
import com.raplix.rolloutexpress.persist.query.VersionQuery;
import com.raplix.rolloutexpress.persist.sql.DBConnectionInfo;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.PostgresSQLDatabase;
import com.raplix.rolloutexpress.persist.sql.SQLParser;
import com.raplix.rolloutexpress.systemmodel.plugindb.PluginImplTable;
import com.raplix.util.logger.Logger;
import com.raplix.util.rwlock.RWLock;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public final class PersistenceManager
extends Subsystem
implements Messages {
    private Hashtable mClassMaps = new Hashtable();
    private Hashtable mTableMaps = new Hashtable();
    private Hashtable mIDMaps = new Hashtable();
    private Hashtable mDatabases = new Hashtable();
    private TransactionManager mTransactionManager;
    private Database mDefaultDatabase = null;
    private PersistentBeanManagerImpl mBeanManager;
    private Hashtable mPermissionMap = new Hashtable();
    private static boolean mInitTables = true;
    private static PersistenceManager sInstance = null;
    public static final String CONFIG_PROPERTY_PREFIX = "db.";
    public static final String RDBMS_ROOT = "/rdbms/";
    public static final String MAPPING_FILE = "/rdbms/mapping/mapping.xml";
    public static final String CREATE_SCHEMA_FILE = "/rox_create_schema.sql";
    public static final String CREATE_DATA_FILE = "/rox_create_data.sql";
    public static final String DROP_SCHEMA_FILE = "/rox_drop_schema.sql";
    public static final String VERSION_FILE = "/version.properties";
    public static final String CONFIG_VARNAME_DB_HOSTNAME = "hostname";
    public static final String CONFIG_VARNAME_DB_PORT = "port";
    public static final String CONFIG_VARNAME_DB_INSTANCE_NAME = "instancename";
    public static final String CONFIG_VARNAME_DB_USERNAME = "username";
    public static final String CONFIG_VARNAME_DB_PASSWORD = "password";
    public static final String CONFIG_VARNAME_DB_MAPPING_FILE = "mappingfile";
    public static final String CONFIG_VARNAME_DB_SQL_GEN_OUTPUT_FILE = "sqlgenoutput";
    public static final String CONFIG_VARNAME_DB_TYPE = "type";
    public static final String CONFIG_VARNAME_DB_INIT_SCHEMA = "initschema";
    public static final String CONFIG_VARNAME_DB_MAX_CONNECTIONS = "maxconnections";
    public static final String CONFIG_VARNAME_DB_CONNECTION_CHECKOUT_LIMIT = "connectioncheckoutlimit";
    public static final String CONFIG_VARNAME_DB_DEBUG_DEADLOCK = "debugdeadlock";
    public static final String CONFIG_VARNAME_DB_CONN_RETRY_COUNT = "connectionretrycount";
    public static final String CONFIG_VARNAME_DB_CONN_RETRY_INTERVAL = "connectionretryinterval";
    public static final String DEFAULT_CONFIG_DB_HOSTNAME = "localhost";
    public static final int DEFAULT_CONFIG_DB_PORT = 5432;
    public static final String DEFAULT_CONFIG_DB_USERNAME = "rox";
    public static final String DEFAULT_CONFIG_DB_PASSWORD = "rox";
    public static final String DEFAULT_CONFIG_DB_MAPPING_FILE = "/rdbms/mapping/mapping.xml";
    public static final String DEFAULT_CONFIG_DB_SQL_GEN_OUTPUT_FILE = "gen_sql.sql";
    public static final String DEFAULT_CONFIG_DB_TYPE = "postgressql";
    public static final boolean DEFAULT_CONFIG_DB_INIT_SCHEMA = false;
    public static final int DEFAULT_CONFIG_DB_MAX_CONNECTIONS = 5;
    public static final int DEFAULT_CONFIG_DB_CONNECTION_CHECKOUT_LIMIT = 86400000;
    public static final boolean DEFAULT_CONFIG_DB_DEBUG_DEADLOCK = true;
    public static final int DEFAULT_CONFIG_DB_CONN_RETRY_COUNT = 3;
    public static final int DEFAULT_CONFIG_DB_CONN_RETRY_INTERVAL = 10;
    public static final String DOC_CONFIG_DB_HOSTNAME = "IPAddress or Hostname of the machine running the DB";
    public static final String DOC_CONFIG_DB_PORT = "Port the DB is running on";
    public static final String DOC_CONFIG_DB_INSTANCE_NAME = "Instance name for the DB - this is the name of the database.";
    public static final String DOC_CONFIG_DB_USERNAME = "Username to connect as";
    public static final String DOC_CONFIG_DB_PASSWORD = "Password to connect with";
    public static final String DOC_CONFIG_DB_MAPPING_FILE = "Source Mapping file for classes";
    public static final String DOC_CONFIG_DB_SQL_GEN_OUTPUT_FILE = "Output of the SQL Generator";
    public static final String DOC_CONFIG_DB_TYPE = "database type (e.g. postgressql, oracle)";
    public static final String DOC_CONFIG_DB_INIT_SCHEMA = "true allows automatic version-based schema upgrades (existing data is lost)";
    public static final String DOC_CONFIG_DB_MAX_CONNECTIONS = "maximum number of open database connections";
    public static final String DOC_CONFIG_DB_CONNECTION_CHECKOUT_LIMIT = "Maximum amount of time a thread can use a conneciton before it is collected";
    public static final String DOC_CONFIG_DB_DEBUG_DEADLOCK = "If we should print out debugging information when deadlock errors are detected";
    public static final String DOC_CONFIG_DB_CONN_RETRY_COUNT = "Number of times we should retry connecting to the database during the database during system startup.";
    public static final String DOC_CONFIG_DB_CONN_RETRY_INTERVAL = "Number of seconds between database connection retry attempts";
    private int mExpectedVersion;
    private boolean mReInitSchema;
    private final RWLock mSystemLockObject = new RWLock();

    public String getConfigDBHostname() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_DB_HOSTNAME);
    }

    public int getConfigDBPort() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_DB_PORT);
    }

    public String getConfigDBInstanceName() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_DB_INSTANCE_NAME);
    }

    public String getConfigDBUsername() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_DB_USERNAME);
    }

    public String getConfigDBPassword() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_DB_PASSWORD);
    }

    public String getConfigDBMappingFile() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_DB_MAPPING_FILE);
    }

    public String getConfigDBSqlGenOutputFile() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_DB_SQL_GEN_OUTPUT_FILE);
    }

    public String getConfigDBType() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_VARNAME_DB_TYPE);
    }

    public boolean getConfigDBInitSchema() throws ConfigurationException {
        return this.getConfigurationAsBoolean(CONFIG_VARNAME_DB_INIT_SCHEMA);
    }

    public int getConfigDBMaxConnections() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_DB_MAX_CONNECTIONS);
    }

    public int getConfigDBConnectionCheckoutLimit() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_DB_CONNECTION_CHECKOUT_LIMIT);
    }

    public boolean getConfigDBDebugDeadlock() throws ConfigurationException {
        return this.getConfigurationAsBoolean(CONFIG_VARNAME_DB_DEBUG_DEADLOCK);
    }

    public int getConfigDBConnRetryCount() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_DB_CONN_RETRY_COUNT);
    }

    public int getConfigDBConnRetryInterval() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_VARNAME_DB_CONN_RETRY_INTERVAL);
    }

    private PersistenceManager() {
    }

    public PersistenceManager(Application inApplication) throws ConfigurationException {
        this(inApplication, true);
    }

    public static PersistenceManager createPMForTableGen(Application inApp, boolean inReadMapping) throws ConfigurationException {
        mInitTables = false;
        return new PersistenceManager(inApp, inReadMapping);
    }

    public PersistenceManager(Application inApplication, boolean inReadMapping) throws ConfigurationException {
        this(inApplication, inReadMapping, null, false);
    }

    public PersistenceManager(Application inApplication, boolean inReadMapping, String[] inMappingFiles, boolean inDisableClassMapVerification) throws ConfigurationException {
        super(inApplication);
        sInstance = this;
        this.mBeanManager = new PersistentBeanManagerImpl();
        this.mTransactionManager = this.getConfigDBDebugDeadlock() ? new DebugDeadlockTransactionManager() : new TransactionManager();
        DBConnectionInfo connInfo = new DBConnectionInfo(this.getConfigDBHostname(), this.getConfigDBPort(), this.getConfigDBInstanceName(), this.getConfigDBUsername(), this.getConfigDBPassword());
        this.mDefaultDatabase = new PostgresSQLDatabase(connInfo, this.getConfigDBMaxConnections(), this.getConfigDBConnectionCheckoutLimit());
        this.addDatabase(this.mDefaultDatabase);
        if (inReadMapping) {
            this.initGlobalMapping(this.mDefaultDatabase, inMappingFiles, inDisableClassMapVerification);
        }
    }

    private void initGlobalMapping(Database db, String[] inMappingFiles, boolean inDisableClassMapVerification) throws ConfigurationException {
        this.initSchema(db);
        List<InputStream> mappingFileList = Collections.synchronizedList(new ArrayList());
        mappingFileList.add(this.getClass().getResourceAsStream(this.getConfigDBMappingFile()));
        if (inMappingFiles != null && inMappingFiles.length > 0) {
            for (int x = 0; x < inMappingFiles.length; ++x) {
                mappingFileList.add(this.getClass().getResourceAsStream(inMappingFiles[x]));
            }
        }
        try {
            MapXMLReader theReader = new MapXMLReader(this, mappingFileList.toArray(new InputStream[mappingFileList.size()]), inDisableClassMapVerification);
            theReader.readFromXML();
        }
        catch (ClassMapException e) {
            throw new ConfigurationException(new ROXMessage("pm.COULD_NOT_OPEN_MAPPING_FILE"), (Throwable)e, 1);
        }
    }

    private String getVersionFilename() throws ConfigurationException {
        return RDBMS_ROOT + this.getConfigDBType() + VERSION_FILE;
    }

    private String getCreateSchemaFilename() throws ConfigurationException {
        return RDBMS_ROOT + this.getConfigDBType() + CREATE_SCHEMA_FILE;
    }

    private String getCreateDataFilename() throws ConfigurationException {
        return RDBMS_ROOT + this.getConfigDBType() + CREATE_DATA_FILE;
    }

    private String getDropSchemaFilename() throws ConfigurationException {
        return RDBMS_ROOT + this.getConfigDBType() + DROP_SCHEMA_FILE;
    }

    private void initSchema(Database db) throws ConfigurationException {
        this.mReInitSchema = false;
        if (!this.getConfigDBInitSchema()) {
            return;
        }
        int version = this.getSchemaVersion(db);
        this.mExpectedVersion = this.getExpectedSchemaVersion();
        if (version < this.mExpectedVersion) {
            this.dropSchema(db);
            this.createSchema(db);
            this.mReInitSchema = true;
        }
    }

    private int getSchemaVersion(Database db) throws ConfigurationException {
        try {
            String versionKey = VersionQuery.MAPPING_SCHEMA_VERSION;
            VersionQuery vq = new VersionQuery(db, versionKey);
            return vq.getVersion();
        }
        catch (PMSQLException e) {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("ignoring error reading version: " + e, this);
            }
            return -1;
        }
        catch (PersistenceManagerException e) {
            throw new ConfigurationException(new ROXMessage("pm.UNABLE_TO_CHECK_SCHEMA_VERSION"), (Throwable)e, 1);
        }
    }

    private void setSchemaVersion(Database db, int version) throws ConfigurationException {
        try {
            String versionKey = VersionQuery.MAPPING_SCHEMA_VERSION;
            String setVersion = "INSERT INTO ROX_VERSION(C_VERSION, C_TYPE) VALUES(" + version + ",'" + versionKey + "')";
            new RawSQLQuery(db, setVersion).runQuery();
        }
        catch (Exception e) {
            throw new ConfigurationException(new ROXMessage("pm.ERROR_UPDATING_SCHEMA_VERSION"), (Throwable)e, 1);
        }
    }

    private int getExpectedSchemaVersion() throws ConfigurationException {
        String versionFilename = this.getVersionFilename();
        InputStream is = this.getClass().getResourceAsStream(versionFilename);
        if (is == null) {
            if (Logger.isWarnEnabled(this)) {
                Logger.warn("unable to read version file: " + versionFilename, this);
            }
            return -1;
        }
        try {
            Properties versionProps = new Properties();
            versionProps.load(is);
            String versionKey = VersionQuery.MAPPING_SCHEMA_VERSION;
            String versionStr = versionProps.getProperty(versionKey);
            if (versionStr != null) {
                try {
                    return Integer.parseInt(versionStr);
                }
                catch (NumberFormatException e) {
                    throw new ConfigurationException(new ROXMessage("pm.INVALID_SCHEMA_VERSION", new String[]{versionStr}), (Throwable)e, 1);
                }
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(new ROXMessage("pm.ERROR_READING_SCHEMA_VERSION_FILE"), (Throwable)e, 1);
        }
        return -1;
    }

    private void createSchema(Database db) throws ConfigurationException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("creating schema for mapping file", this);
        }
        this.executeSQLResource(db, this.getCreateSchemaFilename(), false);
    }

    private void createData(Database db) throws ConfigurationException {
        this.executeSQLResource(db, this.getCreateDataFilename(), false);
    }

    private void dropSchema(Database db) throws ConfigurationException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("dropping schema for mapping file", this);
        }
        this.executeSQLResource(db, this.getDropSchemaFilename(), true);
    }

    private void executeSQLResource(Database db, String resourceName, boolean ignoreErrors) throws ConfigurationException {
        InputStream is = this.getClass().getResourceAsStream(resourceName);
        if (is == null) {
            if (Logger.isWarnEnabled(this)) {
                Logger.warn("unable to read mapping schema file: " + resourceName, this);
            }
            return;
        }
        try {
            String sql;
            SQLParser parser = new SQLParser(is);
            while ((sql = parser.getNextStatement()) != null) {
                this.execSQL(db, sql, ignoreErrors);
            }
        }
        catch (IOException e) {
            throw new ConfigurationException(new ROXMessage("pm.ERROR_READING_SQL_CREATE_FILE"), (Throwable)e, 1);
        }
    }

    private void execSQL(Database db, String sql, boolean ignoreErrors) throws ConfigurationException {
        try {
            new RawSQLQuery(db, sql).runQuery();
        }
        catch (PMSQLException e) {
            if (ignoreErrors) {
                if (Logger.isDebugEnabled(this)) {
                    Logger.debug("ignoring sql execution error: " + e, this);
                }
            }
            throw this.execSQLError(e);
        }
        catch (Exception e) {
            throw this.execSQLError(e);
        }
    }

    private ConfigurationException execSQLError(Exception e) {
        return new ConfigurationException(new ROXMessage("pm.ERROR_RUNNING_SQL_CREATE_FILE"), (Throwable)e, 1);
    }

    public void shutdown() throws RaplixShutdownException {
        Enumeration e = this.mDatabases.elements();
        while (e.hasMoreElements()) {
            Database currDB = (Database)e.nextElement();
            currDB.shutdown();
        }
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        String defaultInstanceName = this.mApplication != null ? this.mApplication.getSystemUser() : System.getProperty("user.name");
        DefaultConfiguration[] defaultConfiguration = new DefaultConfiguration[]{new DefaultConfiguration(CONFIG_VARNAME_DB_HOSTNAME, DEFAULT_CONFIG_DB_HOSTNAME, DOC_CONFIG_DB_HOSTNAME), new DefaultConfiguration(CONFIG_VARNAME_DB_PORT, 5432, DOC_CONFIG_DB_PORT), new DefaultConfiguration(CONFIG_VARNAME_DB_INSTANCE_NAME, defaultInstanceName, DOC_CONFIG_DB_INSTANCE_NAME), new DefaultConfiguration(CONFIG_VARNAME_DB_USERNAME, "rox", DOC_CONFIG_DB_USERNAME), new DefaultConfiguration(CONFIG_VARNAME_DB_PASSWORD, "rox", DOC_CONFIG_DB_PASSWORD), new DefaultConfiguration(CONFIG_VARNAME_DB_MAPPING_FILE, "/rdbms/mapping/mapping.xml", DOC_CONFIG_DB_MAPPING_FILE), new DefaultConfiguration(CONFIG_VARNAME_DB_SQL_GEN_OUTPUT_FILE, DEFAULT_CONFIG_DB_SQL_GEN_OUTPUT_FILE, DOC_CONFIG_DB_SQL_GEN_OUTPUT_FILE), new DefaultConfiguration(CONFIG_VARNAME_DB_TYPE, DEFAULT_CONFIG_DB_TYPE, DOC_CONFIG_DB_TYPE), new DefaultConfiguration(CONFIG_VARNAME_DB_INIT_SCHEMA, false, DOC_CONFIG_DB_INIT_SCHEMA), new DefaultConfiguration(CONFIG_VARNAME_DB_MAX_CONNECTIONS, 5, DOC_CONFIG_DB_MAX_CONNECTIONS), new DefaultConfiguration(CONFIG_VARNAME_DB_CONNECTION_CHECKOUT_LIMIT, 86400000, DOC_CONFIG_DB_CONNECTION_CHECKOUT_LIMIT), new DefaultConfiguration(CONFIG_VARNAME_DB_DEBUG_DEADLOCK, true, DOC_CONFIG_DB_DEBUG_DEADLOCK), new DefaultConfiguration(CONFIG_VARNAME_DB_CONN_RETRY_COUNT, 3, DOC_CONFIG_DB_CONN_RETRY_COUNT), new DefaultConfiguration(CONFIG_VARNAME_DB_CONN_RETRY_INTERVAL, 10, DOC_CONFIG_DB_CONN_RETRY_INTERVAL)};
        return defaultConfiguration;
    }

    public void prepareForShutdown() throws RaplixShutdownException {
    }

    protected String getConfigurationPropertyPrefix() {
        return CONFIG_PROPERTY_PREFIX;
    }

    public static PersistenceManager getInstance() {
        return sInstance;
    }

    public TransactionManager getTransactionManager() {
        return this.mTransactionManager;
    }

    public void addDatabase(Database inDatabase) {
        this.mDatabases.put(inDatabase.getName(), inDatabase);
    }

    public Database getDefaultDatabase() {
        return this.mDefaultDatabase;
    }

    public void setDefaultDatabase(Database inDatabase) {
        this.mDefaultDatabase.shutdown();
        this.addDatabase(inDatabase);
        this.mDefaultDatabase = inDatabase;
    }

    public Database getDatabase(String inName) {
        return (Database)this.mDatabases.get(inName);
    }

    public void addTableMap(TableMap inTableMap) {
        this.mTableMaps.put(inTableMap.getTableName(), inTableMap);
    }

    public void addClassMap(ClassMap inClassMap) {
        this.mClassMaps.put(inClassMap.getClassName(), inClassMap);
        if (inClassMap.getPermissionName() != null) {
            this.mPermissionMap.put(inClassMap.getPermissionName(), inClassMap);
        }
    }

    public void clearAllClassMaps() {
        this.mClassMaps.clear();
    }

    public void initializeClassMaps(boolean inDisableVerification) throws ClassMapException {
        Iterator theIT = this.mClassMaps.values().iterator();
        while (theIT.hasNext()) {
            ClassMap currMap = (ClassMap)theIT.next();
            currMap.init(this.mBeanManager);
            this.mIDMaps.put(currMap.getIDFactory().generateObjectID().getClass(), currMap);
            if (inDisableVerification) continue;
            this.verifyClassMap(currMap);
        }
    }

    public void verifyClassMap(ClassMap inClassMap) throws ClassMapException {
        RetriveTableInformationQuery theInfoQuery;
        String tableName;
        block5: {
            TableMap theTableMap = inClassMap.getTableMap();
            tableName = theTableMap.getTableName();
            theInfoQuery = new RetriveTableInformationQuery(inClassMap.getDatabase(), tableName);
            try {
                theInfoQuery.runQuery();
            }
            catch (Exception e) {
                if (!Logger.isErrorEnabled(this)) break block5;
                Logger.error("Failure while trying to run TableInformationQuery: " + RaplixException.stackTraceToString(e), this);
            }
        }
        HashMap attributeMaps = inClassMap.getAttributeMaps();
        Iterator theIT = attributeMaps.values().iterator();
        while (theIT.hasNext()) {
            AttributeMap currMap = (AttributeMap)theIT.next();
            String errorString = " while verifying Class Map for class " + inClassMap.getClassName() + " Map with Attr Name: " + currMap.getAttributeName() + " column name " + currMap.getFullyQualifiedColumnName();
            if (theInfoQuery == null) {
                throw new ClassMapException(new ROXMessage("pm.TABLE_QUERY_FAILED", new String[]{tableName, errorString}));
            }
            if (!theInfoQuery.doesTableExist()) {
                throw new ClassMapException(new ROXMessage("pm.TABLE_NOT_EXIST", new String[]{tableName, errorString}));
            }
            if (theInfoQuery.doesColumnExist(currMap.getColumnName())) continue;
            throw new ClassMapException(new ROXMessage("pm.COLUMN_NOT_EXIST", new String[]{currMap.getColumnName(), errorString}));
        }
    }

    public ClassMap getClassMap(String inClassName) {
        return (ClassMap)this.mClassMaps.get(inClassName);
    }

    public ClassMap getClassMap(ObjectID inObjectID) {
        return (ClassMap)this.mIDMaps.get(inObjectID.getClass());
    }

    public Enumeration getClassMaps() {
        return this.mClassMaps.elements();
    }

    public TableMap getTableMap(String inTableName) {
        return (TableMap)this.mTableMaps.get(inTableName.toUpperCase());
    }

    private void generateSQLScriptHeader(StringBuffer ioBuff) {
        ioBuff.append("\n");
        ioBuff.append("-- ----------------------------------------------------------------\n");
        ioBuff.append("-- \n");
        ioBuff.append("--\tCopyright (c) Raplix, Inc. 2000-2001. All Rights Reserved.\n");
        ioBuff.append("-- \n");
        ioBuff.append("-- Raplix RolloutExpress schema creation script\n");
        ioBuff.append("-- \n");
        ioBuff.append("-- Created on" + DateFormat.getDateInstance().format(new Date()) + "\n");
        ioBuff.append("-- \n");
        ioBuff.append("-- ----------------------------------------------------------------\n\n\n");
    }

    public String generateSQLDropSchema() {
        StringBuffer theBuff = new StringBuffer();
        this.generateSQLScriptHeader(theBuff);
        Iterator theIT = this.mClassMaps.values().iterator();
        while (theIT.hasNext()) {
            ClassMap currMap = (ClassMap)theIT.next();
            theBuff.append(currMap.generateTableDropSQL());
            theBuff.append("\n");
        }
        return theBuff.toString();
    }

    public boolean doesTableExist(Database inDB, String inTableName) {
        RetriveTableInformationQuery theInfoQuery;
        block2: {
            theInfoQuery = new RetriveTableInformationQuery(inDB, inTableName);
            try {
                theInfoQuery.runQuery();
            }
            catch (Exception e) {
                if (!Logger.isErrorEnabled(this)) break block2;
                Logger.error("Failure while trying to run TableInformationQuery" + e, this);
            }
        }
        return theInfoQuery.doesTableExist();
    }

    public String generateSQLCreateSchema(boolean inCreateDropClause) throws ClassMapException {
        StringBuffer theBuff = new StringBuffer();
        this.generateSQLScriptHeader(theBuff);
        Iterator theIT = this.mClassMaps.values().iterator();
        while (theIT.hasNext()) {
            ClassMap currMap = (ClassMap)theIT.next();
            this.generateSQLCreateSchema(currMap, theBuff, inCreateDropClause);
        }
        return theBuff.toString();
    }

    public void generateSQLCreateSchema(ClassMap inClassMap, StringBuffer inStringBuffer, boolean inCreateDropClause) throws ClassMapException {
        String currTableName = inClassMap.getTableMap().getTableName();
        boolean dropTable = false;
        if (inCreateDropClause) {
            dropTable = this.doesTableExist(inClassMap.getDatabase(), currTableName);
        }
        inStringBuffer.append(inClassMap.generateTableSQL(dropTable));
        inStringBuffer.append("\n");
    }

    public Application getApplication() {
        return this.mApplication;
    }

    public static PersistentBeanManagerImpl getBeanManager() throws PersistenceManagerException {
        if (PersistenceManager.beanManager() == null) {
            throw new PersistenceManagerException(new ROXMessage("pm.NO_BEAN_MANAGER"));
        }
        return PersistenceManager.beanManager();
    }

    static PersistentBeanManagerImpl beanManager() {
        return PersistenceManager.getInstance() == null ? null : PersistenceManager.getInstance().mBeanManager;
    }

    public static boolean isInitTables() {
        return mInitTables;
    }

    public void registerRPCInterfaces(RPCManager inRPCManager) throws RPCException {
        inRPCManager.registerService(PersistentBeanManager.class, this.mBeanManager);
        PersistentServicesInit.initializeForMS(inRPCManager);
    }

    public static ROXMessage getObjectName(Class objectClass) {
        return new ROXMessage("pm.obj.name." + objectClass.getName());
    }

    public static ROXMessage getPluralObjectName(Class objectClass) {
        return new ROXMessage("pm.obj.pname." + objectClass.getName());
    }

    public ClassMap getClassMapForPermission(String permissionName) {
        return (ClassMap)this.mPermissionMap.get(permissionName);
    }

    public boolean isResettingData() {
        return this.mReInitSchema;
    }

    public void postInit() throws ConfigurationException {
        try {
            this.getTransactionManager().transact(new AcquireWriteLockTransaction(){

                public Object execute() throws PersistenceManagerException {
                    try {
                        if (PersistenceManager.this.loadSystemData()) {
                            PersistenceManager.this.setSchemaVersion(PersistenceManager.this.mDefaultDatabase, PersistenceManager.this.mExpectedVersion);
                            PersistenceManager.this.mReInitSchema = false;
                        }
                    }
                    catch (ConfigurationException e) {
                        throw new PersistenceManagerException(e);
                    }
                    return null;
                }

                public ROXMessage getLockDescription() {
                    return new ROXMessage("pm.LOADING_SYS_DATA");
                }
            });
        }
        catch (PersistenceManagerException e) {
            throw new ConfigurationException("", (Throwable)e);
        }
    }

    private boolean loadSystemData() throws ConfigurationException, PersistenceManagerException {
        SystemDataQuery sysData = new SystemDataQuery(this.getDefaultDatabase());
        if (sysData.hasDataBeenLoaded()) {
            return false;
        }
        this.createData(this.getDefaultDatabase());
        PluginImplTable.DEFAULT.getClassMap().invalidateCache();
        sysData.markDataLoadedTime();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Loaded system data", this);
        }
        return true;
    }

    public RWLock getSystemLockObject() {
        return this.mSystemLockObject;
    }
}

