/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXBasicPermissionBase;
import com.raplix.rolloutexpress.systemmodel.userdb.ROXPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.NoSuchElementException;

public final class PersistPermission
extends ROXBasicPermissionBase
implements ROXPermission,
Messages {
    public static final String READ_STRING = "read";
    public static final String WRITE_STRING = "write";
    private static final int NONE_MASK = 0;
    private static final int READ_MASK = 1;
    private static final int WRITE_MASK = 3;
    private String mActions = null;
    private int mActionsMask;

    public PersistPermission(String name, String actions) {
        super(name);
        this.setActionsMask(PersistPermission.getMaskForActions(actions));
    }

    public boolean implies(Permission p) {
        return super.implies(p) && this.impliesMask((PersistPermission)p);
    }

    boolean impliesMask(PersistPermission otherPerm) {
        int otherMask = otherPerm.getActionsMask();
        return (this.getActionsMask() & otherMask) == otherMask;
    }

    protected ROXMessage getMessageMS() {
        String perms = "";
        if (this.getActionsMask() == 3) {
            perms = WRITE_STRING;
        } else if ((this.getActionsMask() & 1) > 0) {
            perms = READ_STRING;
        }
        String objectName = this.getName();
        ClassMap clsMap = PersistenceManager.getInstance().getClassMapForPermission(objectName);
        if (clsMap != null) {
            objectName = PersistenceManager.getPluralObjectName(clsMap.getMappedClass()).getMessageString();
        }
        return new ROXMessage("pm.NO_PERMISSION", new Object[]{perms, objectName});
    }

    public boolean equals(Object other) {
        if (!super.equals(other)) {
            return false;
        }
        PersistPermission otherPerm = (PersistPermission)other;
        return this.getActionsMask() == otherPerm.getActionsMask();
    }

    public int hashCode() {
        return super.hashCode() + this.getActionsMask();
    }

    public String getActions() {
        if (this.mActions == null) {
            this.mActions = PersistPermission.getActionsForMask(this.getActionsMask());
        }
        return this.mActions;
    }

    private int getActionsMask() {
        return this.mActionsMask;
    }

    private void setActionsMask(int actionsMask) {
        this.mActionsMask = actionsMask;
    }

    /*
     * WARNING - void declaration
     */
    private static int getMaskForActions(String actions) {
        int mask = 0;
        if (actions == null) {
            throw PersistPermission.invalidActions(actions);
        }
        char[] a = actions.toCharArray();
        int i = a.length - 1;
        if (i < 0) {
            throw PersistPermission.invalidActions(actions);
        }
        while (true) {
            void var4_4;
            int matchlen;
            if (i >= 0 && PersistPermission.isWhitespace(a[i])) {
                --i;
                continue;
            }
            if (!(i < 3 || a[i - 3] != 'r' && a[i - 3] != 'R' || a[i - 2] != 'e' && a[i - 2] != 'E' || a[i - 1] != 'a' && a[i - 1] != 'A' || a[i] != 'd' && a[i] != 'D')) {
                matchlen = 4;
                mask |= 1;
            } else if (!(i < 4 || a[i - 4] != 'w' && a[i - 4] != 'W' || a[i - 3] != 'r' && a[i - 3] != 'R' || a[i - 2] != 'i' && a[i - 2] != 'I' || a[i - 1] != 't' && a[i - 1] != 'T' || a[i] != 'e' && a[i] != 'E')) {
                matchlen = 5;
                mask |= 3;
            } else {
                throw PersistPermission.invalidActions(actions);
            }
            i -= var4_4;
            while (i >= 0 && PersistPermission.isWhitespace(a[i])) {
                --i;
            }
            if (i < 0) break;
            if (a[i] != ',') {
                throw PersistPermission.invalidActions(actions);
            }
            --i;
        }
        return mask;
    }

    private static IllegalArgumentException invalidActions(String actions) {
        return new IllegalArgumentException("invalid permission actions: " + actions);
    }

    private static boolean isWhitespace(char c) {
        return c == ' ' || c == '\r' || c == '\n' || c == '\f' || c == '\t';
    }

    private static String getActionsForMask(int mask) {
        StringBuffer sb = new StringBuffer();
        boolean comma = false;
        if ((mask & 1) == 1) {
            comma = true;
            sb.append(READ_STRING);
        }
        if ((mask & 3) == 3) {
            if (comma) {
                sb.append(',');
            } else {
                comma = true;
            }
            sb.append(WRITE_STRING);
        }
        return sb.toString();
    }

    public PermissionCollection newPermissionCollection() {
        return new Collection();
    }

    private static class Collection
    extends PermissionCollection {
        private Hashtable mActionMasks = new Hashtable(11);
        private ActionMask mAllObjectActionMask = new ActionMask("*");

        public Collection() {
            this.mActionMasks.put("*", this.mAllObjectActionMask);
        }

        public void add(Permission permission) {
            if (!(permission instanceof PersistPermission)) {
                ROXMessage theMessage = new ROXMessage("pm.permission.INVALID_PERMISSION", new String[]{permission.toString()});
                throw new IllegalArgumentException(theMessage.getMessageString());
            }
            if (this.isReadOnly()) {
                ROXMessage theMessage = new ROXMessage("pm.permission.READONLY_PERMISSIONGROUP");
                throw new SecurityException(theMessage.getMessageString());
            }
            PersistPermission pp = (PersistPermission)permission;
            String name = pp.getName();
            ActionMask mask = (ActionMask)this.mActionMasks.get(name);
            if (mask == null) {
                mask = new ActionMask(name);
                this.mActionMasks.put(name, mask);
            }
            mask.mergeMask(pp.getActionsMask());
        }

        public boolean implies(Permission permission) {
            int last;
            if (!(permission instanceof PersistPermission)) {
                return false;
            }
            PersistPermission pp = (PersistPermission)permission;
            int mask = pp.getActionsMask();
            if (this.mAllObjectActionMask.implies(mask)) {
                return true;
            }
            String path = pp.getName();
            ActionMask am = (ActionMask)this.mActionMasks.get(path);
            if (am != null && am.implies(mask)) {
                return true;
            }
            int offset = path.length() - 1;
            while ((last = path.lastIndexOf(".", offset)) != -1) {
                am = (ActionMask)this.mActionMasks.get(path = path.substring(0, last + 1) + "*");
                if (am != null && am.implies(mask)) {
                    return true;
                }
                offset = last - 1;
            }
            return false;
        }

        public Enumeration elements() {
            Enumeration enumeration = this.mActionMasks.elements();
            return new Enumeration(this, enumeration){
                Permission mNext;
                private final /* synthetic */ Enumeration val$enum;
                private final /* synthetic */ Collection this$0;
                {
                    this.this$0 = this$0;
                    this.val$enum = val$enum;
                    this.mNext = null;
                }

                public boolean hasMoreElements() {
                    while (this.mNext == null) {
                        if (!this.val$enum.hasMoreElements()) {
                            return false;
                        }
                        ActionMask nextMask = (ActionMask)this.val$enum.nextElement();
                        this.mNext = nextMask.toPermission();
                    }
                    return true;
                }

                public Object nextElement() {
                    if (!this.hasMoreElements()) {
                        throw new NoSuchElementException();
                    }
                    Permission result = this.mNext;
                    this.mNext = null;
                    return result;
                }
            };
        }

        private static class ActionMask {
            private String mName;
            private int mMask = 0;
            private PersistPermission mPermission = null;

            public ActionMask(String name) {
                this.setName(name);
            }

            public String getName() {
                return this.mName;
            }

            private void setName(String name) {
                this.mName = name;
            }

            public int getMask() {
                return this.mMask;
            }

            public void mergeMask(int mask) {
                this.mMask |= mask;
                this.mPermission = null;
            }

            public boolean implies(int mask) {
                return (this.mMask & mask) == mask;
            }

            public Permission toPermission() {
                int mask;
                if (this.mPermission == null && (mask = this.getMask()) != 0) {
                    String actions = PersistPermission.getActionsForMask(mask);
                    this.mPermission = new PersistPermission(this.getName(), actions);
                }
                return this.mPermission;
            }
        }
    }
}

