/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.cache.ObjectCache;
import com.raplix.rolloutexpress.persist.map.ClassMap;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.text.DecimalFormat;
import java.util.StringTokenizer;

public abstract class ObjectIDFactory {
    static SecureRandom sRandom;
    static int sCounter;
    static DecimalFormat sDecimalFormat;
    static String sHost;
    static boolean sInitialized;

    public ObjectID generateObjectID() {
        String theIDStr = this.generateNewID();
        ObjectID theID = this.newInstance(theIDStr);
        return theID;
    }

    public ObjectID generateObjectID(String inID) {
        ObjectID theID = this.newInstance(inID);
        return theID;
    }

    protected abstract ObjectID newInstance(String var1);

    private void init() {
        String theHost;
        block9: {
            sCounter = 100;
            sDecimalFormat = new DecimalFormat();
            try {
                String alg = PlatformUtil.isAix() ? "IBMSecureRandom" : "SHA1PRNG";
                sRandom = SecureRandom.getInstance(alg);
            }
            catch (NoSuchAlgorithmException e) {
                throw new UnsupportedOperationException(new ROXMessage("pm.ERROR_INIT_RANDOM_OBJECTID", e.toString()).toString());
            }
            sRandom.setSeed(System.currentTimeMillis());
            theHost = null;
            try {
                theHost = InetAddress.getLocalHost().getHostAddress();
            }
            catch (UnknownHostException e) {
                if (!Logger.isErrorEnabled(this)) break block9;
                Logger.error("Unable to fetch Local address, using 127.0.0.1 for objectid creation", e, this);
            }
        }
        if (theHost == null) {
            theHost = "127.0.0.1";
        }
        sHost = null;
        StringTokenizer st = new StringTokenizer(theHost, ".");
        sDecimalFormat.applyPattern("000");
        while (st.hasMoreTokens()) {
            if (sHost == null) {
                sHost = sDecimalFormat.format(new Integer(st.nextToken()));
                continue;
            }
            sHost = sHost + sDecimalFormat.format(new Integer(st.nextToken()));
        }
        if (sHost == null) {
            NullPointerException e = new NullPointerException(new ROXMessage("pm.ERROR_OBJECTID_INIT_HOST", theHost).toString());
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Unable to initialize host address for objectid creation", e, this);
            }
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String generateNewID() {
        if (!sInitialized) {
            Class clazz = ObjectID.class;
            synchronized (clazz) {
                if (!sInitialized) {
                    this.init();
                    sInitialized = true;
                }
            }
        }
        StringBuffer theID = new StringBuffer(sHost).append("-");
        sDecimalFormat.applyPattern("0000000000000");
        theID.append(sDecimalFormat.format(System.currentTimeMillis())).append("-");
        if (sCounter >= 99999) {
            sCounter = 0;
        }
        sDecimalFormat.applyPattern("00000");
        theID.append(sDecimalFormat.format(++sCounter)).append("-");
        sDecimalFormat.applyPattern("0000000000");
        theID.append(sDecimalFormat.format(sRandom.nextInt(Integer.MAX_VALUE)));
        return theID.toString();
    }

    public void registerCaches(ClassMap className, ObjectCache cache) {
    }

    static {
        sInitialized = false;
    }
}

