/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.DeleteSessionArbiter;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.DeleteSessionID;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.PersistContext;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.PersistentServicesInit;
import com.raplix.rolloutexpress.persist.RPCTransaction;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.TransactionManager;
import com.raplix.rolloutexpress.persist.cache.CacheKey;
import com.raplix.rolloutexpress.persist.exception.ObjectNotDeletableException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.query.exception.ObjectNotDeletedQueryException;
import com.raplix.rolloutexpress.persist.sql.Database;
import java.util.Comparator;
import java.util.NoSuchElementException;

public class ObjectID
implements RPCSerializable,
CacheKey {
    private String mID = null;
    public static final String OBJECTID_COL_NAME = "OBJECTID";
    static final long serialVersionUID = -5131646667695348471L;

    protected ObjectID() {
    }

    public ObjectID(String inID) {
        if (inID == null) {
            throw new NullPointerException();
        }
        this.mID = inID;
    }

    public boolean equals(ObjectID inObject) {
        return inObject != null && this.mID.equals(inObject.mID);
    }

    public boolean equals(Object inObject) {
        if (this == inObject) {
            return true;
        }
        if (inObject != null && inObject instanceof ObjectID) {
            return this.equals((ObjectID)inObject);
        }
        return false;
    }

    public int hashCode() {
        return this.mID.hashCode();
    }

    public final String toString() {
        return this.mID;
    }

    public String generateSQLWhereClause() {
        String outString = "OBJECTID='" + this.mID + "'";
        return outString;
    }

    public static String generateSQLColumnTypeDefinition(Database inDatabase) {
        return "VARCHAR(56)";
    }

    public static String generateSQLColumnNames() {
        return OBJECTID_COL_NAME;
    }

    public String generateSQLInsertValues() {
        return "'" + this.mID + "'";
    }

    public static String[] objectIDtoStringArr(ObjectID[] inArr) {
        if (inArr == null) {
            return null;
        }
        String[] result = new String[inArr.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = inArr[i].toString();
        }
        return result;
    }

    protected void deleteRPC(PersistContext context) throws PersistenceManagerException, RPCException {
        PersistentBean.getRPCServices().deleteObject(this, context);
    }

    public void findDependentObjects(DeleteSessionContext inContext, DeleteSessionDependentContainer inDependentContainer, DeleteSessionDependentContainer inPostDependentContainer) throws PersistenceManagerException {
        throw new ObjectNotDeletableException();
    }

    public static DeleteSessionID delete(IDResolvingTypedSet inIDSet) throws PersistenceManagerException, RPCException {
        return ObjectID.delete(inIDSet, false);
    }

    public static DeleteSessionID delete(IDResolvingTypedSet inIDSet, boolean inConfirmedDelete) throws PersistenceManagerException, RPCException {
        return PersistentBean.getRPCServices().delete(inIDSet, inConfirmedDelete);
    }

    public void delete() throws PersistenceManagerException, RPCException {
        DeleteSessionID sessionID = PersistentBean.getRPCServices().deleteSynchronous(this.getIDResolvingTypedSet());
        try {
            DeleteSessionCandidate dsc = (DeleteSessionCandidate)sessionID.getDeleteCandidates().iterator().next();
            if (null != dsc.getException()) {
                if (dsc.getException() instanceof PersistenceManagerException) {
                    throw (PersistenceManagerException)dsc.getException();
                }
                throw new PersistenceManagerException(dsc.getException());
            }
        }
        catch (NoSuchElementException nsee) {
            throw new ObjectNotDeletedQueryException(new ROXMessage("pm.qe.OBJECT_NOT_DELETED", this.mID));
        }
    }

    protected IDResolvingTypedSet getIDResolvingTypedSet() throws PersistenceManagerException {
        throw new ObjectNotDeletableException();
    }

    protected void deleteMS(PersistContext context) throws PersistenceManagerException {
        PersistenceManager.getBeanManager().delete(this);
    }

    protected void lockForUpdateMS() throws PersistenceManagerException {
        PersistenceManager.getBeanManager().lockForUpdate(this);
    }

    protected PersistentBean retrieveMS() throws PersistenceManagerException {
        return PersistenceManager.getBeanManager().retrieve(this);
    }

    protected static Object transactMS(Transaction inTxn) throws PersistenceManagerException {
        return ObjectID.getTransactionManagerMS().transact(inTxn);
    }

    protected static TransactionManager getTransactionManagerMS() {
        return PersistenceManager.getInstance().getTransactionManager();
    }

    protected static PersistContext transactRPC(RPCTransaction inTransaction) throws RPCException, PersistenceManagerException {
        return PersistentServicesInit.transact(inTransaction);
    }

    public Comparator getDeletionComparator() {
        return new DeleteSessionArbiter.BasicObjectDeletionComparator();
    }
}

