/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.persist.DeleteSessionInfo;
import com.raplix.rolloutexpress.persist.DeleteSessionStatus;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.ObjectIDFactory;
import com.raplix.rolloutexpress.persist.PersistentBean;
import com.raplix.rolloutexpress.persist.exception.DeleteSessionExpiredException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import java.util.Collection;

public class DeleteSessionID
extends ObjectID {
    private static DeleteSessionIDFactory idFactory = new DeleteSessionIDFactory();

    private DeleteSessionID() {
    }

    public DeleteSessionID(String inID) {
        super(inID);
    }

    public static DeleteSessionID generateDeleteSessionID() {
        return (DeleteSessionID)idFactory.generateObjectID();
    }

    public void confirm() throws RPCException, PersistenceManagerException {
        PersistentBean.getRPCServices().confirmDelete(this);
    }

    public void cancel() throws RPCException, PersistenceManagerException {
        PersistentBean.getRPCServices().cancelDelete(this);
    }

    public DeleteSessionInfo getSessionInfo() throws RPCException, PersistenceManagerException {
        return PersistentBean.getRPCServices().getDeleteSessionInfo(this);
    }

    public DeleteSessionStatus getStatus() throws RPCException, PersistenceManagerException {
        return this.getSessionInfo().getStatus();
    }

    public double getProgress() throws RPCException, PersistenceManagerException {
        return this.getSessionInfo().getProgress();
    }

    public Collection getDeleteCandidates() throws RPCException, PersistenceManagerException {
        return PersistentBean.getRPCServices().getDeleteCandidates(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void join() throws InterruptedException, PersistenceManagerException {
        try {
            DeleteSessionStatus status = this.getSessionInfo().getStatus();
            while (status.running() || status.equals(DeleteSessionStatus.NOT_STARTED)) {
                DeleteSessionID deleteSessionID = this;
                synchronized (deleteSessionID) {
                    this.wait(500L);
                }
                status = this.getSessionInfo().getStatus();
            }
        }
        catch (DeleteSessionExpiredException dsee) {
            return;
        }
        catch (CommandException ce) {
            throw new PersistenceManagerException(ce);
        }
    }

    public static class DeleteSessionIDFactory
    extends ObjectIDFactory {
        protected ObjectID newInstance(String inID) {
            return new DeleteSessionID(inID);
        }
    }
}

