/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.util.logger.Logger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import java.util.TreeSet;

public class DeleteSessionDependentContainer
implements RPCSerializable {
    private transient HashSet mDependentIDs = new HashSet();
    private transient ArrayList mDependentObjects = new ArrayList();
    private transient Stack mPendingDependents = new Stack();
    private DeleteSessionContext mParent;
    private boolean mIsPostCollection;

    private DeleteSessionDependentContainer() {
    }

    DeleteSessionDependentContainer(DeleteSessionContext inParent, boolean isPostCollection) {
        this.mParent = inParent;
        this.mIsPostCollection = isPostCollection;
    }

    public void addAllDependentObjects(Collection inDependentObjects) throws PersistenceManagerException {
        if (inDependentObjects.size() > 0) {
            TreeSet objs = new TreeSet(((HasObjectID)inDependentObjects.iterator().next()).getObjectID().getDeletionComparator());
            objs.addAll(inDependentObjects);
            Iterator it = objs.iterator();
            while (it.hasNext()) {
                this.addDependentObject((HasObjectID)it.next());
            }
        }
    }

    public void addAllDependentObjects(HasObjectID[] inDependentObjects) throws PersistenceManagerException {
        this.addAllDependentObjects(Arrays.asList(inDependentObjects));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDependentObject(HasObjectID inDependentObject) throws PersistenceManagerException {
        if (Logger.isDebugEnabled("persist.objectdeletion")) {
            Logger.debug("Adding dependent object " + inDependentObject.getObjectID(), "persist.objectdeletion");
        }
        if (this.mDependentIDs.add(inDependentObject.getObjectID())) {
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("Dependent object " + inDependentObject.getObjectID() + " added, now collecting dependencies", "persist.objectdeletion");
            }
            this.mPendingDependents.push(inDependentObject.getObjectID());
            try {
                inDependentObject.getObjectID().findDependentObjects(this.mParent, this.mIsPostCollection ? this.mParent.getPostDependentObjectContainer() : this.mParent.getDependentObjectContainer(), this.mParent.getPostDependentObjectContainer());
                this.mDependentObjects.add(inDependentObject);
            }
            finally {
                this.mPendingDependents.pop();
            }
        } else if (Logger.isDebugEnabled("persist.objectdeletion")) {
            Logger.debug("Dependent object " + inDependentObject.getObjectID() + " is already present, skipping", "persist.objectdeletion");
        }
    }

    HasObjectID[] getDependentObjects() {
        return this.mDependentObjects.toArray(new HasObjectID[0]);
    }

    ObjectID[] getDependentIDs() {
        return this.mDependentIDs.toArray(new ObjectID[0]);
    }

    int compareDependentIDs(ObjectID inQueryID, ObjectID inFinalID) {
        if (this.mDependentIDs.contains(inQueryID)) {
            if (this.mDependentIDs.contains(inFinalID)) {
                Iterator objs = this.mDependentObjects.iterator();
                while (objs.hasNext()) {
                    ObjectID curID = ((HasObjectID)objs.next()).getObjectID();
                    if (curID.equals(inFinalID)) {
                        return -1;
                    }
                    if (!curID.equals(inQueryID)) continue;
                    return 1;
                }
                for (int i = this.mPendingDependents.size() - 1; i >= 0; --i) {
                    ObjectID curID = (ObjectID)this.mPendingDependents.get(i);
                    if (curID.equals(inFinalID)) {
                        return -1;
                    }
                    if (!curID.equals(inQueryID)) continue;
                    return 1;
                }
                throw new InternalError("contains logic broken");
            }
            return 1;
        }
        if (this.mDependentIDs.contains(inFinalID)) {
            return -1;
        }
        return 0;
    }

    void addDependentIDsTo(Collection c) {
        c.addAll(this.mDependentIDs);
    }
}

