/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.event.query.bean.InstalledComponentBean;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.DeleteSessionDependentContainer;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PersistContext;
import java.util.HashSet;
import java.util.Set;

public class DeleteSessionContext
extends PersistContext
implements RPCSerializable {
    private static final ObjectID DEFAULT_ID = new ObjectID("DeleteSessionContext-ID");
    public static DeleteSessionContext DEFAULT = new DeleteSessionContext();
    private HasObjectID[] mAllObjects = new HasObjectID[0];
    protected DeleteSessionDependentContainer mDependentObjects = new DeleteSessionDependentContainer(this, false);
    protected DeleteSessionDependentContainer mPostDependentObjects = new DeleteSessionDependentContainer(this, true);
    private ObjectID mCurrentID = DEFAULT_ID;
    private transient Set mPriorCandidateIDs = new HashSet();
    private InstalledComponentBean[] mInstalledComponents = new InstalledComponentBean[0];

    public DeleteSessionContext() {
    }

    public DeleteSessionContext(HasObjectID[] inAllObjectsToDelete, ObjectID inCurrentID, Set inPriorCandidateIDs) {
        this();
        this.mAllObjects = inAllObjectsToDelete;
        this.mCurrentID = inCurrentID;
        this.mPriorCandidateIDs = inPriorCandidateIDs;
    }

    public HasObjectID[] getAllObjects() {
        return this.mAllObjects;
    }

    public boolean objectWillBeDeletedPriorTo(ObjectID inQueryID, ObjectID inFinalID) {
        if (this.mPriorCandidateIDs.contains(inQueryID)) {
            return true;
        }
        int pos = this.mDependentObjects.compareDependentIDs(inQueryID, inFinalID);
        if (pos > 0) {
            return true;
        }
        if (pos < 0) {
            return false;
        }
        if (this.mCurrentID.equals(inFinalID)) {
            return false;
        }
        if (this.mCurrentID.equals(inQueryID)) {
            return true;
        }
        pos = this.mPostDependentObjects.compareDependentIDs(inQueryID, inFinalID);
        return pos > 0;
    }

    public boolean objectWillBeDeletedAfter(ObjectID inQueryID, ObjectID inFinalID) {
        return this.objectWillBeDeletedPriorTo(inQueryID, null) && !this.objectWillBeDeletedPriorTo(inQueryID, inFinalID);
    }

    public HasObjectID[] getDependentObjects() {
        return this.mDependentObjects.getDependentObjects();
    }

    public HasObjectID[] getPostDependentObjects() {
        return this.mPostDependentObjects.getDependentObjects();
    }

    public void setInstalledComponents(InstalledComponentBean[] inInstalledComponents) {
        if (null == inInstalledComponents) {
            throw new NullPointerException();
        }
        this.mInstalledComponents = inInstalledComponents;
    }

    public InstalledComponentBean[] getInstalledComponents() {
        return this.mInstalledComponents;
    }

    DeleteSessionDependentContainer getDependentObjectContainer() {
        return this.mDependentObjects;
    }

    DeleteSessionDependentContainer getPostDependentObjectContainer() {
        return this.mPostDependentObjects;
    }
}

