/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.persist.DeleteSession;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidateStatus;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.util.logger.Logger;
import java.security.AccessControlException;

public class DeleteSessionCandidate
implements RPCSerializable {
    private HasObjectID mParent;
    private HasObjectID[] mChildren;
    private HasObjectID[] mPostChildren;
    private DeleteSessionCandidateStatus mStatus = DeleteSessionCandidateStatus.NOT_STARTED;
    private boolean mConfirmed = true;
    private CommandException mException;
    private DeleteSessionContext mContext;

    private DeleteSessionCandidate() {
    }

    public DeleteSessionCandidate(HasObjectID inParent) {
        this.setParent(inParent);
    }

    public DeleteSessionCandidate(HasObjectID inParent, HasObjectID[] inChildren, HasObjectID[] inPostChildren) {
        this.setParent(inParent);
        this.setChildren(inChildren);
        this.setPostChildren(inPostChildren);
    }

    public HasObjectID getParent() {
        return this.mParent;
    }

    public HasObjectID[] getChildren() {
        if (null == this.mChildren) {
            return new HasObjectID[0];
        }
        return this.mChildren;
    }

    public HasObjectID[] getPostChildren() {
        if (null == this.mPostChildren) {
            return new HasObjectID[0];
        }
        return this.mPostChildren;
    }

    protected void setParent(HasObjectID inParent) {
        this.mParent = inParent;
    }

    protected void setChildren(HasObjectID[] inChildren) {
        this.mChildren = inChildren;
    }

    protected void setPostChildren(HasObjectID[] inPostChildren) {
        this.mPostChildren = inPostChildren;
    }

    protected void setException(CommandException inException) {
        this.mException = inException;
    }

    public CommandException getException() {
        return this.mException;
    }

    public DeleteSessionCandidateStatus getStatus() {
        return this.mStatus;
    }

    protected void setStatus(DeleteSessionCandidateStatus inStatus) {
        this.mStatus = inStatus;
    }

    public void setConfirmation(boolean inConfirmed) {
        this.mConfirmed = inConfirmed;
    }

    public boolean getConfirmation() {
        return this.mConfirmed;
    }

    void setContext(DeleteSessionContext inContext) {
        this.mContext = inContext;
    }

    DeleteSessionContext getContext() {
        return this.mContext;
    }

    protected void executeDelete(DeleteSession inSession) throws PersistenceManagerException {
        try {
            HasObjectID[] postChildren;
            if (this.mChildren != null) {
                for (int i = 0; i < this.mChildren.length; ++i) {
                    if (null == inSession || inSession.requestDeletionClearance(this.mChildren[i].getObjectID())) {
                        if (Logger.isDebugEnabled("persist.objectdeletion")) {
                            Logger.debug("Deleting child " + this.mChildren[i], "persist.objectdeletion");
                        }
                        this.mChildren[i].getObjectID().deleteMS(this.getContext());
                        continue;
                    }
                    if (!Logger.isDebugEnabled("persist.objectdeletion")) continue;
                    Logger.debug("Skipping child " + this.mChildren[i] + " (already deleted)", "persist.objectdeletion");
                }
            }
            if (this.mParent != null) {
                if (null == inSession || inSession.requestDeletionClearance(this.mParent.getObjectID())) {
                    if (Logger.isDebugEnabled("persist.objectdeletion")) {
                        Logger.debug("Deleting parent " + this.mParent, "persist.objectdeletion");
                    }
                    this.mParent.getObjectID().deleteMS(this.getContext());
                } else if (Logger.isDebugEnabled("persist.objectdeletion")) {
                    Logger.debug("Skipping parent " + this.mParent + " (already deleted)", "persist.objectdeletion");
                }
            }
            if ((postChildren = this.getPostChildren()) != null) {
                for (int i = 0; i < postChildren.length; ++i) {
                    if (null == inSession || inSession.requestDeletionClearance(postChildren[i].getObjectID())) {
                        if (Logger.isDebugEnabled("persist.objectdeletion")) {
                            Logger.debug("Deleting post child " + postChildren[i], "persist.objectdeletion");
                        }
                        postChildren[i].getObjectID().deleteMS(this.getContext());
                        continue;
                    }
                    if (!Logger.isDebugEnabled("persist.objectdeletion")) continue;
                    Logger.debug("Skipping post child " + postChildren[i] + " (already deleted)", "persist.objectdeletion");
                }
            }
            this.setStatus(DeleteSessionCandidateStatus.COMPLETE);
        }
        catch (PersistenceManagerException pme) {
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("An exception was thrown while deleting parent " + this.mParent, pme, "persist.objectdeletion");
            }
            this.setException(pme);
            this.setStatus(DeleteSessionCandidateStatus.DELETION_FAILED);
            throw pme;
        }
        catch (AccessControlException ace) {
            this.setStatus(DeleteSessionCandidateStatus.DELETION_FAILED);
            throw new PersistenceManagerException(new ROXMessage("pm.permission.INVALID_PERMISSION", new Object[]{ace.toString()}));
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("DeleteSessionCandidate(").append(super.toString()).append(")\n");
        buf.append("\tParent - ").append(this.mParent).append("\n");
        buf.append("\tChildren - ");
        if (this.mChildren == null) {
            buf.append("null\n");
        } else {
            buf.append("\n");
            for (int i = 0; i < this.mChildren.length; ++i) {
                buf.append("\t\t").append(this.mChildren[i]).append("\n");
            }
        }
        buf.append("Status - ").append(this.mStatus).append("\n");
        buf.append("Confirmation - ").append(this.mConfirmed).append("\n");
        buf.append("Exception - ").append(this.mException);
        return buf.toString();
    }
}

