/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.util.logger.Logger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.TreeSet;

class DeleteSessionArbiter {
    private HasObjectID[] mRawObjects = new HasObjectID[0];

    DeleteSessionArbiter(HasObjectID[] inRawObjects) {
        if (null == inRawObjects) {
            throw new NullPointerException();
        }
        this.mRawObjects = inRawObjects;
    }

    HasObjectID[] arbitrate() {
        HashMap objectsByClass = this.groupObjects();
        Collection objectsByOrderedClass = this.orderClasses(objectsByClass);
        return this.generateFinalList(objectsByOrderedClass);
    }

    private HasObjectID[] generateFinalList(Collection uberCollection) {
        if (Logger.isDebugEnabled("persist.objectdeletion")) {
            Logger.debug("Arbiter creating final list of objects", "persist.objectdeletion");
        }
        ArrayList finalOrder = new ArrayList();
        Iterator outer = uberCollection.iterator();
        while (outer.hasNext()) {
            Collection objects = (Collection)outer.next();
            if (Logger.isDebugEnabled("persist.objectdeletion")) {
                Logger.debug("adding " + objects, "persist.objectdeletion");
            }
            finalOrder.addAll(objects);
        }
        if (Logger.isDebugEnabled("persist.objectdeletion")) {
            Logger.debug("flat list is " + finalOrder, "persist.objectdeletion");
        }
        return finalOrder.toArray(new HasObjectID[0]);
    }

    private Collection orderClasses(HashMap inObjectsByClass) {
        TreeSet<Collection> classesInOrder = new TreeSet<Collection>(this.getClassTypeComparator());
        Iterator i = inObjectsByClass.values().iterator();
        while (i.hasNext()) {
            Collection classCollection = (Collection)i.next();
            classesInOrder.add(classCollection);
        }
        return classesInOrder;
    }

    protected Comparator getClassTypeComparator() {
        return new BasicClassTypeComparator();
    }

    private HashMap groupObjects() {
        HashMap<String, TreeSet<HasObjectID>> objectsByType = new HashMap<String, TreeSet<HasObjectID>>();
        for (int i = 0; i < this.mRawObjects.length; ++i) {
            String key = this.mRawObjects[i].getClass().getName();
            TreeSet<HasObjectID> objects = (TreeSet<HasObjectID>)objectsByType.get(key);
            if (null == objects) {
                objects = new TreeSet<HasObjectID>(this.mRawObjects[i].getObjectID().getDeletionComparator());
                objectsByType.put(key, objects);
            }
            objects.add(this.mRawObjects[i]);
        }
        return objectsByType;
    }

    static class BasicObjectDeletionComparator
    implements Comparator {
        BasicObjectDeletionComparator() {
        }

        public boolean equals(Object o) {
            return o instanceof BasicObjectDeletionComparator;
        }

        public int compare(Object lhs, Object rhs) {
            return 1;
        }
    }

    static class BasicClassTypeComparator
    implements Comparator {
        BasicClassTypeComparator() {
        }

        public boolean equals(Object o) {
            return o instanceof BasicClassTypeComparator;
        }

        public int compare(Object lhs, Object rhs) {
            return 1;
        }
    }
}

