/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.CommandException;
import com.raplix.rolloutexpress.persist.AcquireReadLock;
import com.raplix.rolloutexpress.persist.AcquireWriteLock;
import com.raplix.rolloutexpress.persist.DeleteSessionArbiter;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidate;
import com.raplix.rolloutexpress.persist.DeleteSessionCandidateStatus;
import com.raplix.rolloutexpress.persist.DeleteSessionContext;
import com.raplix.rolloutexpress.persist.DeleteSessionID;
import com.raplix.rolloutexpress.persist.DeleteSessionInfo;
import com.raplix.rolloutexpress.persist.DeleteSessionStatus;
import com.raplix.rolloutexpress.persist.DisableDeleteLocking;
import com.raplix.rolloutexpress.persist.HasObjectID;
import com.raplix.rolloutexpress.persist.IDResolvingTypedSet;
import com.raplix.rolloutexpress.persist.ObjectID;
import com.raplix.rolloutexpress.persist.PMLockException;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PostTransactionException;
import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.exception.ObjectInUseException;
import com.raplix.rolloutexpress.persist.exception.ObjectNotDeletableException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.persist.map.exception.ClassMapException;
import com.raplix.rolloutexpress.persist.query.exception.QueryException;
import com.raplix.rolloutexpress.systemmodel.userdb.UserID;
import com.raplix.util.logger.Logger;
import com.raplix.util.rwlock.LockContext;
import com.raplix.util.rwlock.RWLockException;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.RunnableContext;
import java.sql.SQLException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Vector;

public class DeleteSession
extends RunnableContext {
    private DeleteSessionID mSessionID;
    private IDResolvingTypedSet mObjects;
    private double mProgress = 0.0;
    private int mProgressMax;
    private volatile DeleteSessionStatus mStatus = DeleteSessionStatus.NOT_STARTED;
    private Vector mCandidates = new Vector();
    private CommandException mException;
    private boolean mConfirmedDelete;
    private HashSet mDeletedObjects;
    private boolean isNotified = false;
    private boolean mIsRemote = false;
    private static final ThreadLocal sDisableLockContext = new ThreadLocal();
    private final boolean mDisableLock;
    public static final String OBJECT_DELETION = "persist.objectdeletion";
    private boolean mIsConfirmNotified = false;
    private final Object CONFIRM_LOCK = new Object();
    private PersistenceManagerException mConfirmLockFailure;
    static final ROXMessage MSG_DELETE_LOCK = new ROXMessage("pm.DELETE_LOCK");

    public DeleteSession(DeleteSessionID inID, IDResolvingTypedSet inObjectsToDelete, Context inDeleteContext, boolean inConfirmedDelete, boolean inIsRemote) {
        super("DeleteSession(" + inID + ")", inDeleteContext);
        this.mObjects = inObjectsToDelete;
        this.mSessionID = inID;
        this.mConfirmedDelete = inConfirmedDelete;
        this.mDisableLock = DeleteSession.isDisableLockContext();
        this.mIsRemote = inIsRemote;
    }

    public DeleteSessionID getID() {
        return this.mSessionID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void confirm() throws PersistenceManagerException {
        this.checkTaskControlPermission();
        boolean isLegitConfirm = false;
        Object object = this;
        synchronized (object) {
            if (this.getStatus().equals(DeleteSessionStatus.AWAITING_CONFIRMATION)) {
                this.setStatus(DeleteSessionStatus.CONFIRMED);
                this.notify();
                this.isNotified = true;
                isLegitConfirm = true;
            }
        }
        if (isLegitConfirm) {
            object = this.CONFIRM_LOCK;
            synchronized (object) {
                try {
                    if (!this.mIsConfirmNotified) {
                        try {
                            this.CONFIRM_LOCK.wait();
                        }
                        catch (InterruptedException e) {
                            throw new PersistenceManagerException(e);
                        }
                    }
                    if (this.mConfirmLockFailure != null) {
                        throw (PersistenceManagerException)this.mConfirmLockFailure.fillInStackTrace();
                    }
                }
                finally {
                    this.mIsConfirmNotified = false;
                    this.mConfirmLockFailure = null;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyConfirmLocked(PMLockException lockingFailure) {
        Object object = this.CONFIRM_LOCK;
        synchronized (object) {
            this.mIsConfirmNotified = true;
            this.CONFIRM_LOCK.notify();
            this.mConfirmLockFailure = lockingFailure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancel() {
        this.checkTaskControlPermission();
        DeleteSession deleteSession = this;
        synchronized (deleteSession) {
            if (this.getStatus().abortable()) {
                this.setStatus(DeleteSessionStatus.ABORT_REQUESTED);
                this.notify();
                this.isNotified = true;
            }
        }
    }

    public double getProgress() {
        return this.mProgress;
    }

    public Vector getCandidates() {
        return this.mCandidates;
    }

    public DeleteSessionStatus getStatus() {
        return this.mStatus;
    }

    public DeleteSessionInfo getSessionInfo() {
        return new DeleteSessionInfo(this.getTaskOwner(), this.mProgress, this.mStatus, this.mSessionID);
    }

    protected void setStatus(DeleteSessionStatus inStatus) {
        this.mStatus = inStatus;
        if (Logger.isDebugEnabled(OBJECT_DELETION)) {
            Logger.debug("status is " + this.mStatus, OBJECT_DELETION);
        }
    }

    protected void setException(CommandException ce) {
        this.mException = ce;
    }

    public CommandException getException() {
        return this.mException;
    }

    protected void setProgressMax(int inProgressMax) {
        this.mProgressMax = inProgressMax;
    }

    protected int getProgressMax() {
        return this.mProgressMax;
    }

    protected void reportProgress(int inProgress) {
        this.setProgress((double)inProgress / (double)this.getProgressMax());
    }

    protected void setProgress(double inProgress) {
        if (inProgress < 0.0) {
            this.mProgress = 0.0;
            return;
        }
        if (inProgress > 1.0) {
            this.mProgress = 1.0;
            return;
        }
        this.mProgress = inProgress;
    }

    protected void generateDependentObjectList() throws PersistenceManagerException, InterruptedException {
        if (this.beforeConfirmation()) {
            DiscoveryTransaction transaction = this.isDisableLock() ? new DiscoveryTransaction(this.mObjects, this) : new LockingDiscoveryTransaction(this.mObjects, this);
            this.mCandidates = (Vector)PersistenceManager.getInstance().getTransactionManager().transact(transaction);
        }
    }

    protected void deleteCandidates() throws InterruptedException, RWLockException {
        if (this.beforeDeletion(this.mCandidates)) {
            if (Logger.isDebugEnabled(OBJECT_DELETION)) {
                Logger.debug("preparing to delete:\n" + this.mCandidates, OBJECT_DELETION);
            }
            this.setProgressMax(this.mCandidates == null ? 1 : this.mCandidates.size());
            this.setStatus(DeleteSessionStatus.DELETION_RUNNING);
            try {
                if (this.isDisableLock()) {
                    this.lockedDelete();
                } else {
                    PersistenceManager.getInstance().getSystemLockObject().writeLock(MSG_DELETE_LOCK, new LockContext(){

                        public Object execute() throws InterruptedException {
                            DeleteSession.this.lockedDelete();
                            return null;
                        }
                    });
                }
            }
            catch (InterruptedException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (RWLockException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void lockedDelete() throws InterruptedException {
        this.notifyConfirmLocked(null);
        Iterator i = this.mCandidates.iterator();
        int counter = 0;
        this.mDeletedObjects = new HashSet();
        while (i.hasNext()) {
            block10: {
                this.testFlow();
                DeleteSessionCandidate dsc = (DeleteSessionCandidate)i.next();
                if (dsc.getConfirmation()) {
                    dsc.setStatus(DeleteSessionCandidateStatus.DELETION_IN_PROCESS);
                    try {
                        DeleteTransaction transaction = this.isDisableLock() ? new DeleteTransaction(dsc, this) : new LockingDeleteTransaction(dsc, this);
                        PersistenceManager.getInstance().getTransactionManager().transact(transaction);
                    }
                    catch (PostTransactionException pme) {
                        if (Logger.isDebugEnabled(OBJECT_DELETION)) {
                            Logger.debug("A post transaction exception was thrown while deleting candidate " + dsc, pme, OBJECT_DELETION);
                        }
                        dsc.setException(pme);
                        if (pme.isTransactionCommited()) {
                            dsc.setStatus(DeleteSessionCandidateStatus.COMPLETE_WARNING);
                            break block10;
                        }
                        dsc.setStatus(DeleteSessionCandidateStatus.DELETION_FAILED);
                    }
                    catch (PersistenceManagerException pme) {
                        if (Logger.isDebugEnabled(OBJECT_DELETION)) {
                            Logger.debug("An exception was thrown while deleting candidate " + dsc, pme, OBJECT_DELETION);
                        }
                        dsc.setException(pme);
                        dsc.setStatus(DeleteSessionCandidateStatus.DELETION_FAILED);
                    }
                } else if (dsc.getStatus().equals(DeleteSessionCandidateStatus.AWAITING_CONFIRMATION)) {
                    dsc.setStatus(DeleteSessionCandidateStatus.NOT_DELETED);
                }
            }
            this.reportProgress(++counter);
        }
    }

    protected boolean beforeConfirmation() {
        return true;
    }

    protected void afterConfirmation(Vector inCandidates) {
    }

    protected boolean beforeDeletion(Vector inCandidates) {
        return true;
    }

    protected void afterDeletion(Vector inCandidates) {
    }

    protected void testFlow() throws InterruptedException {
        if (this.getStatus() == DeleteSessionStatus.ABORT_REQUESTED) {
            throw new InterruptedException();
        }
        super.testFlow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void safeRun() throws Exception {
        try {
            block30: {
                try {
                    this.setStatus(DeleteSessionStatus.CONFIRMATION_RUNNING);
                    this.testFlow();
                    if (Logger.isDebugEnabled(OBJECT_DELETION)) {
                        Logger.debug("generating object dependencies", OBJECT_DELETION);
                    }
                    this.generateDependentObjectList();
                    if (this.getStatus() == DeleteSessionStatus.ABORT_REQUESTED) {
                        this.setStatus(DeleteSessionStatus.ABORTED);
                        break block30;
                    }
                    this.setStatus(DeleteSessionStatus.AWAITING_CONFIRMATION);
                    this.afterConfirmation(this.mCandidates);
                    DeleteSessionStatus status = this.getStatus();
                    if (status == DeleteSessionStatus.ABORT_REQUESTED) {
                        this.setStatus(DeleteSessionStatus.ABORTED);
                    } else if (this.mConfirmedDelete) {
                        this.setStatus(DeleteSessionStatus.CONFIRMED);
                        this.doDelete();
                    } else {
                        boolean retryConfirm;
                        do {
                            Object object = this.getID();
                            synchronized (object) {
                                this.getID().notify();
                            }
                            object = this;
                            synchronized (object) {
                                if (!this.isNotified) {
                                    this.wait();
                                }
                                this.isNotified = false;
                            }
                            retryConfirm = false;
                            if (this.getStatus() != DeleteSessionStatus.CONFIRMED) continue;
                            try {
                                this.doDelete();
                            }
                            catch (RWLockException e) {
                                retryConfirm = true;
                                this.setStatus(DeleteSessionStatus.AWAITING_CONFIRMATION);
                                this.notifyConfirmLocked(new PMLockException(e));
                            }
                        } while (retryConfirm);
                    }
                    if (this.getStatus() != DeleteSessionStatus.ABORT_REQUESTED) break block30;
                    this.setStatus(DeleteSessionStatus.ABORTED);
                }
                catch (InterruptedException ie) {
                    this.setStatus(DeleteSessionStatus.ABORTED);
                    Object var7_12 = null;
                    this.notifyConfirmLocked(null);
                    DeleteSessionID deleteSessionID = this.getID();
                    synchronized (deleteSessionID) {
                        this.setProgress(1.0);
                        this.getID().notify();
                        return;
                    }
                }
                catch (RWLockException e) {
                    this.setFailure(new PMLockException(e), DeleteSessionStatus.FAILED, DeleteSessionCandidateStatus.NOT_DELETABLE);
                    Object var7_13 = null;
                    this.notifyConfirmLocked(null);
                    DeleteSessionID deleteSessionID = this.getID();
                    synchronized (deleteSessionID) {
                        this.setProgress(1.0);
                        this.getID().notify();
                        return;
                    }
                }
                catch (PMLockException e) {
                    block31: {
                        try {
                            HasObjectID[] hasObjectIDs = this.mObjects.resolveIDs().selectObjects();
                            if (hasObjectIDs != null && hasObjectIDs.length > 0) {
                                for (int i = 0; i < hasObjectIDs.length; ++i) {
                                    DeleteSessionCandidate dummy = new DeleteSessionCandidate(hasObjectIDs[i]);
                                    this.mCandidates.add(dummy);
                                }
                            }
                        }
                        catch (Exception ex) {
                            if (!Logger.isWarnEnabled(this)) break block31;
                            Logger.warn("Error fetching dummy delete session candidate", ex, this);
                        }
                    }
                    this.setFailure(e, DeleteSessionStatus.FAILED, DeleteSessionCandidateStatus.NOT_DELETABLE);
                    Object var7_14 = null;
                    this.notifyConfirmLocked(null);
                    DeleteSessionID deleteSessionID = this.getID();
                    synchronized (deleteSessionID) {
                        this.setProgress(1.0);
                        this.getID().notify();
                        return;
                    }
                }
            }
            Object var7_11 = null;
            this.notifyConfirmLocked(null);
            DeleteSessionID deleteSessionID = this.getID();
            synchronized (deleteSessionID) {
                this.setProgress(1.0);
                this.getID().notify();
                return;
            }
        }
        catch (Throwable throwable) {
            Object var7_15 = null;
            this.notifyConfirmLocked(null);
            DeleteSessionID deleteSessionID3 = this.getID();
            synchronized (deleteSessionID3) {
                this.setProgress(1.0);
                this.getID().notify();
                throw throwable;
            }
        }
    }

    private void doDelete() throws InterruptedException, RWLockException {
        this.setProgress(0.0);
        this.deleteCandidates();
        this.setStatus(DeleteSessionStatus.COMPLETE);
        this.afterDeletion(this.mCandidates);
    }

    private void setFailure(PersistenceManagerException inFailure, DeleteSessionStatus inSessionStatus, DeleteSessionCandidateStatus inCandidateStatus) {
        Iterator iterator = this.mCandidates.iterator();
        while (iterator.hasNext()) {
            DeleteSessionCandidate candidate = (DeleteSessionCandidate)iterator.next();
            candidate.setStatus(inCandidateStatus);
            candidate.setException(inFailure);
        }
        this.setException(inFailure);
        this.setStatus(inSessionStatus);
    }

    boolean requestDeletionClearance(ObjectID inID) {
        return this.mDeletedObjects.add(inID);
    }

    private void checkTaskControlPermission() {
        Subsystem.checkTaskPermission(this.getTaskOwner());
    }

    UserID getTaskOwner() {
        return PersistenceManager.getInstance().getTaskOwner(this.getName());
    }

    private boolean isDisableLock() {
        return this.mDisableLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object executeDeleteLocksDisabled(DisableDeleteLocking inAction) throws Exception {
        sDisableLockContext.set(new Object());
        try {
            Object object = inAction.run();
            return object;
        }
        finally {
            sDisableLockContext.set(null);
        }
    }

    private static boolean isDisableLockContext() {
        return null != sDisableLockContext.get();
    }

    private static class DeleteTransaction
    implements Transaction {
        private DeleteSessionCandidate mCandidate;
        private DeleteSession mSession;

        private DeleteTransaction(DeleteSessionCandidate inCandidate, DeleteSession inSession) {
            this.mCandidate = inCandidate;
            this.mSession = inSession;
        }

        public Object execute() throws ClassMapException, SQLException, PersistenceManagerException, QueryException {
            if (Logger.isDebugEnabled(DeleteSession.OBJECT_DELETION)) {
                Logger.debug("Deleting candidate " + this.mCandidate, DeleteSession.OBJECT_DELETION);
            }
            this.mCandidate.executeDelete(this.mSession);
            if (Logger.isDebugEnabled(DeleteSession.OBJECT_DELETION)) {
                Logger.debug("done deleting candidate", DeleteSession.OBJECT_DELETION);
            }
            return null;
        }
    }

    private static final class LockingDeleteTransaction
    extends DeleteTransaction
    implements AcquireWriteLock {
        public LockingDeleteTransaction(DeleteSessionCandidate inCandidate, DeleteSession inSession) {
            super(inCandidate, inSession);
        }

        public ROXMessage getLockDescription() {
            return MSG_DELETE_LOCK;
        }
    }

    private static class DiscoveryTransaction
    implements Transaction {
        private IDResolvingTypedSet mObjects;
        private DeleteSession mSession;

        private DiscoveryTransaction(IDResolvingTypedSet inObjects, DeleteSession inSession) {
            this.mObjects = inObjects;
            this.mSession = inSession;
        }

        public Object execute() throws ClassMapException, SQLException, PersistenceManagerException, QueryException {
            if (Logger.isDebugEnabled(DeleteSession.OBJECT_DELETION)) {
                Logger.debug("discovering dependencies for\n" + this.mObjects, DeleteSession.OBJECT_DELETION);
            }
            HasObjectID[] resolvedObjects = null;
            try {
                resolvedObjects = this.mObjects.resolveIDs().selectObjects();
            }
            catch (CommandException ce) {
                this.mSession.setException(ce);
                this.mSession.setStatus(DeleteSessionStatus.FAILED);
                resolvedObjects = null;
            }
            if (Logger.isDebugEnabled(DeleteSession.OBJECT_DELETION)) {
                Logger.debug("objects(" + resolvedObjects.length + ") resolved to\n" + resolvedObjects, DeleteSession.OBJECT_DELETION);
            }
            Vector<DeleteSessionCandidate> candidates = new Vector<DeleteSessionCandidate>();
            if (resolvedObjects != null) {
                this.mSession.setProgressMax(resolvedObjects.length);
                DeleteSessionArbiter arbiter = new DeleteSessionArbiter(resolvedObjects);
                resolvedObjects = arbiter.arbitrate();
                HashSet<ObjectID> candidateIDsSoFar = new HashSet<ObjectID>();
                for (int i = 0; i < resolvedObjects.length; ++i) {
                    try {
                        this.mSession.testFlow();
                    }
                    catch (InterruptedException ie) {
                        this.mSession.cancel();
                        return candidates;
                    }
                    HasObjectID obj = resolvedObjects[i];
                    if (Logger.isDebugEnabled(DeleteSession.OBJECT_DELETION)) {
                        Logger.debug("examining " + obj, DeleteSession.OBJECT_DELETION);
                    }
                    DeleteSessionCandidate dsc = new DeleteSessionCandidate(obj);
                    dsc.setStatus(DeleteSessionCandidateStatus.CONFIRMATION_IN_PROCESS);
                    candidates.add(dsc);
                    try {
                        if (this.mSession.mIsRemote && !PersistenceManager.getBeanManager().getClassMap(obj.getObjectID()).isDeleteSessionAllowed()) {
                            throw new ObjectNotDeletableException(new ROXMessage("pm.DELETE_OBJECT_VIA_SESSION_NOT_ALLOWED", PersistenceManager.getObjectName(obj.getClass()).toString(), PersistenceManager.getPluralObjectName(obj.getClass()).toString()));
                        }
                        DeleteSessionContext dsContext = new DeleteSessionContext(resolvedObjects, obj.getObjectID(), candidateIDsSoFar);
                        obj.getObjectID().findDependentObjects(dsContext, dsContext.getDependentObjectContainer(), dsContext.getPostDependentObjectContainer());
                        dsc.setChildren(dsContext.getDependentObjects());
                        dsc.setPostChildren(dsContext.getPostDependentObjects());
                        dsc.setStatus(DeleteSessionCandidateStatus.AWAITING_CONFIRMATION);
                        dsc.setContext(dsContext);
                        dsContext.getDependentObjectContainer().addDependentIDsTo(candidateIDsSoFar);
                        candidateIDsSoFar.add(obj.getObjectID());
                        dsContext.getPostDependentObjectContainer().addDependentIDsTo(candidateIDsSoFar);
                    }
                    catch (ObjectNotDeletableException onde) {
                        dsc.setConfirmation(false);
                        dsc.setStatus(DeleteSessionCandidateStatus.NOT_DELETABLE);
                        dsc.setException(onde);
                        if (Logger.isDebugEnabled(DeleteSession.OBJECT_DELETION)) {
                            Logger.debug("Candidate " + dsc.getParent() + " not deletable", DeleteSession.OBJECT_DELETION);
                        }
                    }
                    catch (ObjectInUseException oiue) {
                        dsc.setConfirmation(false);
                        dsc.setStatus(DeleteSessionCandidateStatus.IN_USE);
                        dsc.setException(oiue);
                        if (Logger.isDebugEnabled(DeleteSession.OBJECT_DELETION)) {
                            Logger.debug("Candidate " + dsc.getParent() + " in use", DeleteSession.OBJECT_DELETION);
                        }
                    }
                    catch (PersistenceManagerException pme) {
                        dsc.setConfirmation(false);
                        dsc.setStatus(DeleteSessionCandidateStatus.DELETION_FAILED);
                        dsc.setException(pme);
                    }
                    this.mSession.reportProgress(i + 1);
                }
            }
            return candidates;
        }
    }

    private static final class LockingDiscoveryTransaction
    extends DiscoveryTransaction
    implements AcquireReadLock {
        public LockingDiscoveryTransaction(IDResolvingTypedSet inObjects, DeleteSession inSession) {
            super(inObjects, inSession);
        }

        public ROXMessage getLockDescription() {
            return new ROXMessage("pm.DELETE_DISCOVERY_LOCK");
        }
    }
}

