/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.persist.Transaction;
import com.raplix.rolloutexpress.persist.TransactionContext;
import com.raplix.rolloutexpress.persist.TransactionManager;
import com.raplix.rolloutexpress.persist.sql.ConnectionNotAvailable;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import com.raplix.util.logger.Logger;
import java.sql.SQLException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;

public class DebugDeadlockTransactionManager
extends TransactionManager {
    public static final String DEBUG_TXN_TAG = "pm.txn";
    private Set mActiveContexts = Collections.synchronizedSet(new HashSet());
    private static final int MAX_OLD_CONTEXTS = 3;
    private LinkedList mOldContexts = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dumpAllTransactions() {
        if (Logger.isErrorEnabled(DEBUG_TXN_TAG)) {
            Logger.error("Transaction Dump:", DEBUG_TXN_TAG);
            TransactionContext[] ctxs = this.mActiveContexts.toArray(new TransactionContext[this.mActiveContexts.size()]);
            LinkedList[] stmts = new LinkedList[ctxs.length];
            for (int i = 0; i < ctxs.length; ++i) {
                stmts[i] = ctxs[i].getAllStatements();
            }
            LinkedList allStmts = new LinkedList();
            for (int i = 0; i < stmts.length; ++i) {
                allStmts.addAll(stmts[i]);
            }
            Collections.sort(allStmts);
            Iterator iter = allStmts.iterator();
            while (iter.hasNext()) {
                Logger.error(iter.next().toString(), DEBUG_TXN_TAG);
            }
            TransactionContext[] oldTxns = null;
            LinkedList linkedList = this.mOldContexts;
            synchronized (linkedList) {
                oldTxns = this.mOldContexts.toArray(new TransactionContext[this.mOldContexts.size()]);
            }
            if (oldTxns.length > 0) {
                Logger.error("OLD TXNS:", DEBUG_TXN_TAG);
                for (int i = 0; i < oldTxns.length; ++i) {
                    allStmts = oldTxns[i].getAllStatements();
                    iter = allStmts.iterator();
                    while (iter.hasNext()) {
                        Logger.error(iter.next().toString(), DEBUG_TXN_TAG);
                    }
                }
            }
        }
    }

    protected TransactionContext registerTransaction(Transaction inTransaction, Database inDatabase, Boolean shouldAcquireRead) throws ConnectionNotAvailable, SQLException {
        TransactionContext theContext = super.registerTransaction(inTransaction, inDatabase, shouldAcquireRead);
        this.mActiveContexts.add(theContext);
        return theContext;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void unregisterTransaction() {
        TransactionContext ctx = this.retrieveContext();
        super.unregisterTransaction();
        if (ctx != null) {
            this.mActiveContexts.remove(ctx);
            LinkedList linkedList = this.mOldContexts;
            synchronized (linkedList) {
                this.mOldContexts.addLast(ctx);
                while (this.mOldContexts.size() > 3) {
                    this.mOldContexts.removeFirst();
                }
            }
        }
    }

    public void addSQLStatement(SQLStatement inStatement) {
        TransactionContext ctx = this.retrieveContext();
        if (ctx != null) {
            ctx.addSQLStatement(inStatement);
        }
    }
}

