/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.persist;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.node.bootstrap.BootStrap;
import com.raplix.rolloutexpress.persist.Messages;
import com.raplix.rolloutexpress.persist.PersistenceManager;
import com.raplix.rolloutexpress.persist.PostgresMaintenanceApplication;
import com.raplix.rolloutexpress.persist.sql.ConnectionNotAvailable;
import com.raplix.rolloutexpress.persist.sql.DBConnection;
import com.raplix.rolloutexpress.persist.sql.Database;
import com.raplix.rolloutexpress.persist.sql.SQLParser;
import com.raplix.rolloutexpress.persist.sql.SQLStatement;
import com.raplix.util.executor.Exec;
import com.raplix.util.logger.Logger;
import com.raplix.util.string.StringUtil;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;

public abstract class DatabaseMaintenanceApplication
extends Application
implements Messages {
    protected static final int DBM_EXIT_TIMEOUT = -2;
    protected static final int DBM_EXIT_ABNORMAL = -1;
    protected static final int DBM_EXIT_NORMAL = 0;
    protected static final int DBM_EXIT_FAIL = 1;
    protected static final int DBM_EXIT_CONFIG_ERROR = 127;
    protected static final int DBM_EXIT_SQL_ERROR = 128;
    protected static final int DBM_EXIT_UNKNOWN_ERROR = 129;
    protected PersistenceManager mPM = new PersistenceManager(this, false, null, false);

    public static int invoke(String[] args, Application inApp) {
        try {
            long streamTimeout;
            long execTimeout;
            Process p;
            Exec e;
            Vector commandLine = DatabaseMaintenanceApplication.buildCommandLine(args, inApp);
            if (Logger.isDebugEnabled(DatabaseMaintenanceApplication.class)) {
                Logger.debug("Invoking Database Maintenance with CommandLine:" + commandLine, DatabaseMaintenanceApplication.class);
            }
            if ((e = new Exec(p = Runtime.getRuntime().exec(commandLine.toArray(new String[commandLine.size()])), new ByteArrayInputStream(new byte[0]), System.out, System.err, false, execTimeout = Long.parseLong(System.getProperty("dbm.execTimeout", String.valueOf(-1L))), streamTimeout = Long.parseLong(System.getProperty("dbm.streamTimeout", "3000")))).isTimedOut()) {
                if (Logger.isErrorEnabled(DatabaseMaintenanceApplication.class)) {
                    Logger.error(new ROXMessage("pm.DBM_TIMEOUT_ERROR").toString(), DatabaseMaintenanceApplication.class);
                }
                return -2;
            }
            return e.getExitCode();
        }
        catch (Exception e) {
            if (Logger.isErrorEnabled(DatabaseMaintenanceApplication.class)) {
                Logger.error(new ROXMessage("pm.DBM_UNEXPECTED_ERROR").toString(), e, DatabaseMaintenanceApplication.class);
            }
            return -1;
        }
    }

    private static Vector buildCommandLine(String[] args, Application inApp) {
        String classpath = System.getProperty("java.class.path");
        String roxHomeDir = System.getProperty("rox_home_dir");
        String roxWinUtilsDir = System.getProperty("rox_winutils_dir");
        String roxAppImplDir = System.getProperty("rox_appimpl_dir");
        String userHome = System.getProperty("user.home");
        String policyFile = System.getProperty("java.security.policy");
        String jaasFile = System.getProperty("java.security.auth.login.config");
        String javaHome = System.getProperty("java.home");
        Vector<String> commandLine = new Vector<String>();
        commandLine.add(new File(new File(javaHome, "bin"), "java").getAbsolutePath());
        DatabaseMaintenanceApplication.addExtraOptions(commandLine, DatabaseMaintenanceApplication.getAppProperty(inApp, "dbm.jvmargs", ""));
        commandLine.add("-Xms" + DatabaseMaintenanceApplication.getAppProperty(inApp, "dbm.xms", "24m"));
        commandLine.add("-Xmx" + DatabaseMaintenanceApplication.getAppProperty(inApp, "dbm.xmx", "192m"));
        boolean noServerArgs = DatabaseMaintenanceApplication.getAppProperty(inApp, "dbm.nosserverargs", "false").equals("true");
        commandLine.add("-Djava.security.manager");
        commandLine.add("-Djava.security.policy=" + policyFile);
        commandLine.add("-Djava.security.auth.login.config=" + jaasFile);
        commandLine.add("-Duser.home=" + userHome);
        commandLine.add("-Drox_home_dir=" + roxHomeDir);
        commandLine.add("-Djava.net.preferIPv4Stack=true");
        if (roxWinUtilsDir != null) {
            commandLine.add("-Drox_winutils_dir=" + roxWinUtilsDir);
        }
        if (roxAppImplDir != null) {
            commandLine.add("-Drox_appimpl_dir=" + roxAppImplDir);
        }
        commandLine.add("-cp");
        commandLine.add(classpath);
        commandLine.add(BootStrap.class.getName());
        if (Logger.isDebugEnabled(DatabaseMaintenanceApplication.class)) {
            commandLine.add("-verbose");
        }
        commandLine.add(DatabaseMaintenanceApplication.class.getName());
        if (args != null && args.length > 0 && !noServerArgs) {
            commandLine.addAll(Arrays.asList(args));
        }
        DatabaseMaintenanceApplication.addExtraOptions(commandLine, DatabaseMaintenanceApplication.getAppProperty(inApp, "dbm.appargs", ""));
        return commandLine;
    }

    public DatabaseMaintenanceApplication(String[] inCommandLineArgs) throws ConfigurationException {
        super(inCommandLineArgs);
    }

    public static void main(String[] args) {
        PostgresMaintenanceApplication pma = null;
        try {
            pma = new PostgresMaintenanceApplication(args);
        }
        catch (ConfigurationException ce) {
            if (Logger.isErrorEnabled(DatabaseMaintenanceApplication.class)) {
                Logger.error(new ROXMessage("pm.DBM_CONFIGURATION_ERROR").toString(), ce, DatabaseMaintenanceApplication.class);
            }
            System.exit(1);
        }
        pma.maintainDB();
    }

    private static void addExtraOptions(Vector cmdLine, String args) {
        if (StringUtil.isEmpty(args)) {
            return;
        }
        StringTokenizer strTok = new StringTokenizer(args);
        while (strTok.hasMoreTokens()) {
            cmdLine.add(strTok.nextToken());
        }
    }

    static String getAppProperty(Application inApp, String inPropertyName, String defaultVal) {
        try {
            String tmp = inApp.getConfiguration(inPropertyName);
            if (tmp != null) {
                return tmp;
            }
        }
        catch (ConfigurationException configurationException) {
            // empty catch block
        }
        return defaultVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected void maintainDB() {
        block27: {
            int exitStatus;
            block26: {
                exitStatus = 1;
                if (!this.executeSQLResource(this.mPM.getDefaultDatabase(), this.getReindexSchemaFilename())) break block26;
                exitStatus = 0;
            }
            Object var4_2 = null;
            try {
                this.shutdown();
            }
            catch (RaplixShutdownException ignore) {
            }
            finally {
                this.exitProcess(exitStatus);
            }
            {
                catch (ConfigurationException ce) {
                    if (Logger.isErrorEnabled(DatabaseMaintenanceApplication.class)) {
                        Logger.error(new ROXMessage("pm.DBM_CONFIGURATION_ERROR").toString(), ce, DatabaseMaintenanceApplication.class);
                    }
                    exitStatus = 127;
                    Object var4_3 = null;
                    try {
                        this.shutdown();
                    }
                    catch (RaplixShutdownException ignore) {
                        break block27;
                    }
                    finally {
                        this.exitProcess(exitStatus);
                    }
                }
                catch (SQLException e) {
                    if (Logger.isErrorEnabled(DatabaseMaintenanceApplication.class)) {
                        Logger.error(new ROXMessage("pm.DBM_SQL_ERROR").toString(), e, DatabaseMaintenanceApplication.class);
                    }
                    exitStatus = 128;
                    Object var4_4 = null;
                    try {
                        this.shutdown();
                    }
                    catch (RaplixShutdownException ignore) {
                        break block27;
                    }
                    finally {
                        this.exitProcess(exitStatus);
                    }
                }
                catch (Exception e) {
                    if (Logger.isErrorEnabled(DatabaseMaintenanceApplication.class)) {
                        Logger.error(new ROXMessage("pm.DBM_UNEXPECTED_ERROR").toString(), e, DatabaseMaintenanceApplication.class);
                    }
                    exitStatus = 129;
                    Object var4_5 = null;
                    try {
                        this.shutdown();
                    }
                    catch (RaplixShutdownException ignore) {
                        break block27;
                    }
                    finally {
                        this.exitProcess(exitStatus);
                    }
                }
            }
            catch (Throwable throwable) {
                Object var4_6 = null;
                try {
                    this.shutdown();
                }
                catch (RaplixShutdownException ignore) {
                }
                finally {
                    this.exitProcess(exitStatus);
                }
                throw throwable;
            }
        }
    }

    protected boolean executeSQLResource(Database db, String resourceName) throws ConfigurationException, SQLException {
        DBConnection conn = null;
        boolean isDBMaintenanceSuccessfull = false;
        InputStream is = this.getClass().getResourceAsStream(resourceName);
        if (is == null) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(new ROXMessage("pm.DBM_READING_MAINT_FILE_ERROR", new String[]{resourceName}).toString(), this);
            }
            return isDBMaintenanceSuccessfull;
        }
        try {
            conn = db.getConnection();
        }
        catch (ConnectionNotAvailable connectionNotAvailable) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(new ROXMessage("pm.DBM_DB_CONN_UNAVALIABLE").toString(), this);
            }
            throw new SQLException(connectionNotAvailable.getMessage());
        }
        try {
            String sql;
            SQLParser parser = new SQLParser(is);
            if (Logger.isInfoEnabled(this)) {
                Logger.info(new ROXMessage("pm.DBM_REINDEX_VACUUM_START").toString(), this);
            }
            while ((sql = parser.getNextStatement()) != null) {
                int retStatus = this.execSQL(conn, sql);
                if (!Logger.isInfoEnabled(this)) continue;
                Logger.info(sql + '\t' + "-" + '\t' + (retStatus == 1 ? "OK" : "Failed"), this);
            }
            if (Logger.isInfoEnabled(this)) {
                Logger.info(new ROXMessage("pm.DBM_REINDEX_VACUUM_END").toString(), this);
            }
            isDBMaintenanceSuccessfull = true;
        }
        catch (IOException e) {
            throw new ConfigurationException(new ROXMessage("pm.DBM_READING_MAINT_FILE_ERROR", new String[]{resourceName}), (Throwable)e, 1);
        }
        finally {
            db.returnConnection(conn);
        }
        return isDBMaintenanceSuccessfull;
    }

    protected int execSQL(DBConnection conn, String sql) throws SQLException {
        SQLStatement sqlStmt = new SQLStatement();
        sqlStmt.addSQLClause(sql);
        conn.setAutoCommit(true);
        return conn.processUpdate(sqlStmt);
    }

    protected String getVersionString() {
        return "5.2.1";
    }

    protected void shutdown() throws RaplixShutdownException {
        if (this.mPM != null) {
            this.mPM.shutdown();
        }
    }

    protected void buildConfigurationFilesForSubsystems(Hashtable inTable) throws ConfigurationException {
    }

    public NetSubsystem getNetSubsystem() {
        return null;
    }

    protected void exitProcess(int inExitCode) {
        super.exitProcess(inExitCode);
    }

    protected abstract String getReindexSchemaFilename() throws ConfigurationException;
}

