/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.node.upgrade.CommandLine;
import com.raplix.rolloutexpress.node.upgrade.ExecCommandException;
import com.raplix.rolloutexpress.node.upgrade.UpgradeEnvironmentDependencies;
import com.raplix.rolloutexpress.node.upgrade.UpgradeFileData;
import com.raplix.rolloutexpress.node.upgrade.UpgradeServiceException;
import com.raplix.rolloutexpress.node.upgrade.UpgradeServices;
import java.util.ArrayList;

class UpgradeTaskUtil {
    private UpgradeTaskUtil() {
    }

    static String checkPlatformSupport(UpgradeFileData[] upgradeFiles, UpgradeServices service) throws Exception {
        int i;
        boolean isPlatformDesupported;
        ArrayList<String> platforms = new ArrayList<String>();
        for (int i2 = 0; i2 < upgradeFiles.length; ++i2) {
            String[] versions = upgradeFiles[i2].getDesupportedPlatformVersions(service);
            for (int j = 0; j < versions.length; ++j) {
                platforms.add(versions[j]);
            }
        }
        if (platforms.isEmpty()) {
            return null;
        }
        String[] desupportedPlatforms = platforms.toArray(new String[0]);
        if (UpgradeEnvironmentDependencies.isGetNodeInfoMethodAvailable(service.getApplicationVersion())) {
            isPlatformDesupported = false;
            String osVersion = service.getNodeInfo().getOSVersion();
            for (i = 0; i < desupportedPlatforms.length; ++i) {
                if (!osVersion.startsWith(desupportedPlatforms[i].trim())) continue;
                isPlatformDesupported = true;
            }
        } else {
            isPlatformDesupported = UpgradeTaskUtil.isOSVersion(desupportedPlatforms, service);
        }
        if (isPlatformDesupported) {
            StringBuffer platformList = new StringBuffer();
            for (i = 0; i < desupportedPlatforms.length; ++i) {
                platformList.append(desupportedPlatforms[i]);
                if (i >= desupportedPlatforms.length - 1) continue;
                platformList.append(", ");
            }
            return platformList.toString();
        }
        return null;
    }

    static String checkPlatformSupport(UpgradeFileData upgradeFile, UpgradeServices service) throws Exception {
        return UpgradeTaskUtil.checkPlatformSupport(new UpgradeFileData[]{upgradeFile}, service);
    }

    static String checkMissingPatches(UpgradeFileData[] upgradeFiles, UpgradeServices service) throws Exception {
        ArrayList<String> patches = new ArrayList<String>();
        for (int i = 0; i < upgradeFiles.length; ++i) {
            String[] reqPatches = upgradeFiles[i].getRequiredPatches(service);
            for (int j = 0; j < reqPatches.length; ++j) {
                patches.add(reqPatches[j]);
            }
        }
        String[] allPatches = patches.toArray(new String[0]);
        return UpgradeTaskUtil.getMissingPatches(allPatches, service);
    }

    static String checkMissingPatches(UpgradeFileData upgradeFile, UpgradeServices service) throws Exception {
        return UpgradeTaskUtil.checkMissingPatches(new UpgradeFileData[]{upgradeFile}, service);
    }

    static boolean isOSVersion(String[] osVersions, UpgradeServices service) throws RPCException, UpgradeServiceException {
        CommandLine.Builder cmdBuilder;
        StringBuffer grepExp = new StringBuffer();
        grepExp.append("(");
        for (int i = 0; i < osVersions.length; ++i) {
            grepExp.append(osVersions[i]);
            if (i >= osVersions.length - 1) continue;
            grepExp.append("|");
        }
        grepExp.append(")");
        CommandLine command = null;
        String platformName = service.getPlatformName();
        if ("SunOS".equals(platformName)) {
            cmdBuilder = CommandLine.getBuilder();
            cmdBuilder.addString("/bin/sh");
            cmdBuilder.nextElement();
            cmdBuilder.addString("-c");
            cmdBuilder.nextElement();
            cmdBuilder.addString("if /bin/uname -r | /bin/egrep \"" + grepExp + "\"; then exit 101; fi");
            cmdBuilder.nextElement();
            command = cmdBuilder.getCommandLine();
        } else if ("Linux".equals(platformName)) {
            cmdBuilder = CommandLine.getBuilder();
            cmdBuilder.addString("/bin/sh");
            cmdBuilder.nextElement();
            cmdBuilder.addString("-c");
            cmdBuilder.nextElement();
            cmdBuilder.addString("if /bin/egrep \"" + grepExp + "\" /etc/redhat-release; then exit 101; fi");
            cmdBuilder.nextElement();
            command = cmdBuilder.getCommandLine();
        } else if ("AIX".equals(platformName)) {
            cmdBuilder = CommandLine.getBuilder();
            cmdBuilder.addString("/bin/sh");
            cmdBuilder.nextElement();
            cmdBuilder.addString("-c");
            cmdBuilder.nextElement();
            cmdBuilder.addString("if /usr/bin/oslevel | /bin/egrep \"" + grepExp + "\"; then exit 101; fi");
            cmdBuilder.nextElement();
            command = cmdBuilder.getCommandLine();
        } else {
            return false;
        }
        try {
            service.executeCommand(command, -1L, false);
        }
        catch (UpgradeServiceException e) {
            if (e instanceof ExecCommandException) {
                ExecCommandException execExcep = (ExecCommandException)e;
                if (101 == execExcep.getExitCode()) {
                    return true;
                }
                throw e;
            }
            String errCode = (String)e.getROXMessage().getArguments()[1];
            if (errCode.equals("101")) {
                return true;
            }
            throw e;
        }
        return false;
    }

    private static String getMissingPatches(String[] patchIds, UpgradeServices service) throws Exception {
        CommandLine.Builder cmdBuilder;
        StringBuffer reqPatches;
        String osName = service.getPlatformName();
        CommandLine command = null;
        if ("SunOS".equals(osName)) {
            reqPatches = new StringBuffer();
            for (int i = 0; i < patchIds.length; ++i) {
                reqPatches.append(patchIds[i] + " ");
            }
            cmdBuilder = CommandLine.getBuilder();
            cmdBuilder.addString("/bin/sh");
            cmdBuilder.nextElement();
            cmdBuilder.addString("-c");
            cmdBuilder.nextElement();
            cmdBuilder.addString("PATCHES=\"" + reqPatches + "\";");
            cmdBuilder.addString("SUCCESS=1;");
            cmdBuilder.addString("for patch in $PATCHES; do ");
            cmdBuilder.addString("p1=`echo $patch | cut -f1 -d- `;");
            cmdBuilder.addString("p2=`echo $patch | cut -f2 -d- `;");
            cmdBuilder.addString("sysPatches=`showrev -p | cut -f2 -d' ' | grep $p1`;");
            cmdBuilder.addString("if [ -n \"$sysPatches\" ]; then ");
            cmdBuilder.addString("LOCAL_SUCCESS=0;");
            cmdBuilder.addString("for sysPatch in $sysPatches; do ");
            cmdBuilder.addString("sp2=`echo $sysPatch | cut -f2 -d- `;");
            cmdBuilder.addString("if [ $sp2 -ge $p2 ]; then ");
            cmdBuilder.addString("LOCAL_SUCCESS=1;");
            cmdBuilder.addString("fi ");
            cmdBuilder.addString("done;");
            cmdBuilder.addString("if [ $LOCAL_SUCCESS = 0 ]; then ");
            cmdBuilder.addString("SUCCESS=0;");
            cmdBuilder.addString("echo \"Missing Patch: $patch\";");
            cmdBuilder.addString("fi ");
            cmdBuilder.addString("else ");
            cmdBuilder.addString("SUCCESS=0;");
            cmdBuilder.addString("echo \"Missing Patch: $patch\";");
            cmdBuilder.addString("fi ");
            cmdBuilder.addString("done;");
            cmdBuilder.addString("if [ $SUCCESS = 0 ]; then ");
            cmdBuilder.addString("exit 101;");
            cmdBuilder.addString("fi ");
            cmdBuilder.nextElement();
            command = cmdBuilder.getCommandLine();
        } else if ("AIX".equals(osName)) {
            reqPatches = new StringBuffer();
            for (int i = 0; i < patchIds.length; ++i) {
                reqPatches.append(patchIds[i] + " ");
            }
            cmdBuilder = CommandLine.getBuilder();
            cmdBuilder.addString("/bin/sh");
            cmdBuilder.nextElement();
            cmdBuilder.addString("-c");
            cmdBuilder.nextElement();
            cmdBuilder.addString("PATCHES=\"" + reqPatches + "\";");
            cmdBuilder.addString("SUCCESS=1;");
            cmdBuilder.addString("for patch in $PATCHES; do ");
            cmdBuilder.addString("/usr/sbin/instfix -i -k $patch > /dev/null 2>&1;");
            cmdBuilder.addString("if [ 0 != $? ]; then ");
            cmdBuilder.addString("SUCCESS=0;");
            cmdBuilder.addString("echo \"Missing Patch: $patch\";");
            cmdBuilder.addString("fi ");
            cmdBuilder.addString("done;");
            cmdBuilder.addString("if [ $SUCCESS = 0 ]; then ");
            cmdBuilder.addString("exit 101;");
            cmdBuilder.addString("fi");
            cmdBuilder.nextElement();
            command = cmdBuilder.getCommandLine();
        } else {
            return null;
        }
        try {
            service.executeCommand(command, -1L, false);
        }
        catch (UpgradeServiceException e) {
            if (e instanceof ExecCommandException) {
                ExecCommandException execExcep = (ExecCommandException)e;
                if (101 == execExcep.getExitCode()) {
                    return execExcep.getLogFile().getAbsolutePath();
                }
                throw e;
            }
            String errCode = (String)e.getROXMessage().getArguments()[1];
            if (errCode.equals("101")) {
                return (String)e.getROXMessage().getArguments()[2];
            }
            throw e;
        }
        return null;
    }
}

