/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.node.upgrade.UpgradeNodeState;
import com.raplix.rolloutexpress.node.upgrade.UpgradeNodeStatus;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskID;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskState;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskStatus;
import java.util.Date;
import java.util.Enumeration;

public class UpgradeTaskSummary
implements RPCSerializable {
    private UpgradeTaskID mUpgradeTaskID;
    private Date mStartTime;
    private Date mEndTime;
    private UpgradeTaskState mTaskState;
    private int mUnprocessedNodeCount;
    private int mUpgradedNodeCount;
    private int mNotStartedNodeCount;
    private int mInProgressNodeCount;
    private int mUpgradingNodeCount;
    private int mSuccessfulNodeCount;
    private int mFailedNodeCount;
    private int mActionRequiredNodeCount;
    private int mPartiallyCompletedNodeCount;
    private int mDeployedNodeCount;
    private boolean mIsAborted;

    public UpgradeTaskID getTaskID() {
        return this.mUpgradeTaskID;
    }

    public Date getStartTime() {
        return this.mStartTime;
    }

    public Date getEndTime() {
        return this.mEndTime;
    }

    public UpgradeTaskState getTaskState() {
        return this.mTaskState;
    }

    public int getUnprocessedNodeCount() {
        return this.mUnprocessedNodeCount;
    }

    public int getUpgradedNodeCount() {
        return this.mUpgradedNodeCount;
    }

    public int getNotStartedNodeCount() {
        return this.mNotStartedNodeCount;
    }

    public int getInProgressNodeCount() {
        return this.mInProgressNodeCount;
    }

    public int getUpgradingNodeCount() {
        return this.mUpgradingNodeCount;
    }

    public int getActionRequiredNodeCount() {
        return this.mActionRequiredNodeCount;
    }

    public int getSuccessfulNodeCount() {
        return this.mSuccessfulNodeCount;
    }

    public int getFailedNodeCount() {
        return this.mFailedNodeCount;
    }

    public int getPartiallyCompletedNodeCount() {
        return this.mPartiallyCompletedNodeCount;
    }

    public int getDeployedNodeCount() {
        return this.mDeployedNodeCount;
    }

    public boolean isAborted() {
        return this.mIsAborted;
    }

    private UpgradeTaskSummary() {
    }

    UpgradeTaskSummary(UpgradeTaskStatus taskStatus) {
        this.mUpgradeTaskID = taskStatus.getTaskID();
        this.mStartTime = taskStatus.getStartTime();
        this.mEndTime = taskStatus.getEndTime();
        this.mTaskState = taskStatus.getTaskState();
        this.mIsAborted = taskStatus.isAborted();
        Enumeration enumeration = taskStatus.getNodeStatus();
        while (enumeration.hasMoreElements()) {
            UpgradeNodeState nodeState = ((UpgradeNodeStatus)enumeration.nextElement()).getState();
            if (UpgradeNodeState.UNPROCESSED.equals(nodeState)) {
                ++this.mUnprocessedNodeCount;
            }
            if (UpgradeNodeState.UPGRADED.equals(nodeState)) {
                ++this.mUpgradedNodeCount;
            }
            if (UpgradeNodeState.NOT_STARTED.equals(nodeState)) {
                ++this.mNotStartedNodeCount;
            }
            if (UpgradeNodeState.IN_PROGRESS.equals(nodeState)) {
                ++this.mInProgressNodeCount;
            }
            if (UpgradeNodeState.UPGRADING.equals(nodeState)) {
                ++this.mUpgradingNodeCount;
            }
            if (UpgradeNodeState.SUCCESSFUL.equals(nodeState)) {
                ++this.mSuccessfulNodeCount;
            }
            if (UpgradeNodeState.FAILED.equals(nodeState)) {
                ++this.mFailedNodeCount;
            }
            if (UpgradeNodeState.ACTION_REQUIRED.equals(nodeState)) {
                ++this.mActionRequiredNodeCount;
            }
            if (UpgradeNodeState.PARTIALLY_COMPLETED.equals(nodeState)) {
                ++this.mPartiallyCompletedNodeCount;
            }
            if (!UpgradeNodeState.DEPLOYED.equals(nodeState)) continue;
            ++this.mDeployedNodeCount;
        }
    }
}

