/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.node.upgrade.UpgradeNodeState;
import com.raplix.rolloutexpress.node.upgrade.UpgradeNodeStatus;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTask;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskID;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskState;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskSummary;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;

public class UpgradeTaskStatus
implements RPCSerializable {
    private boolean mAborted;
    private String mDetail;
    private Vector mNodeStatus = new Vector();
    private UpgradeTaskID mID;
    private Date mStartTime;
    private Date mEndTime;
    private UpgradeTaskState mTaskState;

    public boolean isComplete() {
        return UpgradeTaskState.COMPLETED.equals(this.getTaskState());
    }

    public int getNumNodes() {
        return this.mNodeStatus.size();
    }

    public Enumeration getNodeStatus() {
        return this.mNodeStatus.elements();
    }

    public UpgradeTaskID getTaskID() {
        return this.mID;
    }

    public int getNumHostsWithStatus(UpgradeNodeState inState) {
        Enumeration enumeration = this.getNodeStatus();
        int cnt = 0;
        while (enumeration.hasMoreElements()) {
            if (!inState.equals(((UpgradeNodeStatus)enumeration.nextElement()).getState())) continue;
            ++cnt;
        }
        return cnt;
    }

    public UpgradeNodeStatus[] getAllNodeStatus() {
        return this.mNodeStatus.toArray(new UpgradeNodeStatus[this.mNodeStatus.size()]);
    }

    public boolean isAborted() {
        return this.mAborted;
    }

    public String getDetail() {
        return this.mDetail;
    }

    public Date getStartTime() {
        return this.mStartTime;
    }

    public Date getEndTime() {
        return this.mEndTime;
    }

    public UpgradeTaskState getTaskState() {
        return this.mTaskState;
    }

    private UpgradeTaskStatus() {
    }

    UpgradeTaskStatus(UpgradeTask task) {
        this.mID = task.getTaskID();
        this.mAborted = task.isTaskAborted();
        this.mDetail = task.getDetail();
        this.mStartTime = task.getStartTime();
        this.mEndTime = task.getEndTime();
        this.mTaskState = task.getTaskState();
    }

    void addStatus(UpgradeNodeStatus status) {
        this.mNodeStatus.add(status);
    }

    public String toString() {
        return "UpgradeTaskStatus:id=" + this.mID + ":state=" + this.mTaskState + ":aborted=" + this.mAborted + ":detail=" + this.mDetail;
    }

    public UpgradeTaskSummary computeUpgradeTaskSummary() {
        return new UpgradeTaskSummary(this);
    }
}

