/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.RaplixException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.HostNotFound;
import com.raplix.rolloutexpress.net.transport.TransportControl;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.node.NodeUtils;
import com.raplix.rolloutexpress.node.bootstrap.UpgradeBootStrap;
import com.raplix.rolloutexpress.node.bootstrap.VersionComparator;
import com.raplix.rolloutexpress.node.upgrade.AbsoluteFilePath;
import com.raplix.rolloutexpress.node.upgrade.CommandLine;
import com.raplix.rolloutexpress.node.upgrade.FileAssociationRequest;
import com.raplix.rolloutexpress.node.upgrade.NodeInfo;
import com.raplix.rolloutexpress.node.upgrade.UpgradeEnvironmentDependencies;
import com.raplix.rolloutexpress.node.upgrade.UpgradeExecutionManager;
import com.raplix.rolloutexpress.node.upgrade.UpgradeFileData;
import com.raplix.rolloutexpress.node.upgrade.UpgradeJarFinder;
import com.raplix.rolloutexpress.node.upgrade.UpgradeNode;
import com.raplix.rolloutexpress.node.upgrade.UpgradeNodeState;
import com.raplix.rolloutexpress.node.upgrade.UpgradeNodeVisitor;
import com.raplix.rolloutexpress.node.upgrade.UpgradeServices;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskID;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskState;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskStatus;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskUtil;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.Platform;
import com.raplix.util.threads.Context;
import com.raplix.util.threads.RunnableContext;
import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;

public class UpgradeTask
extends RunnableContext {
    private UpgradeNode mRoot;
    private UpgradeTaskID mTaskID;
    private UpgradeExecutionManager mExecutionManager;
    private UpgradeTaskState mTaskState = UpgradeTaskState.FIND_UPGRADE_NODES;
    private boolean mIsTaskAborted;
    private Exception mFailure;
    private String mDetail;
    private Date mStartTime;
    private Date mEndTime;
    private static final Context TOP_LEVEL_CONTEXT = new Context("UpgradeTask");
    private static final String[] APP_LIB_SUB_PATH = new String[]{"lib", "upgrade"};
    private static final String[] COMMON_LIB_SUB_PATH = new String[]{"..", "common", "lib", "upgrade"};
    private static final String UPGRADE_BOOTSTRAP_CLASS = UpgradeBootStrap.class.getName();

    protected final void failed(Throwable t) {
        Logger.error("Upgrade task Failed:", t, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected final void safeRun() {
        boolean nodesLocked;
        HashSet upgradableNodes;
        block17: {
            block16: {
                upgradableNodes = null;
                this.mStartTime = new Date();
                nodesLocked = false;
                try {
                    try {
                        this.logUpgradeTree();
                        this.pingAllLeaves();
                        this.logUpgradeTree();
                        this.runningNextStep();
                        upgradableNodes = this.markUpgradableNodes();
                        this.logUpgradeTree();
                        if (upgradableNodes.isEmpty()) {
                            this.setDetail(new ROXMessage("node.upgrade.NO_UPGRADABLE_NODES").toString());
                            if (Logger.isDebugEnabled(this)) {
                                Logger.debug("No upgradable nodes found", this);
                            }
                            Object var6_3 = null;
                            this.setComplete();
                            this.mExecutionManager.taskCompleted(this);
                            if (nodesLocked) {
                                this.mExecutionManager.unlockNodes(upgradableNodes);
                            }
                            break block16;
                        }
                        this.mExecutionManager.lockForUpgrade(upgradableNodes);
                        nodesLocked = true;
                        this.trimUpgradedNodes();
                        this.logUpgradeTree();
                        this.setTaskState(UpgradeTaskState.FIND_UPGRADE_PACKAGES);
                        this.runningNextStep();
                        this.findUpgradePaths();
                        this.logUpgradeTree();
                        HashMap requests = null;
                        try {
                            requests = this.mExecutionManager.assignDataIds(this.getRoot());
                            this.setTaskState(UpgradeTaskState.UPGRADING_NODES);
                            this.runningNextStep();
                            this.pushUpgradeJars(requests);
                            this.logUpgradeTree();
                            this.expireAllRequests(requests);
                            this.setTaskState(UpgradeTaskState.RESTARTING_NODES);
                            this.runningNextStep();
                            this.restartDeployedNodes(this.mExecutionManager.mNodeRestartSeconds);
                            this.logUpgradeTree();
                            Thread.sleep(this.mExecutionManager.mNodeRestartSeconds * 1000 * 2);
                            break block17;
                        }
                        finally {
                            this.mExecutionManager.expireAssignedDataIds(requests);
                        }
                    }
                    catch (Exception e) {
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Error executing upgrade task:" + this.getTaskID(), e, this);
                        }
                        if (RaplixException.isInterruptedException(e)) {
                            this.setTaskAborted();
                        }
                        this.setFailure(e);
                        Object var6_5 = null;
                        this.setComplete();
                        this.mExecutionManager.taskCompleted(this);
                        if (nodesLocked) {
                            this.mExecutionManager.unlockNodes(upgradableNodes);
                        }
                        Logger.debug("Done Upgrade task:", this);
                        this.logUpgradeTree();
                        return;
                    }
                }
                catch (Throwable throwable) {
                    Object var6_6 = null;
                    this.setComplete();
                    this.mExecutionManager.taskCompleted(this);
                    if (nodesLocked) {
                        this.mExecutionManager.unlockNodes(upgradableNodes);
                    }
                    Logger.debug("Done Upgrade task:", this);
                    this.logUpgradeTree();
                    throw throwable;
                }
            }
            Logger.debug("Done Upgrade task:", this);
            this.logUpgradeTree();
            return;
        }
        Object var6_4 = null;
        this.setComplete();
        this.mExecutionManager.taskCompleted(this);
        if (nodesLocked) {
            this.mExecutionManager.unlockNodes(upgradableNodes);
        }
        Logger.debug("Done Upgrade task:", this);
        this.logUpgradeTree();
    }

    private void restartDeployedNodes(final long restartSeconds) throws Exception {
        this.getRoot().traversePostOrder(new UpgradeNodeVisitor(){

            public boolean visit(UpgradeNode node) throws Exception {
                if (UpgradeNodeState.DEPLOYED.equals(node.getState())) {
                    try {
                        UpgradeServices services = UpgradeTask.this.getService(node.getAppInstance());
                        services.scheduleRestart(restartSeconds);
                        if (node.isUpgradeAPIUpgrade()) {
                            node.setState(UpgradeNodeState.PARTIALLY_COMPLETED);
                        } else {
                            node.setState(UpgradeNodeState.SUCCESSFUL);
                        }
                    }
                    catch (Exception e) {
                        if (RaplixException.isInterruptedException(e)) {
                            throw e;
                        }
                        node.setState(UpgradeNodeState.ACTION_REQUIRED);
                        node.setDetail(e.getMessage());
                    }
                }
                return true;
            }
        });
    }

    private void expireAllRequests(final HashMap requests) throws Exception {
        this.getRoot().traversePreOrder(new UpgradeNodeVisitor(){

            public boolean visit(UpgradeNode node) throws Exception {
                if (node.hasFilesToDeploy()) {
                    FileAssociationRequest request = null;
                    try {
                        UpgradeServices services = UpgradeTask.this.getService(node.getAppInstance());
                        UpgradeFileData[] data = node.getDeployFiles();
                        for (int i = 0; i < data.length; ++i) {
                            request = (FileAssociationRequest)requests.get(data[i]);
                            services.expire(request.getDataId());
                        }
                    }
                    catch (Exception e) {
                        if (RaplixException.isInterruptedException(e)) {
                            throw e;
                        }
                        return false;
                    }
                }
                return true;
            }
        });
    }

    private void pushUpgradeJars(final HashMap requests) throws Exception {
        this.getRoot().traversePreOrder(new UpgradeNodeVisitor(){

            public boolean visit(UpgradeNode node) throws Exception {
                FileAssociationRequest request = null;
                if (node.getParent() == null) {
                    UpgradeFileData[] data = node.getDeployFiles();
                    for (int i = 0; i < data.length; ++i) {
                        request = (FileAssociationRequest)requests.get(data[i]);
                        UpgradeTask.this.mExecutionManager.getTransferHandler().associate(request, data[i].getFile());
                    }
                    return true;
                }
                if (node.hasFilesToDeploy()) {
                    try {
                        if (node.canBeUpgraded()) {
                            node.setState(UpgradeNodeState.UPGRADING);
                        }
                        UpgradeServices services = UpgradeTask.this.getService(node.getAppInstance());
                        UpgradeServices parentServices = null;
                        if (node.getParent().getParent() != null) {
                            parentServices = UpgradeTask.this.getService(node.getParent().getAppInstance());
                        }
                        UpgradeFileData[] data = node.getDeployFiles();
                        for (int i = 0; i < data.length; ++i) {
                            request = (FileAssociationRequest)requests.get(data[i]);
                            services.createTemporaryFile(request);
                            if (parentServices != null) {
                                parentServices.sendFile(node.getAppInstance().getRoxAddress(), request.getDataId());
                                continue;
                            }
                            UpgradeTask.this.mExecutionManager.getTransferHandler().sendFile(node.getAppInstance().getRoxAddress(), request.getDataId());
                        }
                        if (node.canBeUpgraded()) {
                            try {
                                data = node.getUpgradeJars();
                                AbsoluteFilePath homeDir = services.getHomeDirectory();
                                for (int i = 0; i < data.length; ++i) {
                                    String upgradeApp;
                                    AbsoluteFilePath jarPath;
                                    request = (FileAssociationRequest)requests.get(data[i]);
                                    if (node.willUseOldUpgradeAPI()) {
                                        jarPath = (AbsoluteFilePath)homeDir.clone();
                                        jarPath.extend(COMMON_LIB_SUB_PATH);
                                        jarPath.extend(data[i].getTargetVerString());
                                        services.extractJar(request.getDataId(), jarPath);
                                        continue;
                                    }
                                    AbsoluteFilePath appLibPath = (AbsoluteFilePath)homeDir.clone();
                                    appLibPath.extend(APP_LIB_SUB_PATH);
                                    jarPath = (AbsoluteFilePath)appLibPath.clone();
                                    jarPath.extend(data[i].getTargetVerString());
                                    AbsoluteFilePath tmpJarPath = (AbsoluteFilePath)appLibPath.clone();
                                    tmpJarPath.extend("upgradeCan");
                                    services.extractJar(request.getDataId(), tmpJarPath);
                                    NodeInfo nodeInfo = services.getNodeInfo();
                                    Platform platform = new Platform(nodeInfo.getOSName(), "", nodeInfo.getOSArch());
                                    String nativeSubDir = NodeUtils.getNativeSubDir(node.getPlatform());
                                    String nativeArchSubDir = NodeUtils.getNativeArchSubDir(platform);
                                    if (!nativeSubDir.equals(nativeArchSubDir) && data[i].hasNativeArchSubDir(nativeArchSubDir)) {
                                        AbsoluteFilePath to_dir = new AbsoluteFilePath(tmpJarPath.toFile());
                                        AbsoluteFilePath from_dir = new AbsoluteFilePath(tmpJarPath.toFile());
                                        to_dir.extend(nativeSubDir.toString());
                                        from_dir.extend(nativeArchSubDir.toString());
                                        services.move(from_dir, to_dir);
                                    }
                                    if ((upgradeApp = data[i].getUpgradeAppMainClassName()) != null) {
                                        CommandLine.Builder cmdBuilder = CommandLine.getBuilder();
                                        UpgradeTask.this.mExecutionManager.computeAndAddJVMPath(cmdBuilder, (AbsoluteFilePath)homeDir.clone(), data[i], node);
                                        cmdBuilder.nextElement();
                                        cmdBuilder.addString("-Drox_home_dir=");
                                        cmdBuilder.addPath(homeDir);
                                        cmdBuilder.nextElement();
                                        if (AppType.LD.equals(node.getAppInstance().getType())) {
                                            cmdBuilder.addString("-Drox_is_ld=" + Boolean.TRUE);
                                        }
                                        if (AppType.RA.equals(node.getAppInstance().getType())) {
                                            cmdBuilder.addString("-Drox_is_ra=" + Boolean.TRUE);
                                        }
                                        cmdBuilder.nextElement();
                                        cmdBuilder.addString("-Drox_upgrade_source_version=" + data[i].getSourceVersion());
                                        cmdBuilder.nextElement();
                                        cmdBuilder.addString("-Drox_upgrade_target_version=" + data[i].getTargetVerString());
                                        cmdBuilder.nextElement();
                                        UpgradeTask.this.mExecutionManager.addNodeUpgradeAppJVMArgs(cmdBuilder);
                                        cmdBuilder.addString("-classpath");
                                        cmdBuilder.nextElement();
                                        AbsoluteFilePath bootStrapPath = (AbsoluteFilePath)tmpJarPath.clone();
                                        bootStrapPath.extend("cr_bs.jar");
                                        cmdBuilder.addPath(bootStrapPath);
                                        cmdBuilder.nextElement();
                                        cmdBuilder.addString(UPGRADE_BOOTSTRAP_CLASS);
                                        cmdBuilder.nextElement();
                                        if (Logger.isDebugEnabled(this)) {
                                            cmdBuilder.addString("-verbose");
                                            cmdBuilder.nextElement();
                                        }
                                        cmdBuilder.addString(upgradeApp);
                                        cmdBuilder.nextElement();
                                        CommandLine command = cmdBuilder.getCommandLine();
                                        String commandString = command.toString();
                                        if (Logger.isInfoEnabled(this)) {
                                            Logger.info("Executing command:" + commandString, this);
                                        }
                                        services.executeCommand(command, UpgradeTask.this.mExecutionManager.getSubsystem().getConfigNodeUpgradeAppTimeout(), true);
                                    }
                                    services.move(tmpJarPath, jarPath);
                                }
                                node.setState(UpgradeNodeState.DEPLOYED);
                            }
                            catch (Exception e) {
                                if (Logger.isDebugEnabled(this)) {
                                    Logger.debug("Exception when upgrading node", e, this);
                                }
                                if (RaplixException.isInterruptedException(e)) {
                                    throw e;
                                }
                                node.setState(UpgradeNodeState.FAILED);
                                node.setDetail(e.toString());
                            }
                        }
                    }
                    catch (Exception e) {
                        if (Logger.isDebugEnabled(this)) {
                            Logger.debug("Exception when deploying files to node", e, this);
                        }
                        if (RaplixException.isInterruptedException(e)) {
                            throw e;
                        }
                        node.traversePostOrder(new UpgradeNodeVisitor(this, e){
                            private final /* synthetic */ Exception val$e;
                            private final /* synthetic */ 3 this$1;
                            {
                                this.this$1 = this$1;
                                this.val$e = val$e;
                            }

                            public boolean visit(UpgradeNode node) {
                                if (node.canBeUpgraded()) {
                                    node.setState(UpgradeNodeState.FAILED);
                                    node.setDetail(this.val$e.getMessage());
                                }
                                return true;
                            }
                        });
                        return false;
                    }
                    return true;
                }
                return false;
            }
        });
    }

    private void findUpgradePaths() throws Exception {
        final String targetVersion = this.mExecutionManager.getSubsystem().getApplication().getRoxVersionNumber();
        final UpgradeJarFinder jarFinder = new UpgradeJarFinder(this.mExecutionManager.getUpgradeJarDir());
        this.getRoot().traversePostOrder(new UpgradeNodeVisitor(){

            public boolean visit(UpgradeNode node) {
                if (UpgradeNodeState.NOT_STARTED.equals(node.getState())) {
                    UpgradeFileData[] upgradeRoute = null;
                    try {
                        upgradeRoute = jarFinder.findUpgradePath(node.getVersion(), targetVersion);
                    }
                    catch (IOException ioe) {
                        node.setState(UpgradeNodeState.FAILED);
                        node.setDetail(ioe.toString());
                        return true;
                    }
                    if (upgradeRoute == null) {
                        node.setState(UpgradeNodeState.FAILED);
                        boolean isDowngrade = VersionComparator.INSTANCE.compareVersion(targetVersion, node.getVersion()) < 0;
                        node.setDetail(new ROXMessage(isDowngrade ? "node.upgrade.INVALID_UPGRADE_VERSION" : "node.upgrade.NO_UPGRADE_JARS", new Object[]{node.getAppInstance().getType().getApplicationName(), node.getHostName(), node.getVersion(), targetVersion}).getMessageString());
                    } else {
                        try {
                            if (!UpgradeEnvironmentDependencies.willUseOldUpgradeAPI(node.getVersion())) {
                                UpgradeServices service = UpgradeTask.this.getService(node.getAppInstance());
                                String platformsDesupported = UpgradeTaskUtil.checkPlatformSupport(upgradeRoute, service);
                                String missingPatchesFile = UpgradeTaskUtil.checkMissingPatches(upgradeRoute, service);
                                if (platformsDesupported != null) {
                                    node.setState(UpgradeNodeState.FAILED);
                                    node.setDetail(new ROXMessage("node.upgrade.NODE_PLATFORM_NOT_SUPPORTED", new Object[]{node.getHostName(), platformsDesupported}).getMessageString());
                                } else if (missingPatchesFile != null) {
                                    node.setState(UpgradeNodeState.FAILED);
                                    node.setDetail(new ROXMessage("node.upgrade.NODE_REQUIRED_PATCHES_MISSING", new Object[]{node.getHostName(), missingPatchesFile}).getMessageString());
                                } else {
                                    node.setUpgradeJars(upgradeRoute);
                                    node.setState(UpgradeNodeState.IN_PROGRESS);
                                }
                            } else {
                                node.setUpgradeJars(upgradeRoute);
                                node.setState(UpgradeNodeState.IN_PROGRESS);
                            }
                        }
                        catch (Exception e) {
                            node.setState(UpgradeNodeState.FAILED);
                            node.setDetail(e.toString());
                        }
                    }
                }
                return true;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trimUpgradedNodes() throws Exception {
        UpgradeNode upgradeNode = this.getRoot();
        synchronized (upgradeNode) {
            this.trimUpgradedChildren(this.getRoot());
        }
    }

    private void trimUpgradedChildren(UpgradeNode node) {
        UpgradeNode[] children = node.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.trimUpgradedChildren(children[i]);
        }
        if (!node.hasChildren() && UpgradeNodeState.UPGRADED.equals(node.getState())) {
            node.setParent(null);
        }
    }

    private HashSet markUpgradableNodes() throws Exception {
        final HashSet upgradableNodes = new HashSet();
        this.getRoot().traversePreOrder(new UpgradeNodeVisitor(){

            public boolean visit(UpgradeNode node) throws Exception {
                try {
                    if (node.getParent() == null) {
                        return true;
                    }
                    UpgradeServices service = UpgradeTask.this.getService(node.getAppInstance());
                    node.setVersion(service.getApplicationVersion());
                    node.setPlatform(service.getPlatformName());
                    if (UpgradeExecutionManager.needsUpgrade(UpgradeTask.this.mExecutionManager.getSubsystem().getApplication(), node.getVersion())) {
                        node.setState(UpgradeNodeState.NOT_STARTED);
                        node.setReportStatus(true);
                        upgradableNodes.add(node);
                    } else {
                        node.setState(UpgradeNodeState.UPGRADED);
                    }
                }
                catch (Exception e) {
                    if (RaplixException.isInterruptedException(e)) {
                        throw e;
                    }
                    node.traversePostOrder(new UpgradeNodeVisitor(this, e){
                        private final /* synthetic */ Exception val$e;
                        private final /* synthetic */ 6 this$1;
                        {
                            this.this$1 = this$1;
                            this.val$e = val$e;
                        }

                        public boolean visit(UpgradeNode node) {
                            node.setReportStatus(true);
                            node.setState(UpgradeNodeState.FAILED);
                            node.setDetail(this.val$e.getMessage());
                            return true;
                        }
                    });
                    return false;
                }
                return true;
            }
        });
        return upgradableNodes;
    }

    private void pingAllLeaves() throws Exception {
        final TransportControl control = this.mExecutionManager.getSubsystem().getApplication().getNetSubsystem().getTransport().getControl();
        this.getRoot().traversePostOrder(new UpgradeNodeVisitor(){

            public boolean visit(UpgradeNode node) throws Exception {
                block5: {
                    if (!node.hasChildren()) {
                        try {
                            control.pingAsync(node.getAppInstance().getRoxAddress());
                        }
                        catch (TransportException ignored) {
                        }
                        catch (HostNotFound ignored) {
                        }
                        catch (Exception e) {
                            if (!RaplixException.isInterruptedException(e)) break block5;
                            throw e;
                        }
                    }
                }
                return true;
            }
        });
    }

    private UpgradeServices getService(AppInstance app) throws RPCException {
        return this.mExecutionManager.getService(app);
    }

    protected UpgradeTask(UpgradeExecutionManager manager, UpgradeNode root, UpgradeTaskID taskID) {
        super(taskID.toString(), TOP_LEVEL_CONTEXT);
        this.mTaskID = taskID;
        this.mRoot = root;
        this.mExecutionManager = manager;
    }

    private UpgradeNode getRoot() {
        return this.mRoot;
    }

    UpgradeTaskID getTaskID() {
        return this.mTaskID;
    }

    boolean isTaskAborted() {
        return this.mIsTaskAborted;
    }

    Exception getFailure() {
        return this.mFailure;
    }

    void setTaskAborted() {
        this.mIsTaskAborted = true;
    }

    private void setFailure(Exception e) {
        this.mFailure = e;
        this.setDetail(e.toString());
    }

    private void setComplete() {
        this.setTaskState(UpgradeTaskState.COMPLETED);
        this.mEndTime = new Date();
    }

    String getDetail() {
        return this.mDetail;
    }

    private void setDetail(String detail) {
        this.mDetail = detail;
    }

    Date getStartTime() {
        return this.mStartTime;
    }

    Date getEndTime() {
        return this.mEndTime;
    }

    UpgradeTaskState getTaskState() {
        return this.mTaskState;
    }

    private void setTaskState(UpgradeTaskState taskState) {
        this.mTaskState = taskState;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Setting upgrade task state:" + taskState, this);
        }
    }

    protected void runningNextStep() throws Exception {
        this.testFlow();
    }

    private void logUpgradeTree() {
        block3: {
            if (Logger.isDebugEnabled(this)) {
                try {
                    this.getRoot().traversePreOrder(new UpgradeNodeVisitor(){

                        public boolean visit(UpgradeNode node) {
                            Logger.debug(node.toString(), this);
                            return true;
                        }
                    });
                }
                catch (Exception e) {
                    if (!Logger.isErrorEnabled(this)) break block3;
                    Logger.error("Error logging upgrade tree:", e, this);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    UpgradeTaskStatus computeTaskStatus() {
        final UpgradeTaskStatus status = new UpgradeTaskStatus(this);
        UpgradeNode upgradeNode = this.getRoot();
        synchronized (upgradeNode) {
            try {
                this.getRoot().traversePreOrder(new UpgradeNodeVisitor(){

                    public boolean visit(UpgradeNode node) throws Exception {
                        if (node.isReportStatus()) {
                            status.addStatus(node.getStatus());
                        }
                        return true;
                    }
                });
            }
            catch (Exception e) {
                Logger.error("Error computing status", e, this);
            }
        }
        return status;
    }
}

