/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.ft.DataId;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportManager;
import com.raplix.rolloutexpress.node.NodeUtils;
import com.raplix.rolloutexpress.node.upgrade.AbsoluteFilePath;
import com.raplix.rolloutexpress.node.upgrade.CommandLine;
import com.raplix.rolloutexpress.node.upgrade.DelayedAppRestartTool;
import com.raplix.rolloutexpress.node.upgrade.ExecCommandException;
import com.raplix.rolloutexpress.node.upgrade.FileAssociationRequest;
import com.raplix.rolloutexpress.node.upgrade.NodeInfo;
import com.raplix.rolloutexpress.node.upgrade.NodeUpgradeManager;
import com.raplix.rolloutexpress.node.upgrade.UpgradeServiceException;
import com.raplix.rolloutexpress.node.upgrade.UpgradeServices;
import com.raplix.util.Util;
import com.raplix.util.executor.Exec;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.Platform;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

class UpgradeServiceImpl
implements UpgradeServices {
    private NodeUpgradeManager mUpgradeManager;
    private final NodeInfo mNodeInfo;

    public String getApplicationVersion() throws RPCException {
        return this.mUpgradeManager.getSubsystem().getApplication().getRoxVersionNumber();
    }

    public String getPlatformName() throws RPCException {
        return NodeUtils.getLocalPlatformName();
    }

    public AbsoluteFilePath getHomeDirectory() throws RPCException {
        return new AbsoluteFilePath(this.mUpgradeManager.getSubsystem().getApplication().getHomeDirAbsPath());
    }

    public void scheduleRestart(long seconds) throws RPCException, UpgradeServiceException {
        TransportManager tManager = this.mUpgradeManager.getSubsystem().getApplication().getNetSubsystem().getTransport();
        if (tManager.requiresInteractiveInit()) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.NODE_REQUIRES_MANUAL_RESTART", this.mUpgradeManager.getSubsystem().getApplication().getName()));
        }
        if (tManager.isStdIOInvoked()) {
            this.scheduleShutdown(seconds);
            return;
        }
        File file = null;
        try {
            String restartScript = this.mUpgradeManager.getSubsystem().getConfigRestartScriptLocation();
            file = new File(restartScript);
            if (!file.exists()) {
                throw new UpgradeServiceException(new ROXMessage("node.upgrade.RESTART_SCRIPT_NOT_EXISTS", file.getAbsolutePath()));
            }
            DelayedAppRestartTool.invoke(seconds, restartScript);
        }
        catch (ConfigurationException e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_FIND_RESTART_SCRIPT", this.mUpgradeManager.getSubsystem().getApplication().getName()), (Throwable)e);
        }
        catch (IOException e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_RESTARTING_APP", this.mUpgradeManager.getSubsystem().getApplication().getName(), file.getAbsolutePath()), (Throwable)e);
        }
    }

    private void scheduleShutdown(final long seconds) {
        if (Logger.isInfoEnabled(this)) {
            Logger.info("Scheduling restart in " + seconds + " seconds", this);
        }
        new Thread("Shutdown application"){

            public void run() {
                block2: {
                    try {
                        Thread.sleep(seconds * 1000L);
                    }
                    catch (InterruptedException e) {
                        if (!Logger.isWarnEnabled(this)) break block2;
                        Logger.warn("Wait before shutdown initiation interrupted, restarting now.", this);
                    }
                }
                UpgradeServiceImpl.this.mUpgradeManager.getSubsystem().getApplication().forceEmergencyShutdown();
            }
        }.start();
    }

    public void prepareLogFileForDownload(FileAssociationRequest request) throws RPCException, UpgradeServiceException {
        File logFile = null;
        try {
            logFile = new File(this.mUpgradeManager.getSubsystem().getConfigLogFileLocation());
        }
        catch (ConfigurationException e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_FETCH_LOG_FILE_LOCATION", this.mUpgradeManager.getSubsystem().getApplication().getApplicationName()), (Throwable)e);
        }
        if (!logFile.exists()) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.LOG_FILE_NOT_EXISTS", logFile.getAbsolutePath(), this.mUpgradeManager.getSubsystem().getApplication().getApplicationName()));
        }
        this.mUpgradeManager.getUpgradeFileTransferer().associate(request, logFile);
    }

    public void associateFile(FileAssociationRequest request, AbsoluteFilePath path) throws RPCException, UpgradeServiceException {
        this.mUpgradeManager.getUpgradeFileTransferer().associate(request, path.toFile());
    }

    public void createTemporaryFile(FileAssociationRequest request) throws RPCException, UpgradeServiceException {
        this.mUpgradeManager.getUpgradeFileTransferer().createTempFile(request);
    }

    public void copyFile(DataId id, AbsoluteFilePath path) throws RPCException, UpgradeServiceException {
        this.mUpgradeManager.getUpgradeFileTransferer().copyFile(id, path.toFile());
    }

    public void expire(DataId id) throws RPCException {
        this.mUpgradeManager.getUpgradeFileTransferer().expire(id);
    }

    public void extractJar(DataId id, AbsoluteFilePath path) throws RPCException, UpgradeServiceException {
        this.mUpgradeManager.getUpgradeFileTransferer().extractJar(id, path.toFile(), this.mUpgradeManager.getSubsystem().getApplication().getHomeDirAbsPath());
    }

    public void sendFile(RoxAddress destination, DataId dataId) throws UpgradeServiceException {
        this.mUpgradeManager.getUpgradeFileTransferer().sendFile(destination, dataId);
    }

    public void getFile(RoxAddress source, DataId dataId) throws UpgradeServiceException {
        this.mUpgradeManager.getUpgradeFileTransferer().getFile(source, dataId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void executeCommand(CommandLine commandLine, long timeout, boolean feedCurrentConfiguration) throws UpgradeServiceException, RPCException {
        Object[] command = commandLine.getCommandLine();
        String commandString = Util.getStringFromArray(command, " ");
        try {
            Exec exec;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Executing command:" + commandString, this);
            }
            InputStream stdin = feedCurrentConfiguration ? NodeUtils.propertiesToStream(this.mUpgradeManager.getSubsystem().getApplication().getCurrentConfiguration()) : new ByteArrayInputStream(new byte[0]);
            long streamTimeout = timeout == -1L ? -1L : -3L;
            Process process = Runtime.getRuntime().exec((String[])command, null, new File(this.mUpgradeManager.getSubsystem().getApplication().getHomeDirAbsPath()));
            File log = File.createTempFile("upg", ".log");
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Logging output to:" + log.getAbsolutePath(), this);
            }
            FileOutputStream logStream = new FileOutputStream(log);
            try {
                exec = new Exec(process, stdin, logStream, logStream, false, timeout, streamTimeout);
            }
            finally {
                logStream.close();
            }
            if (exec.isTimedOut()) {
                throw new UpgradeServiceException(new ROXMessage(exec.getExecutionThread().isTimedOut() ? "node.upgrade.ERR_EXEC_CMD_TIMEOUT" : "node.upgrade.ERR_EXEC_CMD_STREAM_TIMEOUT", commandString, String.valueOf(timeout / 1000L), log.getAbsolutePath()));
            }
            if (exec.getExitCode() != 0) {
                throw new ExecCommandException(new ROXMessage("node.upgrade.NODE_UPGRADE_APP_FAILED", commandString, String.valueOf(exec.getExitCode()), log.getAbsolutePath()), exec.getExitCode(), log);
            }
        }
        catch (IOException e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_EXEC_CMD_FAILED", commandString), (Throwable)e);
        }
        catch (InterruptedException e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_EXEC_CMD_INTERRUPTED", commandString), (Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_EXEC_CMD_FAILED", commandString), (Throwable)e);
        }
    }

    public void move(AbsoluteFilePath inSourcePath, AbsoluteFilePath inDestinationPath) throws UpgradeServiceException, RPCException {
        File dest;
        File source = inSourcePath.toFile();
        if (!source.renameTo(dest = inDestinationPath.toFile())) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_MOVE_FILE", source.getAbsolutePath(), dest.getAbsolutePath()));
        }
    }

    public NodeInfo getNodeInfo() {
        return this.mNodeInfo;
    }

    public UpgradeServiceImpl(NodeUpgradeManager nodeManager) {
        this.mUpgradeManager = nodeManager;
        this.mNodeInfo = new NodeInfo(Platform.LOCAL, System.getProperty("file.separator"), System.getProperty("path.separator"), nodeManager.getSubsystem().getApplication());
    }
}

