/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.node.upgrade.UpgradeEnvironmentDependencies;
import com.raplix.rolloutexpress.node.upgrade.UpgradeFileData;
import com.raplix.rolloutexpress.node.upgrade.UpgradeNodeState;
import com.raplix.rolloutexpress.node.upgrade.UpgradeNodeStatus;
import com.raplix.rolloutexpress.node.upgrade.UpgradeNodeVisitor;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.util.logger.Logger;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;

public class UpgradeNode {
    private AppInstance mApp;
    private String mVersion;
    private String mPlatform;
    private String mHostName;
    private UpgradeNodeState mState = UpgradeNodeState.UNPROCESSED;
    private UpgradeNode mParent;
    private LinkedList mChildren = new LinkedList();
    private HashSet mAllFileList = new HashSet();
    private String mDetail;
    private UpgradeFileData[] mUpgradeJars;
    private boolean mReportStatus;

    void traversePostOrder(UpgradeNodeVisitor visitor) throws Exception {
        Iterator iter = this.mChildren.iterator();
        while (iter.hasNext()) {
            ((UpgradeNode)iter.next()).traversePostOrder(visitor);
        }
        visitor.visit(this);
    }

    void traversePreOrder(UpgradeNodeVisitor visitor) throws Exception {
        if (visitor.visit(this)) {
            Iterator iter = this.mChildren.iterator();
            while (iter.hasNext()) {
                ((UpgradeNode)iter.next()).traversePreOrder(visitor);
            }
        }
    }

    UpgradeNode[] getChildren() {
        return this.mChildren.toArray(new UpgradeNode[this.mChildren.size()]);
    }

    UpgradeNode(AppInstance app) throws RPCException, PersistenceManagerException {
        this.mApp = app;
        this.mHostName = app.getHostID().getByIDQuery().selectSummaryView().getName();
    }

    void setPlatform(String platform) {
        this.mPlatform = platform;
    }

    void setVersion(String version) {
        this.mVersion = version;
    }

    AppInstance getAppInstance() {
        return this.mApp;
    }

    UpgradeNodeState getState() {
        return this.mState;
    }

    void setState(UpgradeNodeState state) {
        this.mState = state;
    }

    String getHostName() {
        return this.mHostName;
    }

    UpgradeNodeStatus getStatus() {
        return new UpgradeNodeStatus(this.mHostName, this.getAppInstance().getType(), this.mDetail, this.mState);
    }

    String getDetail() {
        return this.mDetail;
    }

    void setDetail(String detail) {
        this.mDetail = detail;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Setting detail to:" + detail, new Exception("stackTrace"), this);
        }
    }

    UpgradeNode getParent() {
        return this.mParent;
    }

    boolean hasChildren() {
        return !this.mChildren.isEmpty();
    }

    void setParent(UpgradeNode parent) {
        if (this.mParent != null) {
            this.mParent.mChildren.remove(this);
        }
        this.mParent = parent;
        if (parent != null) {
            this.mParent.mChildren.add(this);
        }
    }

    String getVersion() {
        return this.mVersion;
    }

    String getPlatform() {
        return this.mPlatform;
    }

    UpgradeFileData[] getUpgradeJars() {
        return this.mUpgradeJars;
    }

    void setUpgradeJars(UpgradeFileData[] upgradeRoute) {
        this.mUpgradeJars = upgradeRoute;
        this.addDeployFiles(upgradeRoute);
    }

    boolean hasFilesToDeploy() {
        return !this.mAllFileList.isEmpty();
    }

    boolean canBeUpgraded() {
        return this.mUpgradeJars != null && this.mUpgradeJars.length > 0;
    }

    private void addDeployFiles(UpgradeFileData[] upgradeRoutes) {
        for (int i = 0; i < upgradeRoutes.length; ++i) {
            this.mAllFileList.add(upgradeRoutes[i]);
        }
        if (this.getParent() != null) {
            this.getParent().addDeployFiles(upgradeRoutes);
        }
    }

    UpgradeFileData[] getDeployFiles() {
        return this.mAllFileList.toArray(new UpgradeFileData[this.mAllFileList.size()]);
    }

    boolean isUpgradeAPIUpgrade() {
        return UpgradeEnvironmentDependencies.isUpgradeAPIUpgrade(this.mUpgradeJars[this.mUpgradeJars.length - 1].getTargetVerString());
    }

    boolean willUseOldUpgradeAPI() {
        return UpgradeEnvironmentDependencies.willUseOldUpgradeAPI(this.mUpgradeJars[this.mUpgradeJars.length - 1].getTargetVerString());
    }

    boolean isReportStatus() {
        return this.mReportStatus;
    }

    void setReportStatus(boolean b) {
        this.mReportStatus = b;
    }

    public String toString() {
        return "UpgradeNode:Host=" + this.mHostName + ":Platforn=" + this.mPlatform + ":Ver=" + this.mVersion + ":State=" + this.mState + ":Report=" + this.mReportStatus + ":Detail=" + this.mDetail + ":Files=" + this.mAllFileList;
    }
}

