/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.node.bootstrap.VersionComparator;
import com.raplix.rolloutexpress.node.upgrade.UpgradeEnvironmentDependencies;
import com.raplix.rolloutexpress.node.upgrade.UpgradeFileData;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UpgradeJarFinder {
    public static final String UPGRADE_FILE_PREFIX = "upgrade_";
    private File mUpgradeJarDir;
    private HashMap mSourceVersionTable = null;

    protected UpgradeJarFinder(File upgradeJarDir) {
        this.mUpgradeJarDir = upgradeJarDir;
    }

    public UpgradeFileData[] findUpgradePath(String sourceVersion, String targetVersion) throws IOException {
        targetVersion = UpgradeEnvironmentDependencies.checkIfWeNeedToUpgradeAPI(sourceVersion, targetVersion);
        StringBuffer sb = new StringBuffer(UPGRADE_FILE_PREFIX);
        sb.append(sourceVersion);
        sb.append('_');
        sb.append(targetVersion);
        sb.append(".jar");
        File file = new File(this.mUpgradeJarDir, sb.toString());
        if (!this.exists(file)) {
            return this.searchUpgradeJar(sourceVersion, targetVersion);
        }
        return new UpgradeFileData[]{new UpgradeFileData(sourceVersion, targetVersion, file)};
    }

    private UpgradeFileData[] searchUpgradeJar(String sourceVersion, String targetVersion) throws IOException {
        HashMap sourceVerTable = this.getSourceVersionTable();
        if (sourceVerTable.isEmpty()) {
            return null;
        }
        Stack upgradeRoute = new Stack();
        if (this.findUpgradeRoute(upgradeRoute, sourceVersion, targetVersion, sourceVerTable)) {
            return upgradeRoute.toArray(new UpgradeFileData[upgradeRoute.size()]);
        }
        return null;
    }

    public static String stripLastVersionNumber(String version) {
        if (version == null) {
            return null;
        }
        Pattern p = Pattern.compile("([\\d\\.]+)\\.\\d+");
        Matcher m = p.matcher(version);
        if (m.matches()) {
            return m.group(1);
        }
        return null;
    }

    private boolean findUpgradeRoute(Stack upgradeRoute, String sourceVersion, String targetVersion, HashMap sourceVersionTable) throws IOException {
        String searchVersion = sourceVersion;
        ArrayList list = new ArrayList();
        while (searchVersion != null) {
            List tmpList = (List)sourceVersionTable.get(searchVersion);
            if (tmpList != null) {
                list.addAll(tmpList);
            }
            searchVersion = UpgradeJarFinder.stripLastVersionNumber(searchVersion);
        }
        if (list.isEmpty()) {
            return false;
        }
        ListIterator i = list.listIterator();
        while (i.hasNext()) {
            UpgradeFileData upgradeFile = (UpgradeFileData)i.next();
            int compare = VersionComparator.INSTANCE.compareVersion(targetVersion, upgradeFile.getTargetVerString());
            if (compare < 0 || !this.acceptsVersion(upgradeFile, sourceVersion)) continue;
            upgradeRoute.push(upgradeFile);
            if (compare == 0) {
                return true;
            }
            if (!this.findUpgradeRoute(upgradeRoute, upgradeFile.getTargetVerString(), targetVersion, sourceVersionTable)) {
                upgradeRoute.pop();
                continue;
            }
            return true;
        }
        return false;
    }

    private HashMap getSourceVersionTable() {
        if (this.mSourceVersionTable == null) {
            this.mSourceVersionTable = this.initSourceVersionTable();
        }
        return this.mSourceVersionTable;
    }

    private HashMap initSourceVersionTable() {
        HashMap<String, LinkedList<UpgradeFileData>> sourceVerTable = new HashMap<String, LinkedList<UpgradeFileData>>();
        File[] files = this.listFiles(this.mUpgradeJarDir, new FileFilter(){

            public boolean accept(File pathname) {
                return UpgradeJarFinder.this.isFile(pathname) && pathname.getName().startsWith(UpgradeJarFinder.UPGRADE_FILE_PREFIX) && pathname.getName().endsWith(".jar");
            }
        });
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                UpgradeFileData fileData = this.parseUpgradeFileData(files[i]);
                if (fileData == null) continue;
                LinkedList<UpgradeFileData> targetList = (LinkedList<UpgradeFileData>)sourceVerTable.get(fileData.getSourceVersion());
                if (targetList == null) {
                    targetList = new LinkedList<UpgradeFileData>();
                    sourceVerTable.put(fileData.getSourceVersion(), targetList);
                }
                targetList.add(fileData);
            }
            Iterator i = sourceVerTable.values().iterator();
            while (i.hasNext()) {
                LinkedList linkedList = (LinkedList)i.next();
                Collections.sort(linkedList, InverseVersionComparator.INSTANCE);
            }
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Initialized version table:" + sourceVerTable, this);
        }
        return sourceVerTable;
    }

    private UpgradeFileData parseUpgradeFileData(File upgradeJar) {
        int endIndex;
        String fName = upgradeJar.getName();
        if (!fName.startsWith(UPGRADE_FILE_PREFIX)) {
            return null;
        }
        int beginIndex = fName.indexOf(95);
        if (beginIndex < 0) {
            return null;
        }
        if ((endIndex = fName.indexOf(95, ++beginIndex)) < 0) {
            return null;
        }
        String sVer = fName.substring(beginIndex, endIndex);
        if (sVer.trim().length() < 1 || !UpgradeJarFinder.isVersion(sVer)) {
            return null;
        }
        beginIndex = endIndex + 1;
        String tVer = fName.substring(beginIndex, endIndex = fName.indexOf(".jar", beginIndex));
        if (tVer.trim().length() < 1 || !UpgradeJarFinder.isVersion(tVer)) {
            return null;
        }
        return new UpgradeFileData(sVer, tVer, upgradeJar);
    }

    private static boolean isVersion(String name) {
        for (int i = 0; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isDigit(c) || c == '.') continue;
            return false;
        }
        return true;
    }

    protected boolean exists(File file) {
        return file.exists();
    }

    protected File[] listFiles(File dir, FileFilter filter) {
        return dir.listFiles(filter);
    }

    protected boolean acceptsVersion(UpgradeFileData upgradeFile, String sourceVersion) throws IOException {
        return upgradeFile.acceptsSourceVersion(sourceVersion);
    }

    protected boolean isFile(File pathname) {
        return pathname.isFile();
    }

    static class InverseVersionComparator
    implements Comparator {
        public static InverseVersionComparator INSTANCE = new InverseVersionComparator();

        InverseVersionComparator() {
        }

        public int compare(Object o1, Object o2) {
            return VersionComparator.INVERSE_INSTANCE.compareVersion(((UpgradeFileData)o1).getTargetVerString(), ((UpgradeFileData)o2).getTargetVerString());
        }
    }
}

