/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.ft.CompatibilityHandler;
import com.raplix.rolloutexpress.net.ft.DataId;
import com.raplix.rolloutexpress.net.ft.FileHandlerException;
import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.ft.FileTransferHandler;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportInfo;
import com.raplix.rolloutexpress.node.NodeUtils;
import com.raplix.rolloutexpress.node.upgrade.FileAssociationRequest;
import com.raplix.rolloutexpress.node.upgrade.ServerBootID;
import com.raplix.rolloutexpress.node.upgrade.UpgradeServiceException;
import com.raplix.util.file.RecursiveChmod;
import com.raplix.util.logger.Logger;
import com.raplix.util.platform.common.PlatformUtil;
import com.raplix.util.platform.posix.Stat;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;

class UpgradeFileTransferHandler
extends FileTransferHandler
implements CompatibilityHandler {
    private Hashtable mIDMap = new Hashtable();
    private File mWorkDir;
    private HashSet mTempFiles = new HashSet();
    private long mLastPurgeRequestID = 0L;
    private ServerBootID mLastInitStamp;
    public static final String TMP_FILE_PREFIX = "tmp/";

    void sendFile(RoxAddress destination, DataId dataId) throws UpgradeServiceException {
        File mappedPath = null;
        try {
            mappedPath = this.getMappedFile(dataId);
            this.sendData(destination, new FileInputStream(mappedPath), dataId);
        }
        catch (FileNotFoundException e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_READING_FILE", mappedPath.toString()));
        }
        catch (FileTransferException e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_SEND_FILE", UpgradeFileTransferHandler.dataIdToString(dataId), destination.toString()), (Throwable)e);
        }
    }

    void getFile(RoxAddress source, DataId dataId) throws UpgradeServiceException {
        File mappedPath = null;
        try {
            mappedPath = this.getMappedFile(dataId);
            this.getData(source, new FileOutputStream(mappedPath), dataId);
        }
        catch (FileNotFoundException e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_WRITING_FILE", mappedPath.toString()));
        }
        catch (FileTransferException e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_GET_FILE", UpgradeFileTransferHandler.dataIdToString(dataId), source.toString()), (Throwable)e);
        }
    }

    void sendFile(RoxAddress destination, InputStream data, DataId dataId) throws FileTransferException {
        this.sendData(destination, data, dataId);
    }

    void getFile(RoxAddress source, OutputStream sink, DataId dataId) throws FileTransferException {
        this.getData(source, sink, dataId);
    }

    protected OutputStream storeData(RoxAddress from, TransportInfo fromInfo, DataId dataIdentifier) throws FileHandlerException {
        File mappedPath = null;
        try {
            mappedPath = this.getMappedPath(dataIdentifier);
            return new FileOutputStream(mappedPath);
        }
        catch (FileNotFoundException e) {
            throw new FileHandlerException(new ROXMessage("node.upgrade.ERR_WRITING_FILE", mappedPath.toString()));
        }
    }

    protected InputStream fetchData(RoxAddress requestor, DataId dataIdentifier, TransportInfo requestorInfo) throws FileHandlerException {
        File mappedPath = null;
        try {
            mappedPath = this.getMappedPath(dataIdentifier);
            return new FileInputStream(mappedPath);
        }
        catch (FileNotFoundException e) {
            throw new FileHandlerException(new ROXMessage("node.upgrade.ERR_READING_FILE", mappedPath.toString()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getMappedPath(DataId dataId) throws FileHandlerException {
        File file;
        Hashtable hashtable = this.mIDMap;
        synchronized (hashtable) {
            file = (File)this.mIDMap.get(dataId);
        }
        if (file == null) {
            throw new FileHandlerException(new ROXMessage("node.upgrade.INVALID_DATA_ID", UpgradeFileTransferHandler.dataIdToString(dataId)));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getMappedFile(DataId id) throws UpgradeServiceException {
        File file;
        Hashtable hashtable = this.mIDMap;
        synchronized (hashtable) {
            file = (File)this.mIDMap.get(id);
        }
        if (file == null) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.INVALID_DATA_ID", UpgradeFileTransferHandler.dataIdToString(id)));
        }
        return file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void purgeInactiveIds(FileAssociationRequest request) {
        Hashtable hashtable = this.mIDMap;
        synchronized (hashtable) {
            if (request.getRequestID() <= this.mLastPurgeRequestID && request.getInitStamp().equals(this.mLastInitStamp)) {
                return;
            }
            if (request.getActiveIdSet() == null || request.getActiveIdSet().length == 0) {
                this.mIDMap.clear();
                return;
            }
            HashSet<DataId> set = new HashSet<DataId>(Arrays.asList(request.getActiveIdSet()));
            HashSet localSet = new HashSet(this.mIDMap.keySet());
            localSet.removeAll(set);
            Iterator iter = localSet.iterator();
            while (iter.hasNext()) {
                this.expire((DataId)iter.next());
            }
            this.mLastPurgeRequestID = request.getRequestID();
            this.mLastInitStamp = request.getInitStamp();
        }
    }

    public byte getHandlerId() {
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void associate(FileAssociationRequest request, File path) {
        this.purgeInactiveIds(request);
        Hashtable hashtable = this.mIDMap;
        synchronized (hashtable) {
            if (this.mIDMap.containsKey(request.getDataId())) {
                this.expire(request.getDataId());
            }
            this.mIDMap.put(request.getDataId(), path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void expire(DataId dataId) {
        boolean deleteFile;
        File file = null;
        Hashtable hashtable = this.mIDMap;
        synchronized (hashtable) {
            file = (File)this.mIDMap.remove(dataId);
            deleteFile = file != null && this.mTempFiles.remove(file);
        }
        if (deleteFile) {
            file.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createTempFile(FileAssociationRequest request) throws UpgradeServiceException {
        File tempFile = null;
        try {
            tempFile = File.createTempFile(UpgradeFileTransferHandler.dataIdToString(request.getDataId()) + "__", "", this.getWorkDir());
        }
        catch (IOException e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_CREATE_TEMP_FILE"));
        }
        tempFile.deleteOnExit();
        Hashtable hashtable = this.mIDMap;
        synchronized (hashtable) {
            this.associate(request, tempFile);
            this.mTempFiles.add(tempFile);
        }
    }

    private static String dataIdToString(DataId id) {
        return new BigInteger(id.getByteArray()).toString(36);
    }

    private File getWorkDir() {
        return this.mWorkDir;
    }

    private File getUpgradeJarTempFileDir() {
        return NodeUtils.getUpgradeJarTmpDir(this.getWorkDir());
    }

    /*
     * Loose catch block
     */
    public void copyFile(DataId id, File path) throws UpgradeServiceException {
        block14: {
            IOException ignored22;
            FileOutputStream fos;
            FileInputStream fis;
            block13: {
                File sourceFile = this.getMappedFile(id);
                fis = null;
                fos = null;
                fos = new FileOutputStream(path);
                fis = new FileInputStream(sourceFile);
                this.copyFile(fis, fos);
                fos.close();
                fos = null;
                Object var8_6 = null;
                if (fos == null) break block13;
                try {
                    fos.close();
                }
                catch (IOException ignored22) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignored22) {}
            }
            break block14;
            {
                catch (IOException e) {
                    throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_COPY_FILE", path.getAbsolutePath()), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOException ignored22;
                Object var8_7 = null;
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ignored22) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ignored22) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private void copyFile(InputStream fis, OutputStream fos) throws IOException {
        int len;
        byte[] buffer = new byte[4096];
        while ((len = fis.read(buffer)) >= 0) {
            fos.write(buffer, 0, len);
        }
    }

    /*
     * Loose catch block
     */
    public void extractJar(DataId id, File path, String applicationHome) throws UpgradeServiceException {
        block22: {
            FileOutputStream output;
            ZipFile jarFile;
            block21: {
                block20: {
                    JarEntry jarEntry;
                    File sourceFile = this.getMappedFile(id);
                    jarFile = null;
                    output = null;
                    boolean isJVMUpgrade = false;
                    File upgradeJarTempFileDir = this.getUpgradeJarTempFileDir();
                    NodeUtils.deleteAllFiles(upgradeJarTempFileDir);
                    upgradeJarTempFileDir.mkdirs();
                    if (!upgradeJarTempFileDir.isDirectory()) {
                        throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERROR_CREATE_JAR_DIRS", upgradeJarTempFileDir.getAbsolutePath()));
                    }
                    File jvmInstallDir = NodeUtils.getJVMUpgradeBaseDir(new File(applicationHome));
                    NodeUtils.deleteAllFiles(path);
                    jarFile = new JarFile(sourceFile);
                    Enumeration<JarEntry> entries = ((JarFile)jarFile).entries();
                    InputStream input = null;
                    File destination = null;
                    File parent = null;
                    while (entries.hasMoreElements() && (jarEntry = entries.nextElement()) != null) {
                        String entryName = jarEntry.getName();
                        if (entryName.startsWith("META-INF")) continue;
                        if (entryName.startsWith(TMP_FILE_PREFIX)) {
                            destination = this.translateJarEntryIntoDir(entryName, TMP_FILE_PREFIX, upgradeJarTempFileDir);
                        } else if (entryName.startsWith("jre/")) {
                            String platformSubdir = "jre/" + NodeUtils.getNativeSubDir() + '/';
                            if (!entryName.startsWith(platformSubdir)) continue;
                            destination = this.translateJarEntryIntoDir(entryName, platformSubdir, jvmInstallDir);
                            isJVMUpgrade = true;
                        } else {
                            destination = new File(path, entryName);
                        }
                        parent = jarEntry.isDirectory() ? destination : destination.getParentFile();
                        if (!parent.exists() && !parent.mkdirs()) {
                            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERROR_CREATE_JAR_DIRS", parent.getAbsolutePath()));
                        }
                        if (jarEntry.isDirectory()) continue;
                        output = new FileOutputStream(destination);
                        input = ((JarFile)jarFile).getInputStream(jarEntry);
                        this.copyFile(input, output);
                        output.close();
                        input.close();
                        if (!Logger.isDebugEnabled(this)) continue;
                        Logger.debug("Extracted file out to:" + destination.getAbsolutePath(), this);
                    }
                    if (!isJVMUpgrade || !PlatformUtil.isPOSIX()) break block20;
                    long mode = Stat.RWXU | Stat.RGRP | Stat.XGRP | Stat.ROTH | Stat.XOTH;
                    RecursiveChmod.change(jvmInstallDir.getAbsolutePath(), mode, true);
                }
                Object var18_19 = null;
                if (output == null) break block21;
                try {
                    output.close();
                }
                catch (IOException ignored) {
                    // empty catch block
                }
            }
            if (jarFile != null) {
                try {
                    jarFile.close();
                }
                catch (IOException ignore) {}
            }
            break block22;
            {
                catch (IOException e) {
                    throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_EXTRACT_JAR", path.getAbsolutePath()), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                Object var18_20 = null;
                if (output != null) {
                    try {
                        output.close();
                    }
                    catch (IOException ignored) {
                        // empty catch block
                    }
                }
                if (jarFile != null) {
                    try {
                        jarFile.close();
                    }
                    catch (IOException ignore) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    private File translateJarEntryIntoDir(String inEntryName, String inEntryPrefix, File inDirName) {
        File destination = inEntryName.length() > inEntryPrefix.length() ? new File(inDirName, inEntryName.substring(inEntryPrefix.length())) : inDirName;
        return destination;
    }

    UpgradeFileTransferHandler(File workDir) {
        this.mWorkDir = workDir;
    }
}

