/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.node.NodeUtils;
import com.raplix.rolloutexpress.node.upgrade.UpgradeServiceException;
import com.raplix.rolloutexpress.node.upgrade.UpgradeServices;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;

public final class UpgradeFileData {
    private String mSourceVersion;
    private String mTargetVerString;
    private File mFileName;
    private Attributes mAttributes;
    private static final String UPGRADE_APP_ATTRIB_NAME = "Upgrade-App";
    private static final String ALTERNATIVE_SOURCE_VERSIONS = "AlternativeSourceVersions";
    private static final String DESUPPORT = "Desupport";
    private static final String PATCHLEVEL = "PatchLevel";
    private static final String NAME_SEPARATOR = "-";
    private boolean mIsReadJarInfo = false;
    private HashSet mArchSubDirs = new HashSet();
    private Hashtable mJREPlatformDirs = new Hashtable();

    UpgradeFileData(String sourceVersion, String targetVerString, File fileName) {
        this.mSourceVersion = sourceVersion;
        this.mTargetVerString = targetVerString;
        this.mFileName = fileName;
    }

    String getSourceVersion() {
        return this.mSourceVersion;
    }

    String getTargetVerString() {
        return this.mTargetVerString;
    }

    File getFile() {
        return this.mFileName;
    }

    public int hashCode() {
        return this.mFileName.hashCode();
    }

    public boolean equals(Object obj) {
        if (obj != null && obj instanceof UpgradeFileData) {
            return this.mFileName.equals(((UpgradeFileData)obj).mFileName);
        }
        return false;
    }

    String getUpgradeAppMainClassName() throws IOException {
        this.loadJarInfo();
        return this.mAttributes.getValue(UPGRADE_APP_ATTRIB_NAME);
    }

    boolean acceptsSourceVersion(String version) throws IOException {
        if (this.mSourceVersion.equals(version)) {
            return true;
        }
        this.loadJarInfo();
        String srcVersionsList = this.mAttributes.getValue(ALTERNATIVE_SOURCE_VERSIONS);
        if (srcVersionsList == null) {
            return false;
        }
        String[] srcVersions = srcVersionsList.split(",");
        for (int x = 0; x < srcVersions.length; ++x) {
            if (!srcVersions[x].trim().equals(version)) continue;
            return true;
        }
        return false;
    }

    String isPlatformJREUpgradeIncluded(String platformName) throws IOException {
        this.loadJarInfo();
        String nativeSubDirName = NodeUtils.getNativeSubDir(platformName);
        if (nativeSubDirName != null) {
            return (String)this.mJREPlatformDirs.get(nativeSubDirName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void loadJarInfo() throws IOException {
        if (!this.mIsReadJarInfo) {
            JarFile jarFile = new JarFile(this.getFile());
            try {
                Manifest manifest = jarFile.getManifest();
                if (manifest != null) {
                    this.mAttributes = manifest.getMainAttributes();
                }
                Enumeration<JarEntry> entries = jarFile.entries();
                while (entries.hasMoreElements()) {
                    String dirName;
                    int idx;
                    JarEntry jarEntry = entries.nextElement();
                    String entryName = jarEntry.getName();
                    if (entryName.startsWith("jre/")) {
                        idx = (entryName = entryName.substring("jre/".length())).indexOf(47);
                        if (idx <= 0) continue;
                        String platformDirName = entryName.substring(0, idx);
                        ++idx;
                        if ((idx = (entryName = entryName.substring(idx)).indexOf(47)) <= 0) continue;
                        String platformJREName = entryName.substring(0, idx);
                        this.mJREPlatformDirs.put(platformDirName, platformJREName);
                        continue;
                    }
                    idx = entryName.indexOf(47);
                    if (idx <= 0 || !NodeUtils.isArchSubDir(dirName = entryName.substring(0, idx))) continue;
                    this.mArchSubDirs.add(dirName);
                }
                this.mIsReadJarInfo = true;
            }
            finally {
                jarFile.close();
            }
        }
    }

    String[] getRequiredPatches(UpgradeServices service) throws IOException, RPCException, UpgradeServiceException {
        this.loadJarInfo();
        if (service == null) {
            throw new NullPointerException("upgrade services must be non-null");
        }
        String nodeName = service.getPlatformName();
        nodeName = nodeName.replace(' ', '_');
        Attributes.Name[] names = this.mAttributes.keySet().toArray(new Attributes.Name[0]);
        ArrayList<String> availableOSVersions = new ArrayList<String>();
        String attrPrefix = "PatchLevel-" + nodeName + NAME_SEPARATOR;
        for (int i = 0; i < names.length; ++i) {
            String name = names[i].toString();
            if (!name.startsWith(attrPrefix)) continue;
            String osVersion = name.substring(attrPrefix.length(), name.length());
            osVersion = osVersion.replace('_', '.').trim();
            availableOSVersions.add(osVersion);
        }
        String[] osVersions = availableOSVersions.toArray(new String[availableOSVersions.size()]);
        for (int i = 0; i < osVersions.length; ++i) {
            if (!UpgradeTaskUtil.isOSVersion(new String[]{osVersions[i]}, service)) continue;
            String attrName = attrPrefix + osVersions[i].replace('.', '_');
            String patchList = this.mAttributes.getValue(attrName);
            if (patchList == null || patchList.trim().length() == 0) {
                return new String[0];
            }
            String[] patches = patchList.split(",");
            for (int j = 0; j < patches.length; ++j) {
                patches[j] = patches[j].trim();
            }
            return patches;
        }
        return new String[0];
    }

    String[] getDesupportedPlatformVersions(UpgradeServices service) throws IOException, RPCException, UpgradeServiceException {
        this.loadJarInfo();
        if (service == null) {
            throw new NullPointerException("upgrade services must be non-null");
        }
        String nodeName = service.getPlatformName();
        nodeName = nodeName.replace(' ', '_');
        String attrName = "Desupport-" + nodeName;
        String versionList = this.mAttributes.getValue(attrName);
        if (versionList == null || versionList.trim().length() == 0) {
            return new String[0];
        }
        String[] versions = versionList.split(",");
        for (int i = 0; i < versions.length; ++i) {
            versions[i] = versions[i].trim();
        }
        return versions;
    }

    public boolean hasNativeArchSubDir(String dir) {
        return this.mArchSubDirs.contains(dir);
    }

    public String toString() {
        return "UpgradeFileData:file:" + this.mFileName + ":sourceVer:" + this.mSourceVersion + ":targetVer:" + this.mTargetVerString;
    }
}

