/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.Agent;
import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.Distributor;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.ft.DataId;
import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.node.NodeAdminSubsystem;
import com.raplix.rolloutexpress.node.NodeUtils;
import com.raplix.rolloutexpress.node.upgrade.AbsoluteFilePath;
import com.raplix.rolloutexpress.node.upgrade.CommandLine;
import com.raplix.rolloutexpress.node.upgrade.FileAssociationRequest;
import com.raplix.rolloutexpress.node.upgrade.ServerBootID;
import com.raplix.rolloutexpress.node.upgrade.UpgradeEnvironmentDependencies;
import com.raplix.rolloutexpress.node.upgrade.UpgradeFileData;
import com.raplix.rolloutexpress.node.upgrade.UpgradeFileTransferHandler;
import com.raplix.rolloutexpress.node.upgrade.UpgradeNode;
import com.raplix.rolloutexpress.node.upgrade.UpgradeServiceException;
import com.raplix.rolloutexpress.node.upgrade.UpgradeServices;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTask;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskID;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskStatus;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskSummary;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiAppInstanceQuery;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Vector;

public class UpgradeExecutionManager {
    private long mDataId1 = 0L;
    private long mDataId2 = 0L;
    private HashSet mActiveIDSet = new HashSet();
    private File mUpgradeJarDir = null;
    private final ServerBootID mBootID = ServerBootID.generateServerBootID();
    private NodeAdminSubsystem mSubsystem;
    private UpgradeFileTransferHandler mTransferHandler;
    private UpgradeTaskID mUpgradeEntireNetwork;
    private HashMap mUpgradeTasks = new HashMap();
    private LinkedList mUpgradeTaskHistory = new LinkedList();
    private HashSet mLockedNodes = new HashSet();
    private final int mMaxUpgradeTaskHistory;
    final int mNodeRestartSeconds;
    private static final String[] COMMON_JRE_SUB_PATH = new String[]{"..", "common", "jre", "bin", "java"};
    private static final String[] APP_JRE_SUB_PATH_UNIX = new String[]{"jvm", "jre", "bin", "java"};
    private static final String[] APP_JRE_SUB_PATH_WIN = new String[]{"jvm", "jre", "bin", "java.cmd"};
    private static final String[] APP_JRE_TMP_SUB_PATH = new String[]{"bin", "java"};

    public UpgradeExecutionManager(NodeAdminSubsystem subsystem, File upgradeWorkDir) throws FileTransferException, ConfigurationException {
        this.mSubsystem = subsystem;
        this.mTransferHandler = new UpgradeFileTransferHandler(upgradeWorkDir);
        subsystem.getApplication().getNetSubsystem().getFTManager().registerHandler(this.mTransferHandler);
        this.mMaxUpgradeTaskHistory = subsystem.getConfigMaxUpgradeTaskHistory();
        this.mNodeRestartSeconds = subsystem.getConfigNodeRestartSeconds();
        this.mUpgradeJarDir = upgradeWorkDir.getParentFile();
    }

    public final boolean needsUpgrade(AppInstanceID appID) throws UpgradeServiceException {
        try {
            String version = this.getService(appID).getApplicationVersion();
            return UpgradeExecutionManager.needsUpgrade(this.mSubsystem.getApplication(), version);
        }
        catch (RPCException e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_CHECK_UPGRADE", appID.toString()), (Throwable)e);
        }
        catch (PersistenceManagerException e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_CHECK_UPGRADE", appID.toString()), (Throwable)e);
        }
    }

    public final synchronized UpgradeTaskID upgradeNode(AppInstanceID appID) throws UpgradeServiceException {
        this.checkIfUpgradingEntireNetwork();
        UpgradeNode childNode = null;
        UpgradeNode node = null;
        UpgradeTask task = null;
        try {
            while (appID != null) {
                AppInstance app = appID.getByIDQuery().select();
                node = new UpgradeNode(app);
                if (childNode != null) {
                    childNode.setParent(node);
                }
                childNode = node;
                appID = app.getParentID();
            }
            task = this.createUpgradeTask(node);
            this.mSubsystem.startSubsystemTask(task);
        }
        catch (Exception e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_UPGRADING_NODES"), (Throwable)e);
        }
        return task.getTaskID();
    }

    public final synchronized UpgradeTaskID upgradeMultipleNodes(AppInstanceID[] appIDs) throws UpgradeServiceException {
        this.checkIfUpgradingEntireNetwork();
        UpgradeNode root = null;
        UpgradeTask task = null;
        try {
            root = this.fetchEntireNetwork();
            HashSet<AppInstanceID> appIDSet = new HashSet<AppInstanceID>(Arrays.asList(appIDs));
            this.filterNodes(root, appIDSet);
            task = this.createUpgradeTask(root);
            this.mSubsystem.startSubsystemTask(task);
        }
        catch (Exception e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_UPGRADING_ENTIRE_NETWORK"), (Throwable)e);
        }
        return task.getTaskID();
    }

    private void filterNodes(UpgradeNode node, HashSet appIDSet) {
        UpgradeNode[] children = node.getChildren();
        for (int i = 0; i < children.length; ++i) {
            this.filterNodes(children[i], appIDSet);
        }
        if (!node.hasChildren() && !appIDSet.contains(node.getAppInstance().getID())) {
            node.setParent(null);
        }
    }

    public final synchronized UpgradeTaskID upgradeEntireNetwork() throws UpgradeServiceException {
        this.checkIfUpgradingEntireNetwork();
        UpgradeNode root = null;
        UpgradeTask task = null;
        try {
            root = this.fetchEntireNetwork();
            task = this.createUpgradeTask(root);
            this.mUpgradeEntireNetwork = task.getTaskID();
            this.mSubsystem.startSubsystemTask(task);
        }
        catch (Exception e) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_UPGRADING_ENTIRE_NETWORK"), (Throwable)e);
        }
        return task.getTaskID();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeTaskStatus getUpgradeTaskStatus(UpgradeTaskID taskID) throws UpgradeServiceException {
        UpgradeTask task;
        HashMap hashMap = this.mUpgradeTasks;
        synchronized (hashMap) {
            task = (UpgradeTask)this.mUpgradeTasks.get(taskID);
            if (task == null) {
                Iterator iter = this.mUpgradeTaskHistory.iterator();
                while (iter.hasNext()) {
                    UpgradeTaskStatus taskStatus = (UpgradeTaskStatus)iter.next();
                    if (!taskID.equals(taskStatus.getTaskID())) continue;
                    return taskStatus;
                }
            }
        }
        if (task == null) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_UNKNOWN_TASK_FOR_STATUS", taskID.toString()));
        }
        return task.computeTaskStatus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UpgradeTaskSummary[] getAllUpgradeTaskSummary() throws UpgradeServiceException {
        Vector<UpgradeTaskSummary> vTaskSummary = new Vector<UpgradeTaskSummary>();
        Object[] allTaskSummary = null;
        UpgradeTask[] currentTask = new UpgradeTask[this.mUpgradeTasks.size()];
        UpgradeTaskStatus[] historyTaskStatus = new UpgradeTaskStatus[this.mUpgradeTaskHistory.size()];
        int count = 0;
        HashMap hashMap = this.mUpgradeTasks;
        synchronized (hashMap) {
            Iterator iterCurrent = this.mUpgradeTasks.values().iterator();
            while (iterCurrent.hasNext()) {
                currentTask[count++] = (UpgradeTask)iterCurrent.next();
            }
            count = 0;
            if (null != this.mUpgradeTaskHistory) {
                Iterator iterHistory = this.mUpgradeTaskHistory.iterator();
                while (iterHistory.hasNext()) {
                    historyTaskStatus[count++] = (UpgradeTaskStatus)iterHistory.next();
                }
            }
        }
        UpgradeTaskStatus currentTaskStatus = null;
        UpgradeTaskSummary currentTaskSummary = null;
        for (int i = 0; i < this.mUpgradeTasks.size(); ++i) {
            currentTaskStatus = currentTask[i].computeTaskStatus();
            currentTaskSummary = currentTaskStatus.computeUpgradeTaskSummary();
            vTaskSummary.addElement(currentTaskSummary);
        }
        UpgradeTaskSummary historyTaskSummary = null;
        for (int i = 0; i < this.mUpgradeTaskHistory.size(); ++i) {
            historyTaskSummary = historyTaskStatus[i].computeUpgradeTaskSummary();
            vTaskSummary.addElement(historyTaskSummary);
        }
        allTaskSummary = new UpgradeTaskSummary[vTaskSummary.size()];
        vTaskSummary.copyInto(allTaskSummary);
        return allTaskSummary;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void abortTask(UpgradeTaskID taskID) throws UpgradeServiceException {
        UpgradeTask task;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Aborting task:" + taskID, this);
        }
        HashMap hashMap = this.mUpgradeTasks;
        synchronized (hashMap) {
            task = (UpgradeTask)this.mUpgradeTasks.get(taskID);
        }
        if (task == null) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_UNKNOWN_TASK_FOR_ABORT", taskID.toString()));
        }
        if (!this.mSubsystem.stopSubsystemTask(taskID.toString())) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_UNKNOWN_TASK_FOR_ABORT", taskID.toString()));
        }
        task.setTaskAborted();
    }

    UpgradeNode fetchEntireNetwork() throws UpgradeServiceException, PersistenceManagerException, RPCException {
        AppInstance[] all = MultiAppInstanceQuery.all().select();
        AppInstance o = null;
        UpgradeNode root = null;
        UpgradeNode node = null;
        UpgradeNode child = null;
        Hashtable<AppInstanceID, Object> parents = new Hashtable<AppInstanceID, Object>();
        for (int i = 0; i < all.length; ++i) {
            Object obj;
            o = all[i];
            node = new UpgradeNode(o);
            if (AppType.MS.equals(o.getType())) {
                root = node;
            }
            if (AppType.MS.equals(o.getType()) || AppType.LD.equals(o.getType())) {
                obj = parents.get(o.getID());
                if (obj == null) {
                    parents.put(o.getID(), node);
                } else {
                    Enumeration e = ((Vector)obj).elements();
                    while (e.hasMoreElements()) {
                        child = (UpgradeNode)e.nextElement();
                        child.setParent(node);
                    }
                    parents.put(o.getID(), node);
                }
            }
            if (!AppType.RA.equals(o.getType()) && !AppType.LD.equals(o.getType())) continue;
            obj = parents.get(o.getParentID());
            if (obj == null) {
                Vector<UpgradeNode> vec = new Vector<UpgradeNode>();
                vec.add(node);
                parents.put(o.getParentID(), vec);
                continue;
            }
            if (obj instanceof Vector) {
                ((Vector)obj).add(node);
                continue;
            }
            node.setParent((UpgradeNode)obj);
        }
        if (root == null) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.NO_MASTER_SERVER_FOUND"));
        }
        Enumeration iter = parents.keys();
        AppInstanceID appID = null;
        while (iter.hasMoreElements()) {
            appID = (AppInstanceID)iter.nextElement();
            Object children = parents.get(appID);
            if (!(children instanceof Vector)) continue;
            node = (UpgradeNode)((Vector)children).get(0);
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.PARENT_MISSING", node.getAppInstance().getType().getApplicationName(), node.getHostName()));
        }
        return root;
    }

    File getUpgradeJarDir() {
        return this.mUpgradeJarDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private UpgradeTask createUpgradeTask(UpgradeNode root) throws Exception {
        UpgradeTaskID taskID = UpgradeTaskID.generateID();
        UpgradeTask task = this.instantiateUpgradeTask(root, taskID);
        HashMap hashMap = this.mUpgradeTasks;
        synchronized (hashMap) {
            this.mUpgradeTasks.put(task.getTaskID(), task);
        }
        return task;
    }

    protected UpgradeTask instantiateUpgradeTask(UpgradeNode root, UpgradeTaskID taskID) {
        return new UpgradeTask(this, root, taskID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void taskCompleted(UpgradeTask task) {
        HashMap hashMap = this.mUpgradeTasks;
        synchronized (hashMap) {
            this.mUpgradeTasks.remove(task.getTaskID());
            if (task.getTaskID().equals(this.mUpgradeEntireNetwork)) {
                this.mUpgradeEntireNetwork = null;
            }
            this.mUpgradeTaskHistory.addLast(task.computeTaskStatus());
            if (this.mUpgradeTaskHistory.size() > this.mMaxUpgradeTaskHistory) {
                this.mUpgradeTaskHistory.removeFirst();
            }
        }
        this.mSubsystem.subsystemTaskComplete(task.getName());
    }

    private UpgradeServices getService(AppInstanceID appInstance) throws RPCException, PersistenceManagerException {
        AppInstance app = appInstance.getByIDQuery().select();
        return this.getService(app);
    }

    private void checkIfUpgradingEntireNetwork() throws UpgradeServiceException {
        if (this.mUpgradeEntireNetwork != null) {
            throw new UpgradeServiceException(new ROXMessage("node.upgrade.UPGRADING_ENTIRE_NETWORK", this.mUpgradeEntireNetwork.toString()));
        }
    }

    UpgradeServices getService(AppInstance app) throws RPCException {
        return (UpgradeServices)this.mSubsystem.getApplication().getNetSubsystem().getRPC().getService(app.getRoxAddress(), UpgradeServices.class);
    }

    /*
     * Loose catch block
     */
    public final void downloadLogFile(AppInstanceID appID, OutputStream destination) throws UpgradeServiceException {
        block30: {
            IOException ignored2222;
            String appName;
            FileInputStream fis;
            FileOutputStream fos;
            File tempFile;
            FileAssociationRequest request;
            block28: {
                int len;
                RoxAddress addr = null;
                request = null;
                tempFile = null;
                fos = null;
                fis = null;
                appName = "";
                AppInstance app = appID.getByIDQuery().select();
                if (AppType.RA.equals(app.getType())) {
                    appName = Application.getSubclassName(Agent.class);
                }
                if (AppType.LD.equals(app.getType())) {
                    appName = Application.getSubclassName(Distributor.class);
                }
                if (AppType.MS.equals(app.getType())) {
                    appName = Application.getSubclassName(Server.class);
                }
                if (AppType.MS.equals(app.getType())) {
                    fis = new FileInputStream(this.getSubsystem().getConfigLogFileLocation());
                } else {
                    addr = app.getRoxAddress();
                    request = this.generateDataId();
                    UpgradeServices service = this.getService(appID);
                    service.prepareLogFileForDownload(request);
                    tempFile = File.createTempFile("download", ".log");
                    tempFile.deleteOnExit();
                    fos = new FileOutputStream(tempFile);
                    this.mTransferHandler.getFile(addr, fos, request.getDataId());
                    fos = null;
                    fis = new FileInputStream(tempFile);
                }
                byte[] buffer = new byte[1024];
                while ((len = fis.read(buffer)) >= 0) {
                    destination.write(buffer, 0, len);
                }
                destination.close();
                destination = null;
                Object var13_13 = null;
                if (request != null) {
                    this.expireId(request.getDataId());
                }
                if (fos == null) break block28;
                try {
                    fos.close();
                }
                catch (IOException ignored2222) {
                    // empty catch block
                }
            }
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException ignored2222) {
                    // empty catch block
                }
            }
            if (tempFile != null) {
                tempFile.delete();
            }
            if (destination != null) {
                try {
                    destination.close();
                }
                catch (IOException ignored2222) {}
            }
            break block30;
            {
                catch (Exception e) {
                    throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_DOWNLOAD_LOG_FILE", appName), (Throwable)e);
                }
            }
            catch (Throwable throwable) {
                IOException ignored2222;
                Object var13_14 = null;
                if (request != null) {
                    this.expireId(request.getDataId());
                }
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException ignored2222) {
                        // empty catch block
                    }
                }
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException ignored2222) {
                        // empty catch block
                    }
                }
                if (tempFile != null) {
                    tempFile.delete();
                }
                if (destination != null) {
                    try {
                        destination.close();
                    }
                    catch (IOException ignored2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
    }

    UpgradeFileTransferHandler getTransferHandler() {
        return this.mTransferHandler;
    }

    final HashMap assignDataIds(UpgradeNode root) {
        HashMap<UpgradeFileData, FileAssociationRequest> requests = new HashMap<UpgradeFileData, FileAssociationRequest>();
        UpgradeFileData[] deployFiles = root.getDeployFiles();
        for (int i = 0; i < deployFiles.length; ++i) {
            FileAssociationRequest request = this.generateDataId();
            requests.put(deployFiles[i], request);
        }
        return requests;
    }

    final void expireAssignedDataIds(HashMap requests) {
        if (requests != null) {
            Iterator iterator = requests.values().iterator();
            while (iterator.hasNext()) {
                this.expireId(((FileAssociationRequest)iterator.next()).getDataId());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileAssociationRequest generateDataId() {
        HashSet hashSet = this.mActiveIDSet;
        synchronized (hashSet) {
            if (this.mDataId1 == Long.MAX_VALUE) {
                if (this.mDataId2 == Long.MAX_VALUE) {
                    this.mDataId1 = 0L;
                    this.mDataId2 = 1L;
                } else {
                    ++this.mDataId2;
                }
            } else if (this.mDataId2 == Long.MAX_VALUE) {
                ++this.mDataId1;
                this.mDataId2 = 1L;
            } else {
                ++this.mDataId2;
            }
            DataId id = new DataId(this.mDataId1, this.mDataId2);
            this.mActiveIDSet.add(id);
            return new FileAssociationRequest(id, this.getActiveIdSet(), this.mDataId2, this.mBootID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void expireId(DataId id) {
        HashSet hashSet = this.mActiveIDSet;
        synchronized (hashSet) {
            this.mActiveIDSet.remove(id);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataId[] getActiveIdSet() {
        HashSet hashSet = this.mActiveIDSet;
        synchronized (hashSet) {
            return this.mActiveIDSet.toArray(new DataId[this.mActiveIDSet.size()]);
        }
    }

    NodeAdminSubsystem getSubsystem() {
        return this.mSubsystem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void lockForUpgrade(HashSet upgradableNodes) throws UpgradeServiceException {
        HashSet<AppInstanceID> lockIDSet = new HashSet<AppInstanceID>();
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Locking for upgrades:" + upgradableNodes + ":locked set:" + this.mLockedNodes, this);
        }
        HashSet hashSet = this.mLockedNodes;
        synchronized (hashSet) {
            Iterator iterator = upgradableNodes.iterator();
            while (iterator.hasNext()) {
                UpgradeNode node = (UpgradeNode)iterator.next();
                AppInstanceID id = node.getAppInstance().getID();
                if (this.mLockedNodes.contains(id)) {
                    throw new UpgradeServiceException(new ROXMessage("node.upgrade.ERR_LOCK_NODE", node.getAppInstance().getType().getApplicationName(), node.getHostName()));
                }
                lockIDSet.add(id);
            }
            this.mLockedNodes.addAll(lockIDSet);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final void unlockNodes(HashSet upgradableNodes) {
        if (upgradableNodes != null && !upgradableNodes.isEmpty()) {
            HashSet hashSet = this.mLockedNodes;
            synchronized (hashSet) {
                Iterator iterator = upgradableNodes.iterator();
                while (iterator.hasNext()) {
                    this.mLockedNodes.remove(((UpgradeNode)iterator.next()).getAppInstance().getID());
                }
            }
        }
    }

    static boolean needsUpgrade(Application inMSApplication, String inVersionNumber) {
        return !inMSApplication.getRoxVersionNumber().equals(inVersionNumber);
    }

    protected void addNodeUpgradeAppJVMArgs(CommandLine.Builder inCmdBuilder) {
    }

    protected void addJVMPath(CommandLine.Builder inCmdBuilder, AbsoluteFilePath inJvmPath, String inTargetVersion) {
        inCmdBuilder.addPath(inJvmPath);
    }

    void computeAndAddJVMPath(CommandLine.Builder inCmdBuilder, AbsoluteFilePath inHomeDir, UpgradeFileData currentData, UpgradeNode node) throws CloneNotSupportedException, IOException {
        this.addJVMPath(inCmdBuilder, UpgradeExecutionManager.computeJVMPath(inHomeDir, currentData, node), currentData.getTargetVerString());
    }

    private static AbsoluteFilePath computeJVMPath(AbsoluteFilePath inHomeDir, UpgradeFileData currentData, UpgradeNode node) throws IOException {
        AbsoluteFilePath jvmPath = inHomeDir;
        String jvmSubDir = currentData.isPlatformJREUpgradeIncluded(node.getPlatform());
        if (jvmSubDir != null) {
            jvmPath.extend("jvm");
            jvmPath.extend(jvmSubDir);
            jvmPath.extend(APP_JRE_TMP_SUB_PATH);
        } else if (UpgradeEnvironmentDependencies.isJVMPathUpgraded(currentData.getSourceVersion())) {
            if (NodeUtils.getPlatform(node.getPlatform()).isUnix()) {
                jvmPath.extend(APP_JRE_SUB_PATH_UNIX);
            } else {
                jvmPath.extend(APP_JRE_SUB_PATH_WIN);
            }
        } else {
            jvmPath.extend(COMMON_JRE_SUB_PATH);
        }
        return jvmPath;
    }
}

