/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.node.bootstrap.VersionComparator;

class UpgradeEnvironmentDependencies {
    static final String UPGRADE_API_UPGRADE_VERSION = "4.0.3";
    static final String JVM_PATH_UPGRADE_VERSION = "4.1";
    static final String GET_NODE_INFO_AVAILABLE = "5.0";

    static String checkIfWeNeedToUpgradeAPI(String inSourceVersion, String inTargetVersion) {
        if (VersionComparator.INSTANCE.compareVersion(inSourceVersion, UPGRADE_API_UPGRADE_VERSION) < 0 && VersionComparator.INSTANCE.compareVersion(inTargetVersion, UPGRADE_API_UPGRADE_VERSION) > 0) {
            return UPGRADE_API_UPGRADE_VERSION;
        }
        return inTargetVersion;
    }

    static boolean isUpgradeAPIUpgrade(String versionString) {
        return VersionComparator.INSTANCE.compareVersion(versionString, UPGRADE_API_UPGRADE_VERSION) == 0;
    }

    static boolean willUseOldUpgradeAPI(String targetVersion) {
        return VersionComparator.INSTANCE.compareVersion(targetVersion, UPGRADE_API_UPGRADE_VERSION) <= 0;
    }

    static boolean isJVMPathUpgraded(String sourceVersion) {
        return VersionComparator.INSTANCE.compareVersion(sourceVersion, JVM_PATH_UPGRADE_VERSION) >= 0;
    }

    static boolean isGetNodeInfoMethodAvailable(String sourceVersion) {
        return VersionComparator.INSTANCE.compareVersion(sourceVersion, GET_NODE_INFO_AVAILABLE) >= 0;
    }

    private UpgradeEnvironmentDependencies() {
    }
}

