/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.command.commandresult.FileSpec;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.util.platform.common.Platform;
import com.raplix.util.string.Replace;

public class NodeInfo
implements RPCSerializable {
    private String mOSName;
    private String mOSVersion;
    private String mOSArch;
    private String mRAHomeDir;
    private String mRADataDir;
    private String mRATmpDir;
    private String mRAConfigDir;
    private String mRABuildNumber;
    private String mRAVersionNumber;
    private String mRAFileSeparator;
    private String mRAPathSeparator;
    private transient Platform mRAPlatform;

    public NodeInfo(Platform platform, String fileSeparator, String pathSeparator, Application raApp) {
        this.setOSName(platform.getOSName());
        this.setOSVersion(platform.getOSVersion());
        this.setOSArch(platform.getOSArch());
        this.setRAFileSeparator(fileSeparator);
        this.setRAPathSeparator(pathSeparator);
        this.setRAHomeDir(raApp.getHomeDirAbsPath());
        this.setRADataDir(raApp.getDataDirAbsPath());
        this.setRAConfigDir(raApp.getConfigDirAbsPath());
        this.setRATmpDir(raApp.getTmpDirAbsPath());
        this.setRABuildNumber(raApp.getRoxBuildNumber());
        this.setRAVersionNumber(raApp.getRoxVersionNumber());
    }

    protected NodeInfo() {
    }

    public String getOSName() {
        return this.mOSName;
    }

    protected void setOSName(String OSName) {
        this.mOSName = OSName;
    }

    public String getOSVersion() {
        return this.mOSVersion;
    }

    protected void setOSVersion(String OSVersion) {
        this.mOSVersion = OSVersion;
    }

    public String getOSArch() {
        return this.mOSArch;
    }

    protected void setOSArch(String OSArch) {
        this.mOSArch = OSArch;
    }

    public String getRAHomeDir() {
        return this.mRAHomeDir;
    }

    protected void setRAHomeDir(String RAHomeDir) {
        this.mRAHomeDir = RAHomeDir;
    }

    public String getRADataDir() {
        return this.mRADataDir;
    }

    protected void setRADataDir(String RADataDir) {
        this.mRADataDir = RADataDir;
    }

    public String getRATmpDir() {
        return this.mRATmpDir;
    }

    protected void setRATmpDir(String RATmpDir) {
        this.mRATmpDir = RATmpDir;
    }

    public String getRAConfigDir() {
        return this.mRAConfigDir;
    }

    protected void setRAConfigDir(String RAConfigDir) {
        this.mRAConfigDir = RAConfigDir;
    }

    public String getRABuildNumber() {
        return this.mRABuildNumber;
    }

    protected void setRABuildNumber(String RABuildNumber) {
        this.mRABuildNumber = RABuildNumber;
    }

    public String getRAVersionNumber() {
        return this.mRAVersionNumber;
    }

    protected void setRAVersionNumber(String RAVersionNumber) {
        this.mRAVersionNumber = RAVersionNumber;
    }

    public String getRAFileSeparator() {
        return this.mRAFileSeparator;
    }

    protected void setRAFileSeparator(String RAFileSeparator) {
        this.mRAFileSeparator = RAFileSeparator;
    }

    public String getRAPathSeparator() {
        return this.mRAPathSeparator;
    }

    protected void setRAPathSeparator(String RAPathSeparator) {
        this.mRAPathSeparator = RAPathSeparator;
    }

    public String toRAPath(String universalPath) {
        String raSep = this.getRAFileSeparator();
        if (raSep.equals(FileSpec.UNIVERSAL_FILE_SEPARATOR)) {
            return universalPath;
        }
        return Replace.replace(universalPath, '/', raSep);
    }

    public Platform getRAPlatform() {
        if (this.mRAPlatform == null) {
            this.mRAPlatform = new Platform(this.getOSName(), this.getOSVersion(), this.getOSArch());
        }
        return this.mRAPlatform;
    }

    public boolean equals(Object inObj) {
        if (inObj == null) {
            return false;
        }
        if (inObj == this) {
            return true;
        }
        if (!(inObj instanceof NodeInfo)) {
            return false;
        }
        NodeInfo info = (NodeInfo)inObj;
        return this.getOSName().equals(info.getOSName()) && this.getOSVersion().equals(info.getOSVersion()) && this.getOSArch().equals(info.getOSArch()) && this.getRAFileSeparator().equals(info.getRAFileSeparator()) && this.getRAPathSeparator().equals(info.getRAPathSeparator()) && this.getRAHomeDir().equals(info.getRAHomeDir()) && this.getRATmpDir().equals(info.getRATmpDir()) && this.getRADataDir().equals(info.getRADataDir()) && this.getRAConfigDir().equals(info.getRAConfigDir()) && this.getRAVersionNumber().equals(info.getRAVersionNumber()) && this.getRABuildNumber().equals(info.getRABuildNumber());
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getOSName()).append("-").append(this.getOSVersion()).append("-").append(this.getOSArch());
        return buf.toString();
    }
}

