/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.node.bootstrap.BootStrap;
import com.raplix.util.platform.common.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.LinkedList;
import java.util.Vector;

public class DelayedAppRestartTool {
    public static void invoke(long waitTime, String restartScriptPath) throws IOException {
        Vector commandLine = DelayedAppRestartTool.buildCommandLine(waitTime, restartScriptPath);
        String[] args = commandLine.toArray(new String[commandLine.size()]);
        Process p = Runtime.getRuntime().exec(args);
        p.getOutputStream().close();
        new StreamPump(p.getInputStream(), System.out).start();
        new StreamPump(p.getErrorStream(), System.err).start();
    }

    private static Vector buildCommandLine(long timeout, String restartScriptPath) {
        Vector<String> commandLine = new Vector<String>();
        String classpath = System.getProperty("java.class.path");
        String roxHomeDir = System.getProperty("rox_home_dir");
        String userHome = System.getProperty("user.home");
        String policyFile = System.getProperty("java.security.policy");
        String javaHome = System.getProperty("java.home");
        commandLine.add(new File(new File(javaHome, "bin"), "java").getAbsolutePath());
        commandLine.add("-Djava.security.manager");
        commandLine.add("-Djava.security.policy=" + policyFile);
        commandLine.add("-Duser.home=" + userHome);
        commandLine.add("-Drox_home_dir=" + roxHomeDir);
        commandLine.add("-cp");
        commandLine.add(classpath);
        commandLine.add(BootStrap.class.getName());
        commandLine.add(DelayedAppRestartTool.class.getName());
        commandLine.add(String.valueOf(timeout));
        commandLine.add(restartScriptPath);
        return commandLine;
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: restart <waitSeconds> <restart_script_path");
            System.exit(1);
        }
        File logFile = DelayedAppRestartTool.resetStreams();
        String sleepTime = args[0];
        String restartScript = args[1];
        DelayedAppRestartTool.sleep(sleepTime);
        LinkedList<String> commandLine = new LinkedList<String>();
        commandLine.add(restartScript);
        if (!Platform.LOCAL.isWin32()) {
            commandLine.add("restart");
            commandLine.add("noprompt");
        }
        if (0 == DelayedAppRestartTool.startProc(commandLine.toArray(new String[commandLine.size()]))) {
            logFile.deleteOnExit();
        }
    }

    private static void sleep(String sleepTime) {
        try {
            Thread.sleep(Integer.parseInt(sleepTime) * 1000);
        }
        catch (Exception e) {
            System.out.println("Error waiting for " + sleepTime + " seconds, restarting right away");
        }
    }

    private static File resetStreams() {
        PrintStream ps = null;
        File logFile = null;
        try {
            logFile = File.createTempFile("CR_restart", ".log");
            ps = new PrintStream(new FileOutputStream(logFile));
        }
        catch (IOException e) {
            System.err.println("Error opening a new log file:" + e);
            System.exit(1);
        }
        try {
            System.in.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        System.out.close();
        System.err.close();
        System.setOut(ps);
        System.setErr(ps);
        return logFile;
    }

    private static int startProc(String[] args) {
        int status = -1;
        try {
            Process p = Runtime.getRuntime().exec(args);
            p.getOutputStream().close();
            new StreamPump(p.getInputStream(), System.out).start();
            new StreamPump(p.getErrorStream(), System.err).start();
            status = p.waitFor();
            System.out.println("Restart completed with status: " + status);
        }
        catch (Exception e) {
            System.err.println("Error starting the process " + e);
            System.exit(1);
        }
        return status;
    }

    private static class StreamPump
    extends Thread {
        private InputStream mInput;
        private OutputStream mOutput;

        StreamPump(InputStream is, OutputStream os) {
            super("StreamPump");
            this.mInput = is;
            this.mOutput = os;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Loose catch block
         */
        public void run() {
            block15: {
                int cnt;
                byte[] buffer = new byte[1024];
                while ((cnt = this.mInput.read(buffer)) >= 0) {
                    this.mOutput.write(buffer, 0, cnt);
                }
                Object var5_3 = null;
                try {
                    this.mInput.close();
                }
                catch (IOException ioe) {
                    // empty catch block
                }
                try {
                    this.mOutput.close();
                }
                catch (IOException ioe) {}
                break block15;
                {
                    catch (Exception e) {
                        e.printStackTrace();
                        Object var5_4 = null;
                        try {
                            this.mInput.close();
                        }
                        catch (IOException ioe) {
                            // empty catch block
                        }
                        try {
                            this.mOutput.close();
                        }
                        catch (IOException ioe) {}
                    }
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        this.mInput.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    try {
                        this.mOutput.close();
                    }
                    catch (IOException ioe) {
                        // empty catch block
                    }
                    throw throwable;
                }
            }
        }
    }
}

