/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.upgrade;

import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.node.upgrade.AbsoluteFilePath;
import com.raplix.util.Util;
import java.util.LinkedList;

public class CommandLine
implements RPCSerializable {
    private ElementPart[][] mCmdLine;

    public String[] getCommandLine() {
        StringBuffer currentElement = new StringBuffer();
        String[] cmdLine = new String[this.mCmdLine.length];
        for (int i = 0; i < this.mCmdLine.length; ++i) {
            ElementPart[] elementParts = this.mCmdLine[i];
            for (int j = 0; j < elementParts.length; ++j) {
                ElementPart elementPart = elementParts[j];
                currentElement.append(elementPart.getValue());
            }
            cmdLine[i] = currentElement.toString();
            currentElement.setLength(0);
        }
        return cmdLine;
    }

    public String toString() {
        return Util.getStringFromArray(this.getCommandLine(), " ");
    }

    public static Builder getBuilder() {
        return new Builder();
    }

    CommandLine(ElementPart[][] inCmdLine) {
        this.mCmdLine = inCmdLine;
    }

    private CommandLine() {
    }

    private static class StringElementPart
    implements ElementPart {
        private String mValue;

        public String getValue() {
            return this.mValue;
        }

        StringElementPart(String inValue) {
            this.mValue = inValue;
        }

        public StringElementPart() {
        }
    }

    private static class PathElementPart
    implements ElementPart {
        private AbsoluteFilePath mValue;

        public String getValue() {
            return this.mValue.toFile().getPath();
        }

        PathElementPart(AbsoluteFilePath inValue) {
            this.mValue = inValue;
        }

        private PathElementPart() {
        }
    }

    private static interface ElementPart
    extends RPCSerializable {
        public String getValue();
    }

    public static class Builder {
        private LinkedList mCmdLine = new LinkedList();
        private transient LinkedList mElements = new LinkedList();

        public void addString(String inString) {
            this.addElementPart(new StringElementPart(inString));
        }

        public void addPath(AbsoluteFilePath inPath) {
            this.addElementPart(new PathElementPart(inPath));
        }

        public void nextElement() {
            if (this.mElements.isEmpty()) {
                throw new IllegalStateException("Cannot have an empty command line element");
            }
            this.mCmdLine.add(this.mElements.toArray(new ElementPart[this.mElements.size()]));
            this.mElements.clear();
        }

        public CommandLine getCommandLine() {
            if (!this.mElements.isEmpty()) {
                this.nextElement();
            }
            return new CommandLine((ElementPart[][])this.mCmdLine.toArray((T[])new ElementPart[this.mCmdLine.size()][]));
        }

        private void addElementPart(ElementPart element) {
            this.mElements.add(element);
        }
    }
}

