/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.bootstrap;

import java.io.File;
import java.util.Comparator;
import java.util.StringTokenizer;

public class VersionComparator
implements Comparator {
    public static final VersionComparator INSTANCE = new VersionComparator(false);
    public static final VersionComparator INVERSE_INSTANCE = new VersionComparator(true);
    private boolean mInverse;

    protected VersionComparator(boolean isInverse) {
        this.mInverse = isInverse;
    }

    public int compare(Object o1, Object o2) {
        return this.compareVersion(((File)o1).getName(), ((File)o2).getName());
    }

    public int compareVersion(String v1, String v2) {
        int value = VersionComparator.compareVersionArrays(VersionComparator.parseVersion(v1), VersionComparator.parseVersion(v2));
        if (this.mInverse) {
            value = 0 - value;
        }
        return value;
    }

    private static int compareVersionArrays(int[] a1, int[] a2) {
        for (int i = 0; i < a1.length; ++i) {
            if (i < a2.length) {
                if (a1[i] == a2[i]) continue;
                return a1[i] - a2[i];
            }
            return 1;
        }
        return a1.length - a2.length;
    }

    private static int[] parseVersion(String version) {
        StringTokenizer strTok = new StringTokenizer(version, ".");
        int[] returnVal = new int[strTok.countTokens()];
        int i = 0;
        while (strTok.hasMoreTokens()) {
            try {
                returnVal[i] = Integer.parseInt(strTok.nextToken());
            }
            catch (NumberFormatException e) {
                returnVal[i] = 0;
            }
            ++i;
        }
        return returnVal;
    }
}

