/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.bootstrap;

import [Ljava.lang.String;;
import com.raplix.rolloutexpress.node.bootstrap.VersionComparator;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class BootStrap {
    private boolean mVerbose;
    private String mMainClass;
    private String[] mAppArgs;
    private static final String ARG_VERBOSE = "-verbose";
    private static final String ARG_EXTRA_JARS = "-extrajars";
    private String mHomeDir;
    private static final String PROPERTY_HOME_DIR = "rox_home_dir";
    public static final String UPGRADE_DIR_NAME = "upgrade";
    private static final String JAR_SUFFIX = ".jar";
    private static BootStrap sInstance;
    private File mCommonUpgradeDir;
    private static final String PLATFORM_UTIL_INTEG_CLASS = "com.raplix.rolloutexpress.node.PlatformUtilBootStrapIntegrator";
    public static final String LIBDIR_OVERRIDE = "cr.bs.liboverride";
    private URLClassLoader mClassLoader;
    private File mAppUpgradeDir;
    private String mExtraJars;
    private boolean mUseParentClassLoader = false;

    public static void main(String[] args) {
        BootStrap boot = new BootStrap();
        boot.init(args);
        try {
            boot.run();
        }
        catch (Exception e) {
            e.printStackTrace();
            boot.logError("Error starting " + boot.mMainClass + " " + e);
        }
    }

    protected BootStrap() {
        sInstance = this;
    }

    public static BootStrap getInstance() {
        return sInstance;
    }

    protected void init(String[] args) {
        int argIndex;
        if (args.length == 0) {
            this.printUsage();
        }
        if (ARG_VERBOSE.equals(args[argIndex = 0])) {
            this.mVerbose = true;
            ++argIndex;
        }
        if (argIndex >= args.length) {
            this.printUsage();
        }
        if (ARG_EXTRA_JARS.equals(args[argIndex])) {
            if (++argIndex >= args.length) {
                this.printUsage();
            }
            this.mExtraJars = args[argIndex];
            ++argIndex;
        }
        if (argIndex >= args.length) {
            this.printUsage();
        }
        this.mMainClass = args[argIndex++];
        this.mAppArgs = new String[args.length - argIndex];
        System.arraycopy(args, argIndex, this.mAppArgs, 0, this.mAppArgs.length);
        this.mHomeDir = System.getProperty(PROPERTY_HOME_DIR);
        if (this.mHomeDir == null || this.mHomeDir.trim().length() == 0) {
            this.printUsage();
        }
    }

    public boolean isVerbose() {
        return this.mVerbose;
    }

    public String getMainClass() {
        return this.mMainClass;
    }

    public String[] getAppArgs() {
        return this.mAppArgs;
    }

    public String getHomeDir() {
        return this.mHomeDir;
    }

    public URLClassLoader getClassLoader() {
        return this.mClassLoader;
    }

    public String getUpgradeLibraryPath(String libraryPath, String subDirName) {
        this.log("looking for :" + libraryPath);
        String returnValue = this.searchForUpgradeLibrary(this.mAppUpgradeDir, libraryPath, subDirName);
        if (returnValue != null) {
            return returnValue;
        }
        returnValue = this.searchForUpgradeLibrary(this.mCommonUpgradeDir, libraryPath, subDirName);
        if (returnValue != null) {
            return returnValue;
        }
        return libraryPath;
    }

    private String searchForUpgradeLibrary(File searchDir, String libraryPath, String subDirName) {
        if (searchDir != null && searchDir.exists()) {
            File[] upgrades = searchDir.listFiles(UpgradeDirFilter.INSTANCE);
            if (upgrades == null) {
                this.log("Unable to list files in " + searchDir.getAbsolutePath());
            } else {
                Arrays.sort(upgrades, VersionComparator.INVERSE_INSTANCE);
            }
            upgrades = this.processUpgradeDirsForLibSearch(searchDir, upgrades);
            if (upgrades == null) {
                return null;
            }
            libraryPath = new File(libraryPath).getName();
            for (int i = 0; i < upgrades.length; ++i) {
                File upgradeLib = new File(new File(upgrades[i], subDirName), libraryPath);
                this.log("checking for :" + upgradeLib);
                if (!upgradeLib.exists() || !upgradeLib.isFile()) continue;
                return upgradeLib.getAbsolutePath();
            }
        }
        return null;
    }

    protected File[] processUpgradeDirsForLibSearch(File inSearchDir, File[] inUpgrades) {
        return inUpgrades;
    }

    protected void run() throws IOException, ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        File homeDir;
        if (this.mVerbose) {
            StringBuffer sb = new StringBuffer("Starting with Homedir='");
            sb.append(this.mHomeDir).append("' MainClass='");
            sb.append(this.mMainClass).append("' Args=");
            for (int i = 0; i < this.mAppArgs.length; ++i) {
                sb.append("'").append(this.mAppArgs[i]).append("' ");
            }
            this.log(sb.toString());
        }
        if (!(homeDir = new File(this.mHomeDir)).exists() || !homeDir.isDirectory()) {
            this.logError("'" + homeDir + "' is not a valid directory");
        }
        File libDir = null;
        String libOverride = System.getProperty(LIBDIR_OVERRIDE);
        if (libOverride == null || libOverride.trim().length() == 0) {
            libDir = new File(new File(new File(homeDir, ".."), "common"), "lib").getCanonicalFile();
        } else {
            libDir = new File(libOverride).getCanonicalFile();
            this.log("Library directory overridden to:" + libDir);
        }
        if (!libDir.exists() || !libDir.isDirectory()) {
            this.logError("'" + homeDir + "' is not a valid CenterRun installation directory");
        }
        File appLibDir = new File(homeDir, "lib");
        ClassLoader loader = this.getLoader(libDir, appLibDir);
        this.registerPlatformUtil(loader);
        Class<?> mainClass = loader.loadClass(this.mMainClass);
        Method mainMethod = mainClass.getDeclaredMethod("main", String;.class);
        if (!Modifier.isStatic(mainMethod.getModifiers()) || !mainMethod.getReturnType().equals(Void.TYPE)) {
            this.logError("public static void main(String[]) method not found in " + this.mMainClass);
        }
        this.log("Invoking the app...");
        mainMethod.invoke(null, new Object[]{this.mAppArgs});
    }

    private void registerPlatformUtil(ClassLoader loader) {
        try {
            Class<?> regClass = loader.loadClass(PLATFORM_UTIL_INTEG_CLASS);
            Method registerMethod = regClass.getDeclaredMethod("register", new Class[0]);
            if (!Modifier.isStatic(registerMethod.getModifiers()) || !registerMethod.getReturnType().equals(Void.TYPE)) {
                this.logError("'public static void register()' not found in com.raplix.rolloutexpress.node.PlatformUtilBootStrapIntegrator. PlatformUtil registration class is out of synch");
            }
            registerMethod.invoke(null, new Object[0]);
        }
        catch (Exception e) {
            this.logError("PlatformUtil registration class com.raplix.rolloutexpress.node.PlatformUtilBootStrapIntegrator is out of synch " + e);
        }
    }

    private ClassLoader getLoader(File libDir, File appLibDir) throws MalformedURLException {
        File[] jarPaths = this.getJarPaths(libDir, appLibDir);
        Arrays.sort(jarPaths, NameComparator.INSTANCE);
        this.log("jars being used...");
        URL[] urls = new URL[jarPaths.length];
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < urls.length; ++i) {
            if (this.mVerbose) {
                this.log(jarPaths[i].getAbsolutePath());
            }
            urls[i] = jarPaths[i].toURL();
            if (i != 0) {
                sb.append(File.pathSeparator);
            }
            sb.append(jarPaths[i].getAbsolutePath());
        }
        this.mClassLoader = this.mUseParentClassLoader ? new URLClassLoader(urls, this.getClass().getClassLoader()) : new URLClassLoader(urls);
        System.setProperty("java.class.path", sb.toString());
        this.log("Set java.class.path to " + sb);
        return this.mClassLoader;
    }

    private File[] getJarPaths(File libDir, File appLibDir) {
        Hashtable jarTable = new Hashtable();
        BootStrap.putJarsInHash(libDir, jarTable);
        File commonUpgradeDir = new File(libDir, UPGRADE_DIR_NAME);
        if (commonUpgradeDir.exists()) {
            this.mCommonUpgradeDir = commonUpgradeDir;
            this.findUpgradeJars(commonUpgradeDir, jarTable);
        } else {
            this.log("Common upgrade dir does not exist:" + commonUpgradeDir.getAbsolutePath());
        }
        if (appLibDir.exists() && appLibDir.isDirectory()) {
            BootStrap.putJarsInHash(appLibDir, jarTable);
            File appUpgradeDir = new File(appLibDir, UPGRADE_DIR_NAME);
            if (appUpgradeDir.exists()) {
                this.mAppUpgradeDir = appUpgradeDir;
                this.findUpgradeJars(appUpgradeDir, jarTable);
            } else {
                this.log("App Upgrade dir does not exist:" + appUpgradeDir.getAbsolutePath());
            }
        }
        this.addExtraJars(jarTable);
        return jarTable.values().toArray(new File[jarTable.size()]);
    }

    private void addExtraJars(Hashtable table) {
        if (this.mExtraJars != null && this.mExtraJars.trim().length() > 0) {
            StringTokenizer strTok = new StringTokenizer(this.mExtraJars, File.pathSeparator);
            while (strTok.hasMoreTokens()) {
                File file = new File(strTok.nextToken());
                if (!file.exists()) continue;
                table.put(file.getName(), file.getAbsoluteFile());
            }
        }
    }

    private void findUpgradeJars(File commonUpgradeDir, Hashtable jarTable) {
        File[] upgrades = commonUpgradeDir.listFiles(UpgradeDirFilter.INSTANCE);
        if (upgrades == null) {
            this.logError("Error listing files in the upgrade dir:" + commonUpgradeDir.getAbsolutePath());
        }
        Arrays.sort(upgrades, VersionComparator.INSTANCE);
        upgrades = this.processUpgradeDirsForJarSearch(commonUpgradeDir, upgrades);
        for (int i = 0; i < upgrades.length; ++i) {
            BootStrap.putJarsInHash(upgrades[i], jarTable);
        }
    }

    protected File[] processUpgradeDirsForJarSearch(File inUpgradeDir, File[] inUpgrades) {
        return inUpgrades;
    }

    private static void putJarsInHash(File libDir, Hashtable jarTable) {
        File[] jars = libDir.listFiles(JarFilter.INSTANCE);
        if (jars != null) {
            for (int i = 0; i < jars.length; ++i) {
                jarTable.put(jars[i].getName(), jars[i].getAbsoluteFile());
            }
        }
    }

    protected void printUsage() {
        System.err.println("Usage: java -Drox_home_dir=<CR_App_Home_Dir> BootStrap [-verbose] [-extrajars <extrajars>] CR_APP_CLASS_NAME arg0 arg1 ...");
        System.err.println("\tWhere:");
        System.err.println("\t\tCR_App_Home_Dir:\tThe CR appication's home directory.");
        System.err.println("\t\t-verbose:\t\tPrints diagnostic messages.");
        System.err.println("\t\t-extrajars:\t\tAdd extra jars to the classpath. The jars are specified as a classpath would be specified on the platform.");
        System.err.println("\t\tCR_APP_CLASS_NAME:\tThe CR application's main class name.");
        System.err.println("");
        this.exit(1);
    }

    protected void logError(String string) {
        System.err.println(string);
        this.exit(1);
    }

    private void log(String string) {
        if (this.mVerbose) {
            System.err.println(string);
        }
    }

    protected void exit(int status) {
        System.exit(status);
    }

    private static class JarFilter
    implements FileFilter {
        public static final JarFilter INSTANCE = new JarFilter();

        private JarFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isFile() && pathname.getName().endsWith(BootStrap.JAR_SUFFIX);
        }
    }

    private static class UpgradeDirFilter
    implements FileFilter {
        public static final UpgradeDirFilter INSTANCE = new UpgradeDirFilter();

        private UpgradeDirFilter() {
        }

        public boolean accept(File pathname) {
            return pathname.isDirectory() && this.isVersion(pathname.getName());
        }

        private boolean isVersion(String name) {
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (Character.isDigit(c) || c == '.') continue;
                return false;
            }
            return true;
        }
    }

    public static class NameComparator
    implements Comparator {
        public static final NameComparator INSTANCE = new NameComparator();

        public int compare(Object o1, Object o2) {
            return this.compareNames(((File)o1).getName(), ((File)o2).getName());
        }

        public int compareNames(String s1, String s2) {
            return s1.compareTo(s2);
        }
    }
}

