/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node.admin;

import com.raplix.rolloutexpress.Agent;
import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.Distributor;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.node.Messages;
import com.raplix.rolloutexpress.node.NodeSubsystem;
import com.raplix.rolloutexpress.node.NodeUtils;
import com.raplix.rolloutexpress.node.admin.LogFileSnapshot;
import com.raplix.rolloutexpress.node.admin.NodeAdminServices;
import com.raplix.rolloutexpress.node.admin.NodeServiceException;
import com.raplix.rolloutexpress.node.admin.NodeStatus;
import com.raplix.rolloutexpress.resource.ResourceSubsystem;
import com.raplix.rolloutexpress.resource.exception.ResourceException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

public class NodeAdminServiceImpl
implements NodeAdminServices,
Messages {
    private NodeSubsystem mNodeSubsystem;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NodeStatus getNodeStatus() throws RPCException, NodeServiceException {
        try {
            NodeStatus status = new NodeStatus();
            Application app = this.mNodeSubsystem.getApplication();
            ResourceSubsystem res = app.getResourceSubsystem();
            if (app instanceof Agent) {
                status.setAppType(AppType.RA);
                status.setResSnapshotCurrentSize(res.getTotalSnapshotBytes());
            }
            if (app instanceof Distributor) {
                status.setAppType(AppType.LD);
            }
            status.setAppVersion(app.getRoxVersionNumber());
            status.setBuild(app.getRoxBuildNumber());
            status.setUserRunningAs(app.getSystemUser());
            status.setResCacheMaxSize(res.getNonMSMaxCacheSize());
            status.setResCacheCurrentSize(res.getNonMSTotalRepoSize());
            String configFileName = this.mNodeSubsystem.getApplication().getDefaultConfigurationFileName();
            Properties prop = new Properties();
            FileInputStream inStream = new FileInputStream(configFileName);
            try {
                prop.load(inStream);
            }
            finally {
                try {
                    inStream.close();
                }
                catch (IOException ignore) {}
            }
            status.setConfigProperties(new Hashtable<Object, Object>(prop));
            return status;
        }
        catch (UnsupportedSubsystemException e) {
            throw new NodeServiceException(new ROXMessage("node.admin.ERROR_FETCH_NODE_STATUS", this.mNodeSubsystem.getApplication().getApplicationName()), (Throwable)e);
        }
        catch (IOException e) {
            throw new NodeServiceException(new ROXMessage("node.admin.ERROR_FETCH_NODE_STATUS", this.mNodeSubsystem.getApplication().getApplicationName()), (Throwable)e);
        }
    }

    public LogFileSnapshot getLogFileSnapshot(int inLastNBytes) throws RPCException, NodeServiceException {
        try {
            File logFileLocation = new File(this.mNodeSubsystem.getConfigLogFileLocation());
            return NodeUtils.getLogFileSnapshot(inLastNBytes, logFileLocation);
        }
        catch (ConfigurationException e) {
            throw new NodeServiceException(new ROXMessage("node.admin.ERROR_FETCH_LOG_SNAPSHOT", this.mNodeSubsystem.getApplication().getApplicationName()), (Throwable)e);
        }
    }

    public void clearResourceCache() throws RPCException, NodeServiceException {
        try {
            ResourceSubsystem res = this.mNodeSubsystem.getApplication().getResourceSubsystem();
            res.flushUnlockedResources();
        }
        catch (UnsupportedSubsystemException e) {
            throw new NodeServiceException(new ROXMessage("node.admin.ERROR_CLEAR_RES_CACHE", this.mNodeSubsystem.getApplication().getApplicationName()), (Throwable)e);
        }
        catch (ResourceException e) {
            throw new NodeServiceException(new ROXMessage("node.admin.ERROR_CLEAR_RES_CACHE", this.mNodeSubsystem.getApplication().getApplicationName()), (Throwable)e);
        }
    }

    public NodeAdminServiceImpl(NodeSubsystem ns) {
        this.mNodeSubsystem = ns;
    }

    public void registerRPC(RPCManager rpc) throws RPCException {
        rpc.registerService(NodeAdminServices.class, this);
    }
}

