/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.executor.task.ExecNativeStepDescriptor;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.node.admin.LogFileSnapshot;
import com.raplix.rolloutexpress.node.admin.NodeServiceException;
import com.raplix.util.platform.common.Platform;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.Properties;

public class NodeUtils {
    private static final String UPGRADE_JAR_TMP_DIR = "updTmp";
    public static final String UPGRADE_JAR_JRE_SUB_PATH = "jre/";
    public static final String NATIVE_SUBDIR_SOLARIS = "solaris";
    public static final String NATIVE_SUBDIR_SOLARIS_SPARC = "solarissparc";
    public static final String NATIVE_SUBDIR_SOLARIS_X86 = "solarisx86";
    public static final String NATIVE_SUBDIR_LINUX = "linux";
    public static final String NATIVE_SUBDIR_AIX = "aix";
    public static final String NATIVE_SUBDIR_HPUX = "hpux";
    public static final String NATIVE_SUBDIR_WIN = "win32";
    public static final String APP_JVM_SUB_PATH = "jvm";
    private static final HashSet archSubDirs = new HashSet();

    static File initializeUpgradeDir(Application app) throws ConfigurationException {
        File upgradeWorkDir = NodeUtils.getUpgradeWorkDir(app.getDataDirAbsPath());
        if (upgradeWorkDir.exists() ? !upgradeWorkDir.isDirectory() : !upgradeWorkDir.mkdirs()) {
            throw new ConfigurationException(new ROXMessage("node.upgrade.ERR_UPGRADE_DIR", upgradeWorkDir.getAbsolutePath()));
        }
        NodeUtils.deleteAllFiles(upgradeWorkDir);
        return upgradeWorkDir;
    }

    public static File getUpgradeWorkDir(String dataDirPath) {
        return new File(new File(dataDirPath, "upgrade"), "work");
    }

    public static File getUpgradeBackupBaseDir(String dataDirPath) {
        return new File(new File(dataDirPath, "upgrade"), "backup");
    }

    public static File getUpgradeJarTmpDir(File upgradeWorkDir) {
        return new File(upgradeWorkDir, UPGRADE_JAR_TMP_DIR);
    }

    public static File getJVMUpgradeBaseDir(File appHome) {
        return new File(appHome, APP_JVM_SUB_PATH);
    }

    public static void deleteAllFiles(File dir) {
        File[] files = dir.listFiles();
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                if (files[i].isDirectory()) {
                    NodeUtils.deleteAllFiles(files[i]);
                }
                files[i].delete();
            }
        }
    }

    public static InputStream propertiesToStream(Properties properties) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        properties.store(baos, "");
        baos.close();
        return new ByteArrayInputStream(baos.toByteArray());
    }

    public static Properties streamToProperties(InputStream is) throws IOException {
        Properties properties = new Properties();
        properties.load(is);
        return properties;
    }

    public static String getNativeSubDir(String platformName) {
        Platform platform = NodeUtils.getPlatform(platformName);
        if (platform.isSolaris()) {
            return NATIVE_SUBDIR_SOLARIS;
        }
        if (platform.isLinux()) {
            return NATIVE_SUBDIR_LINUX;
        }
        if (platform.isAix()) {
            return NATIVE_SUBDIR_AIX;
        }
        if (platform.isHpux()) {
            return NATIVE_SUBDIR_HPUX;
        }
        if (platform.isWin32()) {
            return NATIVE_SUBDIR_WIN;
        }
        return null;
    }

    public static String getNativeArchSubDir(Platform platform) {
        if (platform.isSolarisSparc()) {
            return NATIVE_SUBDIR_SOLARIS_SPARC;
        }
        if (platform.isSolarisX86()) {
            return NATIVE_SUBDIR_SOLARIS_X86;
        }
        if (platform.isLinux32()) {
            return NATIVE_SUBDIR_LINUX;
        }
        if (platform.isAix()) {
            return NATIVE_SUBDIR_AIX;
        }
        if (platform.isHpux()) {
            return NATIVE_SUBDIR_HPUX;
        }
        if (platform.isWin32()) {
            return NATIVE_SUBDIR_WIN;
        }
        return null;
    }

    public static Platform getPlatform(String platformName) {
        return new Platform(platformName, "", "");
    }

    public static String getLocalPlatformName() {
        return Platform.LOCAL.getName();
    }

    public static String getNativeSubDir() {
        return NodeUtils.getNativeSubDir(Platform.LOCAL.getName());
    }

    public static String getNativeArchSubDir() {
        return NodeUtils.getNativeArchSubDir(Platform.LOCAL);
    }

    public static LogFileSnapshot getLogFileSnapshot(int inLastNBytes, File inLogFile) throws NodeServiceException {
        LogFileSnapshot log = null;
        try {
            int size;
            long offset;
            long totalSize = inLogFile.length();
            if (totalSize > (long)inLastNBytes) {
                offset = totalSize - (long)inLastNBytes;
                size = inLastNBytes;
            } else {
                offset = 0L;
                size = (int)totalSize;
            }
            String content = ExecNativeStepDescriptor.grabBytesFromFile(inLogFile, offset, size);
            log = new LogFileSnapshot(content, totalSize, offset);
        }
        catch (IOException e) {
            throw new NodeServiceException(new ROXMessage("node.admin.ERROR_FETCH_LOG_SNAPSHOT"), (Throwable)e);
        }
        return log;
    }

    public static boolean isArchSubDir(String dir) {
        return archSubDirs.contains(dir);
    }

    private NodeUtils() {
    }

    static {
        archSubDirs.add(NATIVE_SUBDIR_SOLARIS_SPARC);
        archSubDirs.add(NATIVE_SUBDIR_SOLARIS_X86);
    }
}

