/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node;

import com.raplix.rolloutexpress.Agent;
import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.node.NodeUtils;
import com.raplix.rolloutexpress.node.admin.NodeAdminServiceImpl;
import com.raplix.rolloutexpress.node.upgrade.NodeUpgradeManager;
import com.raplix.util.platform.common.Platform;
import java.io.File;

public class NodeSubsystem
extends Subsystem {
    private File mUpgradeWorkDir;
    private NodeAdminServiceImpl mNodeAdminService;
    private NodeUpgradeManager mNodeUpgradeManager;
    public static final String CONFIG_PREFIX = "node.";
    public static final String CONFIG_LOG_FILE_LOCATION = "log_file_location";
    public static final String CONFIG_RESTART_SCRIPT_LOCATION = "restart_script_location";

    public NodeSubsystem(Application inApp) throws ConfigurationException {
        super(inApp);
        try {
            this.mUpgradeWorkDir = NodeUtils.initializeUpgradeDir(inApp);
            this.mNodeAdminService = new NodeAdminServiceImpl(this);
            this.mNodeUpgradeManager = new NodeUpgradeManager(this);
        }
        catch (FileTransferException e) {
            throw new ConfigurationException("node.ERR_INIT_SUBSYSTEM", (Throwable)e);
        }
    }

    private NodeSubsystem() {
    }

    public String getConfigLogFileLocation() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_LOG_FILE_LOCATION);
    }

    public String getConfigRestartScriptLocation() throws ConfigurationException {
        return this.getConfigurationAsString(CONFIG_RESTART_SCRIPT_LOCATION);
    }

    public File getUpgradeWorkDir() {
        return this.mUpgradeWorkDir;
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        String logFileLocation = "";
        String restartScriptLocation = "";
        Application application = this.getApplication();
        if (application != null) {
            File parent = new File(application.getHomeDirAbsPath(), "bin");
            if (application instanceof Agent) {
                logFileLocation = new File(parent, "cr_agent.out").getAbsolutePath();
                restartScriptLocation = new File(parent, "cr_agent").getAbsolutePath();
            } else {
                logFileLocation = new File(parent, "cr_ld.out").getAbsolutePath();
                restartScriptLocation = new File(parent, "cr_ld").getAbsolutePath();
            }
            if (Platform.LOCAL.isWin32()) {
                restartScriptLocation = new File(parent, "restart.cmd").getAbsolutePath();
            }
        }
        return new DefaultConfiguration[]{new DefaultConfiguration(CONFIG_LOG_FILE_LOCATION, logFileLocation, "node.DOC_CONFIG_LOG_FILE_LOCATION"), new DefaultConfiguration(CONFIG_RESTART_SCRIPT_LOCATION, restartScriptLocation, "node.upgrade.DOC_CONFIG_RESTART_SCRIPT_LOCATION")};
    }

    public void registerRPCInterfaces(RPCManager inRPCManager) throws RPCException {
        this.mNodeAdminService.registerRPC(inRPCManager);
        this.mNodeUpgradeManager.registerRPC(inRPCManager);
    }

    protected String getConfigurationPropertyPrefix() {
        return CONFIG_PREFIX;
    }
}

