/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.node;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.DefaultConfiguration;
import com.raplix.rolloutexpress.Server;
import com.raplix.rolloutexpress.Subsystem;
import com.raplix.rolloutexpress.message.ROXMessage;
import com.raplix.rolloutexpress.net.ft.FileTransferException;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.rpc.RPCManager;
import com.raplix.rolloutexpress.node.Messages;
import com.raplix.rolloutexpress.node.NodeManagementServices;
import com.raplix.rolloutexpress.node.NodeUtils;
import com.raplix.rolloutexpress.node.admin.LogFileSnapshot;
import com.raplix.rolloutexpress.node.admin.NodeAdminServices;
import com.raplix.rolloutexpress.node.admin.NodeServiceException;
import com.raplix.rolloutexpress.node.admin.NodeStatus;
import com.raplix.rolloutexpress.node.upgrade.UpgradeExecutionManager;
import com.raplix.rolloutexpress.node.upgrade.UpgradeServiceException;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskID;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskStatus;
import com.raplix.rolloutexpress.node.upgrade.UpgradeTaskSummary;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import java.io.File;
import java.io.OutputStream;

public class NodeAdminSubsystem
extends Subsystem
implements NodeManagementServices,
Messages {
    private UpgradeExecutionManager mUpgradeManager;
    private static final String CONFIG_MAX_LOG_FILE_BYTES = "max_log_file_bytes";
    private static final String CONFIG_MAX_UPGRADE_TASK_HISTORY = "max_upgrade_task_history";
    private static final String CONFIG_NODE_RESTART_SECONDS = "node_restart_seconds";
    private static final String CONFIG_NODE_UPGRADE_APP_TIMEOUT = "node_upgrade_app_timeout";
    public static final String CONFIG_PREFIX = "admin.";

    public NodeAdminSubsystem(Application inApp) throws ConfigurationException {
        super(inApp);
        try {
            File upgradeWorkDir = NodeUtils.initializeUpgradeDir(inApp);
            this.mUpgradeManager = this.createUpgradeManager(upgradeWorkDir);
        }
        catch (FileTransferException e) {
            throw new ConfigurationException(new ROXMessage("node.ERR_INIT_SUBSYSTEM"), (Throwable)e);
        }
    }

    protected UpgradeExecutionManager createUpgradeManager(File upgradeWorkDir) throws FileTransferException, ConfigurationException {
        return new UpgradeExecutionManager(this, upgradeWorkDir);
    }

    private NodeAdminSubsystem() {
    }

    public NodeStatus getNodeStatus(AppInstanceID appID) throws RPCException, NodeServiceException {
        try {
            return this.getServices(appID).getNodeStatus();
        }
        catch (PersistenceManagerException e) {
            throw new NodeServiceException(new ROXMessage("node.admin.ERROR_FETCH_NODE_STATUS"), (Throwable)e);
        }
    }

    public LogFileSnapshot getLogFileSnapshot(AppInstanceID appID) throws RPCException, NodeServiceException {
        try {
            AppInstance instance = appID.getByIDQuery().select();
            if (instance.getType().equals(AppType.MS)) {
                File logFileLocation = new File(this.getConfigLogFileLocation());
                return NodeUtils.getLogFileSnapshot(this.getConfigMaxLogFileBytes(), logFileLocation);
            }
            return this.getServices(appID).getLogFileSnapshot(this.getConfigMaxLogFileBytes());
        }
        catch (PersistenceManagerException e) {
            throw new NodeServiceException(new ROXMessage("node.admin.ERROR_FETCH_LOG_SNAPSHOT"), (Throwable)e);
        }
        catch (ConfigurationException e) {
            throw new NodeServiceException(new ROXMessage("node.admin.ERROR_FETCH_LOG_SNAPSHOT"), (Throwable)e);
        }
    }

    public void downloadLogFile(AppInstanceID appID, OutputStream destination) throws NodeServiceException {
        try {
            this.mUpgradeManager.downloadLogFile(appID, destination);
        }
        catch (UpgradeServiceException e) {
            throw new NodeServiceException(new ROXMessage("node.upgrade.ERR_DOWNLOAD_LOG_FILE"), (Throwable)e);
        }
    }

    public void clearResourceCache(AppInstanceID appID) throws RPCException, NodeServiceException {
        try {
            this.getServices(appID).clearResourceCache();
        }
        catch (PersistenceManagerException e) {
            throw new NodeServiceException(new ROXMessage("node.admin.ERROR_CLEAR_RES_CACHE"), (Throwable)e);
        }
    }

    public final boolean needsUpgrade(AppInstanceID appID) throws UpgradeServiceException {
        return this.mUpgradeManager.needsUpgrade(appID);
    }

    public UpgradeTaskID upgradeNode(AppInstanceID appID) throws UpgradeServiceException {
        return this.mUpgradeManager.upgradeNode(appID);
    }

    public final synchronized UpgradeTaskID upgradeMultipleNodes(AppInstanceID[] appIDs) throws UpgradeServiceException {
        return this.mUpgradeManager.upgradeMultipleNodes(appIDs);
    }

    public UpgradeTaskID upgradeEntireNetwork() throws UpgradeServiceException {
        return this.mUpgradeManager.upgradeEntireNetwork();
    }

    public UpgradeTaskStatus getUpgradeTaskStatus(UpgradeTaskID taskID) throws UpgradeServiceException {
        return this.mUpgradeManager.getUpgradeTaskStatus(taskID);
    }

    public UpgradeTaskSummary[] getAllUpgradeTaskSummary() throws UpgradeServiceException {
        return this.mUpgradeManager.getAllUpgradeTaskSummary();
    }

    public void abortUpgradeTask(UpgradeTaskID taskID) throws UpgradeServiceException {
        this.mUpgradeManager.abortTask(taskID);
    }

    private NodeAdminServices getServices(AppInstanceID appID) throws RPCException, PersistenceManagerException {
        AppInstance app = appID.getByIDQuery().select();
        return (NodeAdminServices)this.getApplication().getNetSubsystem().getRPC().getService(app.getRoxAddress(), NodeAdminServices.class);
    }

    public void registerRPCInterfaces(RPCManager inRPCManager) throws RPCException {
        super.registerRPCInterfaces(inRPCManager);
        inRPCManager.registerService(NodeManagementServices.class, this);
    }

    public int getConfigMaxUpgradeTaskHistory() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_MAX_UPGRADE_TASK_HISTORY);
    }

    public int getConfigMaxLogFileBytes() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_MAX_LOG_FILE_BYTES);
    }

    public int getConfigNodeRestartSeconds() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_NODE_RESTART_SECONDS);
    }

    protected DefaultConfiguration[] getDefaultConfiguration() {
        String logFileLocation = "";
        Application application = this.getApplication();
        if (application != null) {
            File parent = new File(application.getHomeDirAbsPath(), "bin");
            if (application instanceof Server) {
                logFileLocation = new File(parent, "cr_server.out").getAbsolutePath();
            }
        }
        return new DefaultConfiguration[]{new DefaultConfiguration("log_file_location", logFileLocation, "node.DOC_CONFIG_LOG_FILE_LOCATION"), new DefaultConfiguration(CONFIG_MAX_UPGRADE_TASK_HISTORY, 15, "node.DOC_CONFIG_MAX_UPGRADE_TASK_HISTORY"), new DefaultConfiguration(CONFIG_MAX_LOG_FILE_BYTES, 10240, "node.doc_config_max_log_file_bytes"), new DefaultConfiguration(CONFIG_NODE_RESTART_SECONDS, 10, "node.upgrade.DOC_CONFIG_NODE_RESTART_SECONDS"), new DefaultConfiguration(CONFIG_NODE_UPGRADE_APP_TIMEOUT, 1800, "node.doc_config_node_upgrade_app_timeout")};
    }

    protected String getConfigurationPropertyPrefix() {
        return CONFIG_PREFIX;
    }

    private UpgradeExecutionManager getUpgradeManager() {
        return this.mUpgradeManager;
    }

    public String getConfigLogFileLocation() throws ConfigurationException {
        return this.getConfigurationAsString("log_file_location");
    }

    public long getConfigNodeUpgradeAppTimeout() throws ConfigurationException {
        return this.getConfigurationAsInt(CONFIG_NODE_UPGRADE_APP_TIMEOUT) * 1000;
    }
}

