/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport.config;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.RPCSerializable;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.config.ConfigAddress;
import com.raplix.rolloutexpress.net.transport.config.IllegalTransportConfig;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ConnectionType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.SerializerFactory;
import org.w3c.dom.Comment;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class TransportConfig
implements RPCSerializable {
    public static final String ROOT_TAG = "transportinfo";
    public static final String CLIENT_CONNECTION_TAG = "clientconnections";
    public static final String SERVER_CONNECTION_TAG = "serverconnections";
    public static final String CONNECTION_TAG = "connection";
    public static final String ADDRESS_TAG = "address";
    public static final String HOST_TAG = "host";
    public static final String PORT_TAG = "port";
    public static final String TYPE_TAG = "type";
    public static final String PARAMETERS_TAG = "parameters";
    public static final String ROUTES_TAG = "routes";
    public static final String ROUTE_TAG = "route";
    public static final String DEST_TAG = "destination";
    public static final String NEXTHOP_TAG = "nexthop";
    public static final String FILE_COMMENT = "This file contains automatically generated information. DO NOT EDIT";
    private Vector clientAttributes = new Vector();
    private Vector serverAttributes = new Vector();
    private Hashtable routes = new Hashtable();

    public TransportConfig() {
    }

    public ConnectionSetupAttribute[] getClientConnectionAttributes() {
        return this.clientAttributes.toArray(new ConnectionSetupAttribute[this.clientAttributes.size()]);
    }

    public ConnectionSetupAttribute[] getServerConnectionAttributes() {
        return this.serverAttributes.toArray(new ConnectionSetupAttribute[this.serverAttributes.size()]);
    }

    public Hashtable getRoutes() {
        return this.routes;
    }

    public void addClientConnectionAttribute(ConnectionSetupAttribute csa) {
        this.clientAttributes.add(csa);
    }

    void removeClientConnectionAttribute(ConnectionSetupAttribute csa) {
        this.clientAttributes.remove(csa);
    }

    public void addServerConnectionAttribute(ConnectionSetupAttribute csa) {
        this.serverAttributes.add(csa);
    }

    void removeServerConnectionSetupAttribute(ConnectionSetupAttribute csa) {
        this.serverAttributes.remove(csa);
    }

    public void addRoute(ConfigAddress dest, ConfigAddress next) {
        this.routes.put(dest, next);
    }

    void removeRoute(ConfigAddress dest) {
        this.routes.remove(dest);
    }

    public void save(OutputStream os) throws IOException, IllegalTransportConfig, ParserConfigurationException {
        this.saveNoClose(os);
        os.close();
    }

    public void saveNoClose(OutputStream os) throws IOException, IllegalTransportConfig, ParserConfigurationException {
        try {
            SerializerFactory sf = SerializerFactory.getSerializerFactory((String)"xml");
            Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
            Comment comment = document.createComment(FILE_COMMENT);
            document.appendChild(comment);
            Element root = document.createElement(ROOT_TAG);
            document.appendChild(root);
            this.createClientTags(document, root);
            this.createServerTags(document, root);
            this.createRouteTags(document, root);
            OutputFormat of = new OutputFormat(document);
            of.setIndent(9);
            of.setIndenting(true);
            of.setLineSeparator("\n");
            DOMSerializer s = sf.makeSerializer(os, of).asDOMSerializer();
            s.serialize(document);
            os.flush();
        }
        catch (TransportException e) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_CONFIG_ADDR_ERROR, (Throwable)e);
        }
    }

    private void createClientTags(Document document, Element root) throws TransportException {
        Element client = document.createElement(CLIENT_CONNECTION_TAG);
        root.appendChild(client);
        Enumeration enumeration = this.clientAttributes.elements();
        while (enumeration.hasMoreElements()) {
            this.addConnection(document, client, (ConnectionSetupAttribute)enumeration.nextElement());
        }
    }

    private void createServerTags(Document document, Element root) throws TransportException {
        Element server = document.createElement(SERVER_CONNECTION_TAG);
        root.appendChild(server);
        Enumeration enumeration = this.serverAttributes.elements();
        while (enumeration.hasMoreElements()) {
            this.addConnection(document, server, (ConnectionSetupAttribute)enumeration.nextElement());
        }
    }

    private void createRouteTags(Document document, Element root) {
        Element routeElem = document.createElement(ROUTES_TAG);
        root.appendChild(routeElem);
        if (this.routes != null) {
            Enumeration keys = this.routes.keys();
            while (keys.hasMoreElements()) {
                Element routeRecord = document.createElement(ROUTE_TAG);
                routeElem.appendChild(routeRecord);
                ConfigAddress address = (ConfigAddress)keys.nextElement();
                Element addr = document.createElement(DEST_TAG);
                routeRecord.appendChild(addr);
                this.addAddress(document, addr, address);
                address = (ConfigAddress)this.routes.get(address);
                addr = document.createElement(NEXTHOP_TAG);
                routeRecord.appendChild(addr);
                this.addAddress(document, addr, address);
            }
        }
    }

    private void addConnection(Document document, Element conn, ConnectionSetupAttribute csa) throws TransportException {
        Element connElem = document.createElement(CONNECTION_TAG);
        conn.appendChild(connElem);
        Element addrElem = document.createElement(ADDRESS_TAG);
        connElem.appendChild(addrElem);
        this.addAddress(document, addrElem, new ConfigAddress(csa.getAddress(), csa.getPort()));
        Element tmp = document.createElement(TYPE_TAG);
        connElem.appendChild(tmp);
        this.addText(document, tmp, csa.getType());
        tmp = document.createElement(PARAMETERS_TAG);
        connElem.appendChild(tmp);
        this.addText(document, tmp, csa.getParameters());
    }

    private void addAddress(Document document, Element element, ConfigAddress rox) {
        Element tmp = document.createElement(HOST_TAG);
        element.appendChild(tmp);
        this.addText(document, tmp, rox.hostname);
        tmp = document.createElement(PORT_TAG);
        element.appendChild(tmp);
        this.addText(document, tmp, String.valueOf(rox.port));
    }

    private void addText(Document document, Element elem, String text) {
        Text t = document.createTextNode(text);
        elem.appendChild(t);
    }

    public TransportConfig(InputStream is) throws IllegalTransportConfig, IOException, ParserConfigurationException, SAXException {
        try {
            NodeList routeList;
            NodeList servers;
            DocumentBuilder db = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document doc = db.parse(is);
            Element root = doc.getDocumentElement();
            if (!ROOT_TAG.equals(root.getTagName())) {
                throw new IllegalTransportConfig(NetMessageCode.TRNS_CONFIG_ILLEGAL_ROOT, (Object[])new String[]{ROOT_TAG, root.getTagName()});
            }
            NodeList clients = root.getElementsByTagName(CLIENT_CONNECTION_TAG);
            if (clients.getLength() == 1) {
                this.readClientAttributes((Element)clients.item(0));
            }
            if ((servers = root.getElementsByTagName(SERVER_CONNECTION_TAG)).getLength() == 1) {
                this.readServerAttributes((Element)servers.item(0));
            }
            if ((routeList = root.getElementsByTagName(ROUTES_TAG)).getLength() == 1) {
                this.readRoutes((Element)routeList.item(0));
            }
            is.close();
        }
        catch (TransportException e) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_CONFIG_ADDR_ERROR, (Throwable)e);
        }
    }

    private void readClientAttributes(Element e) throws IllegalTransportConfig, TransportException {
        NodeList conns = e.getElementsByTagName(CONNECTION_TAG);
        this.readConnections(this.clientAttributes, conns);
    }

    private void readServerAttributes(Element e) throws IllegalTransportConfig, TransportException {
        NodeList conns = e.getElementsByTagName(CONNECTION_TAG);
        this.readConnections(this.serverAttributes, conns);
    }

    private void readRoutes(Element e) throws IllegalTransportConfig, TransportException {
        NodeList routeList = e.getElementsByTagName(ROUTE_TAG);
        this.routes = new Hashtable();
        for (int i = 0; i < routeList.getLength(); ++i) {
            Element route = (Element)routeList.item(i);
            NodeList dest = route.getElementsByTagName(DEST_TAG);
            if (dest.getLength() < 1) {
                throw new IllegalTransportConfig(NetMessageCode.TRNS_CONFIG_ROUTE_DEST_SPEC);
            }
            ConfigAddress destAddress = TransportConfig.readAddress((Element)dest.item(0));
            NodeList nextHop = route.getElementsByTagName(NEXTHOP_TAG);
            if (nextHop.getLength() < 1) {
                throw new IllegalTransportConfig(NetMessageCode.TRNS_CONFIG_ROUTE_NEXT_SPEC);
            }
            ConfigAddress nextAddress = TransportConfig.readAddress((Element)nextHop.item(0));
            this.routes.put(destAddress, nextAddress);
        }
    }

    private void readConnections(Vector attributes, NodeList list) throws IllegalTransportConfig, TransportException {
        for (int i = 0; i < list.getLength(); ++i) {
            Element element = (Element)list.item(i);
            attributes.add(TransportConfig.readConnection(element));
        }
    }

    public static ConnectionSetupAttribute readConnection(Element element) throws IllegalTransportConfig, TransportException {
        NodeList tmp = element.getElementsByTagName(ADDRESS_TAG);
        if (tmp.getLength() < 1) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_CONFIG_ADDRESS_MISSING);
        }
        ConfigAddress rox = TransportConfig.readAddress((Element)tmp.item(0));
        tmp = element.getElementsByTagName(TYPE_TAG);
        if (tmp.getLength() < 1) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_CONFIG_TYPE_MISSING);
        }
        String type = TransportConfig.readString((Element)tmp.item(0));
        tmp = element.getElementsByTagName(PARAMETERS_TAG);
        if (tmp.getLength() < 1) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_CONFIG_PARAMETER_MISSING);
        }
        String parameter = TransportConfig.readString((Element)tmp.item(0));
        return new ConnectionSetupAttribute(rox.hostname, rox.port, ConnectionType.FACTORY.get(type), parameter);
    }

    public static String readString(Element e) {
        NodeList nl = e.getChildNodes();
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (n.getNodeType() != 3) continue;
            sb.append(((Text)n).getData());
        }
        return sb.toString();
    }

    private static ConfigAddress readAddress(Element e) throws IllegalTransportConfig, TransportException {
        NodeList tmp = e.getElementsByTagName(HOST_TAG);
        if (tmp.getLength() < 1) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_CONFIG_ADDR_HOST);
        }
        String host = TransportConfig.readString((Element)tmp.item(0));
        tmp = e.getElementsByTagName(PORT_TAG);
        if (tmp.getLength() < 1) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_CONFIG_ADDR_PORT);
        }
        String port = TransportConfig.readString((Element)tmp.item(0));
        return new ConfigAddress(host, Integer.parseInt(port));
    }
}

