/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport.config;

import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.config.ConfigAddress;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import java.util.Vector;

public class RouteNode {
    private AppInstanceID appId;
    private ConnectionSetupAttribute connDetails;
    private ConfigAddress address;
    private RoxAddress roxAddress;
    private RouteNode parent = null;
    private Vector kids = new Vector();

    public RouteNode(AppInstanceID appId, ConnectionSetupAttribute csa) throws TransportException {
        this.appId = appId;
        this.connDetails = csa;
        this.address = new ConfigAddress(csa.getAddress(), csa.getPort());
        this.roxAddress = this.address.getRoxAddress();
    }

    public ConfigAddress getAddress() {
        return this.address;
    }

    public RoxAddress getRoxAddress() {
        return this.roxAddress;
    }

    public void addChild(RouteNode node) {
        this.kids.add(node);
        node.parent = this;
    }

    public boolean removeChild(RouteNode node) {
        node.parent = null;
        return this.kids.remove(node);
    }

    public RouteNode getParent() {
        return this.parent;
    }

    public AppInstanceID getAppId() {
        return this.appId;
    }

    public RouteNode[] getChildren() {
        return this.kids.toArray(new RouteNode[this.kids.size()]);
    }

    public boolean hasChildren() {
        return !this.kids.isEmpty();
    }

    public ConnectionSetupAttribute getConnectionDetails() {
        return this.connDetails;
    }

    public String toString() {
        return "Node:addr:" + this.address + ":parent:" + this.parent;
    }
}

