/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport.config;

import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.ConnectionManager;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.RouteTable;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.config.ConfigAddress;
import com.raplix.rolloutexpress.net.transport.config.ConfigServices;
import com.raplix.rolloutexpress.net.transport.config.ConfigUpdateFailed;
import com.raplix.rolloutexpress.net.transport.config.IllegalTransportConfig;
import com.raplix.rolloutexpress.net.transport.config.TransportConfig;
import com.raplix.util.logger.Logger;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.xml.parsers.ParserConfigurationException;
import org.xml.sax.SAXException;

public class NodeConfigManager
implements ConfigServices {
    private TransportConfig tConfig;
    private ConnectionManager cManager;
    private RouteTable rTable;
    private String transportConfigLocation;

    public NodeConfigManager(NetSubsystem nss) throws ConfigurationException {
        try {
            FileInputStream is;
            this.transportConfigLocation = nss.getTransportConfigLocation();
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Loading transport config from:" + this.transportConfigLocation, this);
            }
            if ((is = new FileInputStream(this.transportConfigLocation)) == null) {
                throw new ConfigurationException("net.transport.config_file_not_found", new String[]{this.transportConfigLocation});
            }
            this.tConfig = new TransportConfig(is);
        }
        catch (IOException ioe) {
            throw new ConfigurationException("net.transport.config_read_error", (Throwable)ioe);
        }
        catch (SAXException se) {
            throw new ConfigurationException("net.transport.config_xml_parse", (Throwable)se);
        }
        catch (IllegalTransportConfig itc) {
            throw new ConfigurationException("net.transport.config_illegal", (Throwable)itc);
        }
        catch (ParserConfigurationException pce) {
            throw new ConfigurationException("net.transport.config_xml_parser", (Throwable)pce);
        }
    }

    public RoxAddress initTransport(RouteTable rTable, ConnectionManager cManager, boolean isCmdLineInvoked) throws TransportException, ConfigurationException {
        int i;
        this.rTable = rTable;
        this.cManager = cManager;
        Hashtable routes = this.tConfig.getRoutes();
        Enumeration enu = routes.keys();
        while (enu.hasMoreElements()) {
            Object key = enu.nextElement();
            rTable.addStaticRoute(((ConfigAddress)key).getRoxAddress(), ((ConfigAddress)routes.get(key)).getRoxAddress());
        }
        ConnectionSetupAttribute[] setupAttrib = this.tConfig.getClientConnectionAttributes();
        for (i = 0; i < setupAttrib.length; ++i) {
            cManager.addClientConnection(setupAttrib[i]);
        }
        setupAttrib = this.tConfig.getServerConnectionAttributes();
        for (i = 0; i < setupAttrib.length; ++i) {
            if (setupAttrib[i].getType().equals(ConnectionSetupAttribute.TYPE_SSH)) {
                if (isCmdLineInvoked) continue;
                throw new ConfigurationException("net.transport.config_invalid_ssh_invocation");
            }
            cManager.addServerConnection(setupAttrib[i]);
        }
        RoxAddress address = null;
        if (setupAttrib.length > 0) {
            address = new RoxAddress(setupAttrib[0].getAddress(), setupAttrib[0].getPort());
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("LocalAddr:" + address + ":routes:" + routes, this);
        }
        return address;
    }

    public void addRoute(ConfigAddress destination, ConfigAddress nextHop) throws RPCException, ConfigUpdateFailed {
        try {
            this.rTable.addStaticRoute(destination.getRoxAddress(), nextHop.getRoxAddress());
            this.tConfig.addRoute(destination, nextHop);
            this.saveConfig();
        }
        catch (TransportException te) {
            throw new ConfigUpdateFailed(NetMessageCode.TRNS_CONFIG_UPDATE_FAILED, (Throwable)te);
        }
    }

    public void removeRoute(ConfigAddress destination) throws RPCException, ConfigUpdateFailed {
        try {
            this.rTable.removeStaticRoute(destination.getRoxAddress());
            this.tConfig.removeRoute(destination);
            this.saveConfig();
        }
        catch (TransportException te) {
            throw new ConfigUpdateFailed(NetMessageCode.TRNS_CONFIG_UPDATE_FAILED, (Throwable)te);
        }
    }

    public void addClientConnection(ConnectionSetupAttribute csa) throws RPCException, ConfigUpdateFailed {
        try {
            this.cManager.addClientConnection(csa);
            this.tConfig.addClientConnectionAttribute(csa);
            this.saveConfig();
        }
        catch (TransportException te) {
            throw new ConfigUpdateFailed(NetMessageCode.TRNS_CONFIG_UPDATE_FAILED, (Throwable)te);
        }
    }

    public void removeClientConnection(ConnectionSetupAttribute csa) throws RPCException, ConfigUpdateFailed {
        try {
            this.cManager.removeClientConnection(csa);
            this.tConfig.removeClientConnectionAttribute(csa);
            this.saveConfig();
        }
        catch (TransportException te) {
            throw new ConfigUpdateFailed(NetMessageCode.TRNS_CONFIG_UPDATE_FAILED, (Throwable)te);
        }
    }

    private void saveConfig() throws ConfigUpdateFailed {
        try {
            this.tConfig.save(new FileOutputStream(this.transportConfigLocation));
        }
        catch (IOException ioe) {
            throw new ConfigUpdateFailed(NetMessageCode.TRNS_CONFIG_FILE_SAVE, (Throwable)ioe);
        }
        catch (ParserConfigurationException pce) {
            throw new ConfigUpdateFailed(NetMessageCode.TRNS_CONFIG_XML_PARSER_ERROR, (Throwable)pce);
        }
        catch (IllegalTransportConfig itc) {
            throw new ConfigUpdateFailed(NetMessageCode.TRNS_CONFIG_ILLEGAL_ERROR, (Throwable)itc);
        }
    }
}

