/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport.config;

import com.raplix.rolloutexpress.Application;
import com.raplix.rolloutexpress.ConfigurationException;
import com.raplix.rolloutexpress.RaplixShutdownException;
import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.SetupException;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.config.HostUpdateManager;
import com.raplix.rolloutexpress.net.transport.config.IllegalTransportConfig;
import com.raplix.rolloutexpress.net.transport.config.RouteTranslationException;
import com.raplix.rolloutexpress.net.transport.config.TransportConfig;
import com.raplix.rolloutexpress.net.transport.config.TransportConfigException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiAppInstanceQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.SingleHostTypeQuery;
import com.raplix.util.logger.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.xml.serialize.DOMSerializer;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.SerializerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class InitNetwork
extends Application {
    private static final String ROOT_TAG = "transportinit";
    private static final String HOST_TAG = "host";
    private static final String NAME_TAG = "name";
    private static final String TYPE_TAG = "type";
    private static final String APPINSTANCE_TAG = "appinstance";
    private static final String APPTYPE_TAG = "apptype";
    private static final String FILE_ARG = "-f";
    private static final String DIR_ARG = "-d";
    private static final String EXPORT = "export";
    private static final String IMPORT = "import";
    private File fileName = null;
    private File outDir = null;
    private String action = null;
    private NetSubsystem net;
    private HostDBSubsystem hostDb;
    private HostUpdateManager huManager;
    private static final String USAGE = "Usage: InitNetwork {import -f<filename> -d<directory_for_config_files> | export -f<outfile>}";

    public static void main(String[] args) {
        block2: {
            try {
                InitNetwork iNet = new InitNetwork(args);
                iNet.process();
            }
            catch (Exception e) {
                if (!Logger.isErrorEnabled(InitNetwork.class)) break block2;
                Logger.error("Failed:", e, InitNetwork.class);
            }
        }
    }

    InitNetwork(String[] args) throws ConfigurationException {
        super(args);
        for (int i = 0; i < args.length; ++i) {
            if (args[i].startsWith(FILE_ARG)) {
                this.fileName = new File(args[i].substring(2));
            }
            if (args[i].startsWith(DIR_ARG)) {
                this.outDir = new File(args[i].substring(2));
            }
            if (args[i].equals(EXPORT)) {
                this.action = EXPORT;
            }
            if (!args[i].equals(IMPORT)) continue;
            this.action = IMPORT;
        }
        boolean error = false;
        if (this.action != null) {
            if (this.action.equals(EXPORT)) {
                if (this.fileName == null) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Please specify an output file", this);
                    }
                    error = true;
                }
                if (this.fileName.exists()) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Specified output file, exists already:" + this.fileName.getAbsolutePath(), this);
                    }
                    error = true;
                }
            } else if (this.action.equals(IMPORT)) {
                if (this.fileName == null) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Please specify an input file", this);
                    }
                    error = true;
                }
                if (!this.fileName.exists()) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Could not find the input file:" + this.fileName.getAbsolutePath(), this);
                    }
                    error = true;
                }
                if (!this.fileName.canRead()) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Could not read the input file:" + this.fileName.getAbsolutePath(), this);
                    }
                    error = true;
                }
                if (this.outDir == null) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Please specify an output directory", this);
                    }
                    error = true;
                }
                if (!this.outDir.exists()) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Could not find the output directory:" + this.outDir.getAbsolutePath(), this);
                    }
                    error = true;
                }
                if (!this.outDir.isDirectory()) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error(this.outDir.getAbsolutePath() + " is not a directory:", this);
                    }
                    error = true;
                }
                if (!this.outDir.canWrite()) {
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Cannot write to the directory:" + this.outDir.getAbsolutePath(), this);
                    }
                    error = true;
                }
            } else {
                if (Logger.isErrorEnabled(this)) {
                    Logger.error("Illegal action:" + this.action, this);
                }
                error = true;
            }
        } else {
            if (Logger.isErrorEnabled(this)) {
                Logger.error("Please specify an action", this);
            }
            error = true;
        }
        if (error) {
            if (Logger.isErrorEnabled(this)) {
                Logger.error(USAGE, this);
            }
            System.exit(1);
        }
        this.net = NetSubsystem.createNetSubsystemForMS(this);
        this.hostDb = new HostDBSubsystem(this);
    }

    private void process() throws IllegalTransportConfig, IOException, PersistenceManagerException, ParserConfigurationException, RPCException, SAXException, TransportException, RouteTranslationException, UnsupportedSubsystemException, ConfigurationException, TransportConfigException {
        if (EXPORT.equals(this.action)) {
            if (Logger.isInfoEnabled(this)) {
                Logger.info("Exporting to :" + this.fileName.getAbsolutePath(), this);
            }
            InitNetwork.writeInitFile(new FileOutputStream(this.fileName));
        } else if (IMPORT.equals(this.action)) {
            if (Logger.isInfoEnabled(this)) {
                Logger.info("Importing from:" + this.fileName.getAbsolutePath(), this);
            }
            InitNetwork.initHostDB(new FileInputStream(this.fileName));
            this.genConfig();
        }
    }

    private void genConfig() throws IOException, RPCException, PersistenceManagerException, SetupException, TransportConfigException, IllegalTransportConfig, ConfigurationException, TransportException, ParserConfigurationException, UnsupportedSubsystemException, RouteTranslationException {
        this.huManager = new HostUpdateManager(this.net);
        this.huManager.postInitWithoutListeningForHostDbChanges();
        InitNetwork.genConfig(this.outDir, this.huManager);
    }

    private static void genConfig(File destDir, HostUpdateManager hManager) throws IOException, PersistenceManagerException, RPCException, SetupException, TransportConfigException, IllegalTransportConfig, ConfigurationException, TransportException, ParserConfigurationException {
        AppInstance msApp = AppInstance.MASTER_SERVER_ID.getByIDQuery().select();
        String[] serverArgs = new String[]{"-Dhostdb.ms.ipaddress=" + msApp.getIPAddress(), "-Dhostdb.ms.port=" + msApp.getPort()};
        TransportConfig config = null;
        AppInstance[] apps = MultiAppInstanceQuery.all().select();
        for (int i = 0; i < apps.length; ++i) {
            config = hManager.createTransportConfigFor(apps[i]);
            File file = new File(destDir, apps[i].getIPAddress() + "." + apps[i].getPort());
            config.save(new FileOutputStream(file));
        }
    }

    private static void initHostDB(InputStream is) throws IllegalTransportConfig, IOException, ParserConfigurationException, RPCException, SAXException, PersistenceManagerException, TransportException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder db = factory.newDocumentBuilder();
        Document doc = db.parse(is);
        Element root = doc.getDocumentElement();
        if (!ROOT_TAG.equals(root.getLocalName())) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_NET_INIT_DOC_ROOT, (Object[])new String[]{ROOT_TAG, root.getLocalName()});
        }
        Vector apps = InitNetwork.getChildByName(root, APPINSTANCE_TAG);
        if (apps.size() != 1) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_NET_INIT_ROOT_MULTI_APPS);
        }
        InitNetwork.readApps((Element)apps.elementAt(0), null);
        is.close();
    }

    private static void readApps(Element app, AppInstanceID parentId) throws TransportException, IllegalTransportConfig, PersistenceManagerException, RPCException {
        Host persistHost = null;
        Element host = null;
        Vector list = InitNetwork.getChildByName(app, HOST_TAG);
        if (list.size() != 1) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_NET_INIT_APP_SPEC, (Object[])new String[]{parentId.toString()});
        }
        host = (Element)list.elementAt(0);
        String name = host.getAttribute(NAME_TAG);
        if (name == null || name.trim().length() < 1) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_NET_INIT_HOST_NAME, (Object[])new String[]{parentId.toString()});
        }
        String type = host.getAttribute(TYPE_TAG);
        if (type == null || type.trim().length() < 1) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_NET_INIT_HOST_TYPE, (Object[])new String[]{parentId.toString()});
        }
        AppInst appInst = InitNetwork.readAppInstance(app);
        if (AppType.MS.equals(appInst.appType)) {
            persistHost = Host.MASTER_SERVER_ID.getByIDQuery().select();
        } else {
            try {
                persistHost = SingleHostQuery.byName(name).select();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (persistHost == null) {
            persistHost = new Host();
            persistHost.setName(name);
            if (Logger.isInfoEnabled(InitNetwork.class)) {
                Logger.info("Creating host:" + persistHost, InitNetwork.class);
            }
        }
        HostType hType = SingleHostTypeQuery.byName(type).select();
        persistHost.setHostType(hType);
        if (AppType.MS.equals(appInst.appType)) {
            InitNetwork.addAppToHost(persistHost, appInst, parentId, persistHost.getAppMS());
        }
        if (AppType.LD.equals(appInst.appType)) {
            InitNetwork.addAppToHost(persistHost, appInst, parentId, persistHost.getAppLD());
        }
        if (AppType.RA.equals(appInst.appType)) {
            InitNetwork.addAppToHost(persistHost, appInst, parentId, persistHost.getAppRA());
        }
        persistHost.save();
        parentId = persistHost.getAppInstance(appInst.appType).getID();
        list = InitNetwork.getChildByName(app, APPINSTANCE_TAG);
        for (int i = 0; i < list.size(); ++i) {
            InitNetwork.readApps((Element)list.elementAt(i), parentId);
        }
    }

    static void addAppToHost(Host host, AppInst inst, AppInstanceID parentId, AppInstance existing) throws TransportException {
        if (existing == null) {
            existing = new AppInstance(inst.appType);
        }
        existing.setRoxAddress(new RoxAddress(inst.setupAttrib.getAddress(), inst.setupAttrib.getPort()));
        existing.setConnectionType(inst.setupAttrib.getConnectionType());
        existing.setParameters(inst.setupAttrib.getParameters());
        existing.setParentID(parentId);
        host.addAppInstance(existing);
    }

    static AppInst readAppInstance(Element appElement) throws TransportException, IllegalTransportConfig {
        AppInst retValue = new AppInst();
        Vector list = InitNetwork.getChildByName(appElement, APPTYPE_TAG);
        if (list.size() != 1) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_NET_INIT_APP_TYPE);
        }
        retValue.appType = AppType.FACTORY.get(TransportConfig.readString((Element)list.elementAt(0)));
        list = InitNetwork.getChildByName(appElement, "connection");
        if (list.size() != 1) {
            throw new IllegalTransportConfig(NetMessageCode.TRNS_NET_INIT_APP_CONN);
        }
        retValue.setupAttrib = TransportConfig.readConnection((Element)list.elementAt(0));
        return retValue;
    }

    public static Vector getChildByName(Element e, String name) {
        NodeList nl = e.getChildNodes();
        Vector<Node> v = new Vector<Node>();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node node = nl.item(i);
            if (!name.equals(node.getLocalName())) continue;
            v.add(node);
        }
        return v;
    }

    protected String getVersionString() {
        return "Test Version";
    }

    public NetSubsystem getNetSubsystem() {
        return this.net;
    }

    protected void shutdown() throws RaplixShutdownException {
        this.hostDb.shutdown();
        this.net.shutdown();
    }

    protected void buildConfigurationFilesForSubsystems(Hashtable inTable) throws ConfigurationException {
    }

    public HostDBSubsystem getHostDBSubsystem() throws UnsupportedSubsystemException {
        return this.hostDb;
    }

    public static void writeInitFile(OutputStream os) throws IOException, ParserConfigurationException, RPCException, PersistenceManagerException {
        AppInstance[] apps = MultiAppInstanceQuery.all().select();
        AppInstance ms = null;
        Hashtable<AppInstanceID, Vector<AppInstance>> children = new Hashtable<AppInstanceID, Vector<AppInstance>>();
        for (int i = 0; i < apps.length; ++i) {
            AppInstance app = apps[i];
            AppInstanceID parentId = app.getParentID();
            if (parentId == null) {
                ms = app;
                continue;
            }
            Vector<AppInstance> kids = (Vector<AppInstance>)children.get(parentId);
            if (kids == null) {
                kids = new Vector<AppInstance>();
                children.put(parentId, kids);
            }
            kids.add(app);
        }
        if (ms == null) {
            throw new IllegalArgumentException("Invalid file contents, no master server app found.");
        }
        SerializerFactory sf = SerializerFactory.getSerializerFactory((String)"xml");
        Document document = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        Element root = document.createElement(ROOT_TAG);
        document.appendChild(root);
        InitNetwork.addApp(ms, children, root);
        OutputFormat of = new OutputFormat(document);
        of.setIndent(9);
        of.setIndenting(true);
        of.setLineSeparator("\n");
        DOMSerializer s = sf.makeSerializer(os, of).asDOMSerializer();
        s.serialize(document);
        os.close();
    }

    private static void addApp(AppInstance app, Hashtable children, Element parent) throws IOException, PersistenceManagerException, RPCException {
        Element appElem = parent.getOwnerDocument().createElement(APPINSTANCE_TAG);
        parent.appendChild(appElem);
        Element appType = parent.getOwnerDocument().createElement(APPTYPE_TAG);
        appElem.appendChild(appType);
        InitNetwork.addText(appType, app.getType().toString());
        Element hostTag = parent.getOwnerDocument().createElement(HOST_TAG);
        appElem.appendChild(hostTag);
        Host host = app.getHostID().getByIDQuery().select();
        hostTag.setAttribute(NAME_TAG, host.getName());
        hostTag.setAttribute(TYPE_TAG, host.getHostType().getName());
        InitNetwork.addConnection(app, appElem);
        Vector vec = (Vector)children.get(app.getID());
        if (vec != null) {
            Enumeration enu = vec.elements();
            while (enu.hasMoreElements()) {
                AppInstance child = (AppInstance)enu.nextElement();
                InitNetwork.addApp(child, children, appElem);
            }
        }
    }

    private static void addConnection(AppInstance app, Element parent) {
        Element conn = parent.getOwnerDocument().createElement("connection");
        parent.appendChild(conn);
        Element addr = parent.getOwnerDocument().createElement("address");
        conn.appendChild(addr);
        Element host = parent.getOwnerDocument().createElement(HOST_TAG);
        addr.appendChild(host);
        InitNetwork.addText(host, app.getIPAddress());
        Element port = parent.getOwnerDocument().createElement("port");
        addr.appendChild(port);
        InitNetwork.addText(port, String.valueOf(app.getPort()));
        Element type = parent.getOwnerDocument().createElement(TYPE_TAG);
        conn.appendChild(type);
        InitNetwork.addText(type, app.getConnectionType().toString());
        Element parm = parent.getOwnerDocument().createElement("parameters");
        conn.appendChild(parm);
        InitNetwork.addText(parm, app.getParameters());
    }

    private static void addText(Element elem, String text) {
        elem.appendChild(elem.getOwnerDocument().createTextNode(text));
    }

    private static class AppInst {
        AppType appType;
        ConnectionSetupAttribute setupAttrib;

        private AppInst() {
        }

        public String toString() {
            return "AppInst:Type:" + this.appType + ":ConnectionData:" + this.setupAttrib;
        }
    }
}

