/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport.config;

import com.raplix.rolloutexpress.UnsupportedSubsystemException;
import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.NetSubsystem;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.ConnectionManager;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.RouteTable;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.config.ConfigAddress;
import com.raplix.rolloutexpress.net.transport.config.ConfigServices;
import com.raplix.rolloutexpress.net.transport.config.ConfigUpdateFailed;
import com.raplix.rolloutexpress.net.transport.config.HostDbRouteTree;
import com.raplix.rolloutexpress.net.transport.config.HostNotificationValidationFailure;
import com.raplix.rolloutexpress.net.transport.config.RouteNode;
import com.raplix.rolloutexpress.net.transport.config.RouteTranslationException;
import com.raplix.rolloutexpress.net.transport.config.TransportConfig;
import com.raplix.rolloutexpress.net.transport.config.TransportConfigException;
import com.raplix.rolloutexpress.net.transport.config.TransportConfigUpdateFailure;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostDBSubsystem;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostUpdateListener;
import com.raplix.rolloutexpress.systemmodel.hostdbx.UpdateIncompleteException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.UpdateNotAcceptedException;
import com.raplix.util.logger.Logger;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class HostUpdateManager
implements HostUpdateListener {
    private NetSubsystem netSubsystem;
    private HostDbRouteTree routeTree;
    private RouteTable rTable;
    private ConnectionManager cManager;

    public HostUpdateManager(NetSubsystem nss) {
        this.netSubsystem = nss;
    }

    public void postInitWithoutListeningForHostDbChanges() throws UnsupportedSubsystemException, RouteTranslationException {
        this.postInit(false);
    }

    private void postInit(boolean registerWithHostDb) throws UnsupportedSubsystemException, RouteTranslationException {
        HostDBSubsystem hostdb = this.netSubsystem.getApplication().getHostDBSubsystem();
        this.routeTree = new HostDbRouteTree();
        if (registerWithHostDb) {
            hostdb.registerHostUpdateListener(this);
        }
    }

    private TransportConfig getRootTransportConfig() throws TransportConfigException, TransportException {
        return this.createTransportConfigForNode(this.routeTree.getRootNode());
    }

    public AppInstanceID getAppInstanceID(RoxAddress address) {
        RouteNode node = this.routeTree.getNodeForAddress(address);
        if (node != null) {
            return node.getAppId();
        }
        return null;
    }

    public TransportConfig createTransportConfigFor(AppInstance appInstance) throws TransportConfigException, TransportException {
        return this.createTransportConfigFor(appInstance.getID());
    }

    public TransportConfig createTransportConfigFor(AppInstanceID appInstanceID) throws TransportConfigException, TransportException {
        RouteNode rn = this.routeTree.getNodeForApp(appInstanceID);
        if (rn == null) {
            throw new TransportConfigException(NetMessageCode.TRNS_CONFIG_APP_NOT_FOUND, (Object[])new String[]{appInstanceID.toString()});
        }
        return this.createTransportConfigForNode(rn);
    }

    private TransportConfig createTransportConfigForNode(RouteNode rn) throws TransportConfigException, TransportException {
        RouteNode child;
        TransportConfig tConfig = new TransportConfig();
        RouteNode[] children = rn.getChildren();
        for (int i = 0; i < children.length; ++i) {
            child = children[i];
            tConfig.addClientConnectionAttribute(child.getConnectionDetails());
        }
        for (int i = 0; i < children.length; ++i) {
            child = children[i];
            ConfigAddress next = child.getAddress();
            this.addRouteRecursively(next, child, tConfig);
        }
        ConnectionSetupAttribute csa = rn.getConnectionDetails();
        tConfig.addServerConnectionAttribute(csa);
        return tConfig;
    }

    private void addRouteRecursively(ConfigAddress next, RouteNode rn, TransportConfig tConfig) throws TransportException {
        RouteNode[] children = rn.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                tConfig.addRoute(children[i].getAddress(), next);
                this.addRouteRecursively(next, children[i], tConfig);
            }
        }
    }

    public void hostAdded(Host host) throws UpdateIncompleteException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("host added: " + host, this);
        }
        try {
            FailedNodeSet failedNodes = new FailedNodeSet();
            FailedNodeSet addNodes = new FailedNodeSet();
            AppInstance[] appInstances = host.getAppInstances();
            for (int i = 0; i < appInstances.length; ++i) {
                this.addAppInstance(failedNodes, addNodes, appInstances[i]);
            }
            this.checkFailedNodes(failedNodes, addNodes);
        }
        catch (TransportException te) {
            throw new UpdateIncompleteException(NetMessageCode.TRNS_HOSTDB_ADDHOST_ERROR_TRANSPORT.roxMessage(new String[]{host.toString()}), (Throwable)te);
        }
        catch (HostNotificationValidationFailure hnvf) {
            throw new UpdateIncompleteException(NetMessageCode.TRNS_HOSTDB_ADDHOST_ERROR_CONF_UPD.roxMessage(new String[]{host.toString()}), (Throwable)hnvf);
        }
    }

    public void hostDeleted(Host host) throws UpdateIncompleteException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("host deleted: " + host, this);
        }
        try {
            FailedNodeSet failedNodes = new FailedNodeSet();
            AppInstance[] appInstances = host.getAppInstances();
            for (int i = 0; i < appInstances.length; ++i) {
                this.deleteAppInstance(failedNodes, appInstances[i]);
            }
            this.checkFailedNodes(failedNodes, null);
        }
        catch (HostNotificationValidationFailure hnvf) {
            throw new UpdateIncompleteException(NetMessageCode.TRNS_HOSTDB_DELHOST_ERROR_CONF_UPD.roxMessage(new String[]{host.toString()}), (Throwable)hnvf);
        }
        catch (TransportException te) {
            throw new UpdateIncompleteException(NetMessageCode.TRNS_HOSTDB_DELHOST_ERROR_TRANSPORT.roxMessage(new String[]{host.toString()}), (Throwable)te);
        }
    }

    public void hostUpdated(Host newHost, Host oldHost) throws UpdateIncompleteException {
        try {
            RouteNode node;
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Host Updated:" + newHost, this);
            }
            FailedNodeSet failedNodes = new FailedNodeSet();
            FailedNodeSet addNodes = new FailedNodeSet();
            AppInstance oldRA = oldHost.getAppRA();
            AppInstance oldLD = oldHost.getAppLD();
            AppInstance newRA = newHost.getAppRA();
            AppInstance newLD = newHost.getAppLD();
            if (oldRA != null && newRA == null || oldRA != null && newRA != null && this.checkModifiedAppInstance(oldRA, newRA)) {
                this.deleteAppInstance(failedNodes, oldRA);
            }
            if (oldLD != null && newLD == null) {
                node = this.routeTree.getNodeForApp(oldLD.getID());
                if (node == null) {
                    throw new HostNotificationValidationFailure(NetMessageCode.TRNS_CONFIG_DEL_APP_NOT_FOUND, (Object[])new String[]{oldLD.toString()});
                }
                if (node.hasChildren()) {
                    throw new HostNotificationValidationFailure(NetMessageCode.TRNS_CONFIG_NODE_HAS_CHILDREN, (Object[])new String[]{oldLD.getID().toString()});
                }
                this.deleteAppInstance(failedNodes, oldLD);
            }
            if (oldLD != null && newLD != null && this.checkModifiedAppInstance(oldLD, newLD)) {
                this.updateLD(failedNodes, oldLD, newLD);
            }
            if (oldLD == null && newLD != null) {
                this.addAppInstance(failedNodes, addNodes, newLD);
            }
            if (oldRA == null && newRA != null || oldRA != null && newRA != null && this.checkModifiedAppInstance(oldRA, newRA)) {
                this.addAppInstance(failedNodes, null, newRA);
                node = this.routeTree.getNodeForApp(newRA.getID());
                if (node != null) {
                    if (oldRA != null) {
                        failedNodes.add(node);
                    } else {
                        addNodes.add(node);
                    }
                }
            }
            this.checkFailedNodes(failedNodes, addNodes);
        }
        catch (TransportException te) {
            throw new UpdateIncompleteException(NetMessageCode.TRNS_HOSTDB_UPDHOST_ERROR_TRANSPORT.roxMessage(new String[]{newHost.toString()}), (Throwable)te);
        }
        catch (HostNotificationValidationFailure hnvf) {
            throw new UpdateIncompleteException(NetMessageCode.TRNS_HOSTDB_UPDHOST_ERROR_CONF_UPD.roxMessage(new String[]{newHost.toString()}), (Throwable)hnvf);
        }
    }

    private boolean checkModifiedAppInstance(AppInstance oldApp, AppInstance newApp) {
        return !oldApp.getIPAddress().equals(newApp.getIPAddress()) || oldApp.getPort() != newApp.getPort() || !oldApp.getConnectionType().equals(newApp.getConnectionType()) || !oldApp.getParameters().equals(newApp.getParameters()) || oldApp.getParentID() != null && !oldApp.getParentID().equals(newApp.getParentID());
    }

    private void addAppInstance(FailedNodeSet failedNodes, FailedNodeSet addNodes, AppInstance app) throws TransportException, HostNotificationValidationFailure {
        ConfigServices cs;
        RouteNode node;
        RouteNode parentNode;
        block18: {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Adding app" + app, this);
            }
            AppInstanceID parentId = app.getParentID();
            parentNode = this.routeTree.getNodeForApp(parentId);
            try {
                node = new RouteNode(app.getID(), HostDbRouteTree.createSetupAttribute(app));
            }
            catch (RouteTranslationException rte) {
                throw new HostNotificationValidationFailure(NetMessageCode.TRNS_CONFIG_ADD_APP_INVALID_INFO, (Throwable)rte);
            }
            if (parentNode == null) {
                throw new HostNotificationValidationFailure(NetMessageCode.TRNS_CONFIG_ADD_APP_INVALID_PARENT, (Object[])new String[]{parentId.toString()});
            }
            if (parentNode.getParent() != null) {
                try {
                    cs = (ConfigServices)this.netSubsystem.getRPC().getService(parentNode.getRoxAddress(), ConfigServices.class);
                    cs.addClientConnection(node.getConnectionDetails());
                }
                catch (RPCException rpce) {
                    failedNodes.add(parentNode);
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Error updating Client Connection Record at:" + parentNode.getRoxAddress(), rpce, this);
                    }
                    break block18;
                }
                catch (ConfigUpdateFailed cuf) {
                    failedNodes.add(parentNode);
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Error updating Client Connection Record at:" + parentNode.getRoxAddress(), cuf, this);
                    }
                    break block18;
                }
            }
            this.addClientConnection(node.getConnectionDetails());
        }
        RouteNode tmp = parentNode;
        RouteNode tmpParent = parentNode;
        while ((tmp = tmpParent.getParent()) != null) {
            block19: {
                if (tmp.getParent() == null) {
                    this.addRoute(node.getRoxAddress(), tmpParent.getRoxAddress());
                } else {
                    try {
                        cs = (ConfigServices)this.netSubsystem.getRPC().getService(tmp.getRoxAddress(), class$com$raplix$rolloutexpress$net$transport$config$ConfigServices == null ? HostUpdateManager.class$("com.raplix.rolloutexpress.net.transport.config.ConfigServices") : class$com$raplix$rolloutexpress$net$transport$config$ConfigServices);
                        cs.addRoute(node.getAddress(), tmpParent.getAddress());
                    }
                    catch (RPCException rpce) {
                        failedNodes.add(tmp);
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Error updating Routing Record at:" + tmp.getRoxAddress(), rpce, this);
                        }
                    }
                    catch (ConfigUpdateFailed cuf) {
                        failedNodes.add(tmp);
                        if (!Logger.isErrorEnabled(this)) break block19;
                        Logger.error("Error updating Routing Record at:" + tmp.getRoxAddress(), cuf, this);
                    }
                }
            }
            tmpParent = tmp;
        }
        this.routeTree.addNode(parentNode, node);
        if (addNodes != null) {
            addNodes.add(node);
        }
    }

    private void deleteAppInstance(FailedNodeSet failedNodes, AppInstance app) throws TransportException, HostNotificationValidationFailure {
        ConfigServices cs;
        RouteNode parentNode;
        RouteNode node;
        block16: {
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Deleting app" + app, this);
            }
            AppInstanceID parentId = app.getParentID();
            node = this.routeTree.getNodeForApp(app.getID());
            if (node == null) {
                throw new HostNotificationValidationFailure(NetMessageCode.TRNS_CONFIG_DEL_APP_NOT_FOUND, (Object[])new String[]{app.toString()});
            }
            parentNode = node.getParent();
            if (parentNode == null) {
                throw new HostNotificationValidationFailure(NetMessageCode.TRNS_CONFIG_DEL_APP_NO_PARENT, (Object[])new String[]{node.toString()});
            }
            if (parentNode.getParent() != null) {
                try {
                    cs = (ConfigServices)this.netSubsystem.getRPC().getService(parentNode.getRoxAddress(), ConfigServices.class);
                    cs.removeClientConnection(node.getConnectionDetails());
                }
                catch (RPCException rpce) {
                    failedNodes.add(parentNode);
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Error updating Client Connection Record at:" + parentNode.getRoxAddress(), rpce, this);
                    }
                    break block16;
                }
                catch (ConfigUpdateFailed cuf) {
                    failedNodes.add(parentNode);
                    if (Logger.isErrorEnabled(this)) {
                        Logger.error("Error updating Client Connection Record at:" + parentNode.getRoxAddress(), cuf, this);
                    }
                    break block16;
                }
            }
            this.removeClientConnection(node.getConnectionDetails());
        }
        RouteNode tmp = parentNode;
        RouteNode tmpParent = parentNode;
        while ((tmp = tmpParent.getParent()) != null) {
            block17: {
                if (tmp.getParent() == null) {
                    this.removeRoute(node.getRoxAddress());
                } else {
                    try {
                        cs = (ConfigServices)this.netSubsystem.getRPC().getService(tmp.getRoxAddress(), class$com$raplix$rolloutexpress$net$transport$config$ConfigServices == null ? HostUpdateManager.class$("com.raplix.rolloutexpress.net.transport.config.ConfigServices") : class$com$raplix$rolloutexpress$net$transport$config$ConfigServices);
                        cs.removeRoute(node.getAddress());
                    }
                    catch (RPCException rpce) {
                        failedNodes.add(tmp);
                        if (Logger.isErrorEnabled(this)) {
                            Logger.error("Error updating Routing Record at:" + tmp.getRoxAddress(), rpce, this);
                        }
                    }
                    catch (ConfigUpdateFailed cuf) {
                        failedNodes.add(tmp);
                        if (!Logger.isErrorEnabled(this)) break block17;
                        Logger.error("Error updating Routing Record at:" + tmp.getRoxAddress(), cuf, this);
                    }
                }
            }
            tmpParent = tmp;
        }
        this.routeTree.deleteNode(node);
    }

    /*
     * Unable to fully structure code
     */
    private void updateLD(FailedNodeSet failedNodes, AppInstance oldLD, AppInstance newLD) throws TransportException, HostNotificationValidationFailure {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Updating LD, OLD:" + oldLD + ":NEW:" + newLD, this);
        }
        if ((oldNode = this.routeTree.getNodeForApp(oldLD.getID())) == null) {
            throw new HostNotificationValidationFailure(NetMessageCode.TRNS_CONFIG_DEL_APP_NOT_FOUND, (Object[])new String[]{oldLD.toString()});
        }
        oldParentNode = oldNode.getParent();
        if (oldParentNode == null) {
            throw new HostNotificationValidationFailure(NetMessageCode.TRNS_CONFIG_DEL_APP_NO_PARENT, (Object[])new String[]{oldNode.toString()});
        }
        try {
            newNode = new RouteNode(newLD.getID(), HostDbRouteTree.createSetupAttribute(newLD));
        }
        catch (RouteTranslationException rte) {
            throw new HostNotificationValidationFailure(NetMessageCode.TRNS_CONFIG_ADD_APP_INVALID_INFO, (Throwable)rte);
        }
        newParentNode = this.routeTree.getNodeForApp(newLD.getParentID());
        if (newParentNode == null) {
            throw new HostNotificationValidationFailure(NetMessageCode.TRNS_CONFIG_ADD_APP_INVALID_PARENT, (Object[])new String[]{newLD.getParentID().toString()});
        }
        addresses = new Vector<E>();
        if (oldParentNode.getParent() != null) {
            try {
                cs = (ConfigServices)this.netSubsystem.getRPC().getService(oldParentNode.getRoxAddress(), ConfigServices.class);
                cs.removeClientConnection(oldNode.getConnectionDetails());
                addresses.clear();
                this.getChildConfigAddresses(addresses, oldNode);
                eRoutes = addresses.elements();
                while (eRoutes.hasMoreElements()) {
                    cs.removeRoute((ConfigAddress)eRoutes.nextElement());
                }
            }
            catch (RPCException rpce) {
                failedNodes.add(oldParentNode);
                if (!Logger.isErrorEnabled(this)) ** GOTO lbl45
                Logger.error("Error updating Transport Config information at:" + oldParentNode.getRoxAddress(), rpce, this);
            }
            catch (ConfigUpdateFailed cuf) {
                failedNodes.add(oldParentNode);
                if (!Logger.isErrorEnabled(this)) ** GOTO lbl45
                Logger.error("Error updating Transport Config information at:" + oldParentNode.getRoxAddress(), cuf, this);
            }
        } else {
            this.removeClientConnection(oldNode.getConnectionDetails());
            addresses.clear();
            this.getChildRoxAddresses(addresses, oldNode);
            eRoutes = addresses.elements();
            while (eRoutes.hasMoreElements()) {
                this.removeRoute((RoxAddress)eRoutes.nextElement());
            }
        }
lbl45:
        // 6 sources

        tmp = oldParentNode;
        tmpParent = oldParentNode;
        while ((tmp = tmpParent.getParent()) != null) {
            if (tmp.getParent() == null) {
                this.removeRoute(oldNode.getRoxAddress());
                addresses.clear();
                this.getChildRoxAddresses(addresses, oldNode);
                eRoutes = addresses.elements();
                while (eRoutes.hasMoreElements()) {
                    this.removeRoute((RoxAddress)eRoutes.nextElement());
                }
            } else {
                try {
                    cs = (ConfigServices)this.netSubsystem.getRPC().getService(tmp.getRoxAddress(), HostUpdateManager.class$com$raplix$rolloutexpress$net$transport$config$ConfigServices == null ? HostUpdateManager.class$("com.raplix.rolloutexpress.net.transport.config.ConfigServices") : HostUpdateManager.class$com$raplix$rolloutexpress$net$transport$config$ConfigServices);
                    cs.removeRoute(oldNode.getAddress());
                    addresses.clear();
                    this.getChildConfigAddresses(addresses, oldNode);
                    eRoutes = addresses.elements();
                    while (eRoutes.hasMoreElements()) {
                        cs.removeRoute((ConfigAddress)eRoutes.nextElement());
                    }
                }
                catch (RPCException rpce) {
                    failedNodes.add(tmp);
                    if (!Logger.isErrorEnabled(this)) ** GOTO lbl76
                    Logger.error("Error updating Routing Record at:" + tmp.getRoxAddress(), rpce, this);
                }
                catch (ConfigUpdateFailed cuf) {
                    failedNodes.add(tmp);
                    if (!Logger.isErrorEnabled(this)) ** GOTO lbl76
                    Logger.error("Error updating Routing Record at:" + tmp.getRoxAddress(), cuf, this);
                }
            }
lbl76:
            // 6 sources

            tmpParent = tmp;
        }
        if (newParentNode.getParent() != null) {
            try {
                cs = (ConfigServices)this.netSubsystem.getRPC().getService(newParentNode.getRoxAddress(), ConfigServices.class);
                cs.addClientConnection(newNode.getConnectionDetails());
                addresses.clear();
                this.getChildConfigAddresses(addresses, oldNode);
                eRoutes = addresses.elements();
                while (eRoutes.hasMoreElements()) {
                    cs.addRoute((ConfigAddress)eRoutes.nextElement(), newNode.getAddress());
                }
            }
            catch (RPCException rpce) {
                failedNodes.add(newParentNode);
                if (!Logger.isErrorEnabled(this)) ** GOTO lbl106
                Logger.error("Error updating Transport Config information at:" + newParentNode.getRoxAddress(), rpce, this);
            }
            catch (ConfigUpdateFailed cuf) {
                failedNodes.add(newParentNode);
                if (!Logger.isErrorEnabled(this)) ** GOTO lbl106
                Logger.error("Error updating Transport Config information at:" + newParentNode.getRoxAddress(), cuf, this);
            }
        } else {
            this.addClientConnection(newNode.getConnectionDetails());
            addresses.clear();
            this.getChildRoxAddresses(addresses, oldNode);
            eRoutes = addresses.elements();
            while (eRoutes.hasMoreElements()) {
                this.addRoute((RoxAddress)eRoutes.nextElement(), newNode.getRoxAddress());
            }
        }
lbl106:
        // 6 sources

        tmp = newParentNode;
        tmpParent = newParentNode;
        while ((tmp = tmpParent.getParent()) != null) {
            if (tmp.getParent() == null) {
                this.addRoute(oldNode.getRoxAddress(), tmpParent.getRoxAddress());
                addresses.clear();
                this.getChildRoxAddresses(addresses, oldNode);
                eRoutes = addresses.elements();
                while (eRoutes.hasMoreElements()) {
                    this.addRoute((RoxAddress)eRoutes.nextElement(), tmpParent.getRoxAddress());
                }
            } else {
                try {
                    cs = (ConfigServices)this.netSubsystem.getRPC().getService(tmp.getRoxAddress(), HostUpdateManager.class$com$raplix$rolloutexpress$net$transport$config$ConfigServices == null ? HostUpdateManager.class$("com.raplix.rolloutexpress.net.transport.config.ConfigServices") : HostUpdateManager.class$com$raplix$rolloutexpress$net$transport$config$ConfigServices);
                    cs.addRoute(oldNode.getAddress(), tmpParent.getAddress());
                    addresses.clear();
                    this.getChildConfigAddresses(addresses, oldNode);
                    eRoutes = addresses.elements();
                    while (eRoutes.hasMoreElements()) {
                        cs.addRoute((ConfigAddress)eRoutes.nextElement(), tmpParent.getAddress());
                    }
                }
                catch (RPCException rpce) {
                    failedNodes.add(tmp);
                    if (!Logger.isErrorEnabled(this)) ** GOTO lbl137
                    Logger.error("Error updating Routing Record at:" + tmp.getRoxAddress(), rpce, this);
                }
                catch (ConfigUpdateFailed cuf) {
                    failedNodes.add(tmp);
                    if (!Logger.isErrorEnabled(this)) ** GOTO lbl137
                    Logger.error("Error updating Routing Record at:" + tmp.getRoxAddress(), cuf, this);
                }
            }
lbl137:
            // 6 sources

            tmpParent = tmp;
        }
        this.routeTree.deleteNode(oldNode);
        children = oldNode.getChildren();
        for (i = 0; i < children.length; ++i) {
            newNode.addChild(children[i]);
        }
        this.routeTree.addNode(newParentNode, newNode);
        failedNodes.add(oldNode);
    }

    private void getChildRoxAddresses(Vector addresses, RouteNode node) {
        RouteNode[] kids = node.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            addresses.add(kids[i].getRoxAddress());
            this.getChildRoxAddresses(addresses, kids[i]);
        }
    }

    private void getChildConfigAddresses(Vector addresses, RouteNode node) {
        RouteNode[] kids = node.getChildren();
        for (int i = 0; i < kids.length; ++i) {
            addresses.add(kids[i].getAddress());
            this.getChildRoxAddresses(addresses, kids[i]);
        }
    }

    public RoxAddress[] getRouteTo(RoxAddress dest) throws TransportConfigException {
        Vector<RoxAddress> route = new Vector<RoxAddress>();
        RouteNode node = this.routeTree.getNodeForAddress(dest);
        if (node == null) {
            throw new TransportConfigException(NetMessageCode.TRNS_GET_ROUTE_NODE_NOT_FOUND, (Object[])new String[]{dest.toString()});
        }
        RouteNode parent = node;
        route.add(node.getRoxAddress());
        while ((parent = parent.getParent()) != null) {
            route.add(parent.getRoxAddress());
        }
        RoxAddress[] routeArray = route.toArray(new RoxAddress[route.size()]);
        int i = 0;
        for (int j = routeArray.length - 1; i < j; ++i, --j) {
            RoxAddress tmp = routeArray[i];
            routeArray[i] = routeArray[j];
            routeArray[j] = tmp;
        }
        return routeArray;
    }

    private void addRoute(RoxAddress destination, RoxAddress nextHop) {
        this.rTable.addStaticRoute(destination, nextHop);
    }

    private void removeRoute(RoxAddress destination) throws TransportException {
        this.rTable.removeStaticRoute(destination);
    }

    private void addClientConnection(ConnectionSetupAttribute csa) throws TransportException {
        this.cManager.addClientConnection(csa);
    }

    private void removeClientConnection(ConnectionSetupAttribute csa) throws TransportException {
        this.cManager.removeClientConnection(csa);
    }

    public RoxAddress initTransport(RouteTable rTable, ConnectionManager cManager) throws TransportException, TransportConfigException, RouteTranslationException, UnsupportedSubsystemException {
        int i;
        this.postInit(true);
        this.rTable = rTable;
        this.cManager = cManager;
        TransportConfig tConfig = this.getRootTransportConfig();
        Hashtable routes = tConfig.getRoutes();
        Enumeration enu = routes.keys();
        while (enu.hasMoreElements()) {
            Object key = enu.nextElement();
            rTable.addStaticRoute(((ConfigAddress)key).getRoxAddress(), ((ConfigAddress)routes.get(key)).getRoxAddress());
        }
        ConnectionSetupAttribute[] setupAttrib = tConfig.getClientConnectionAttributes();
        for (i = 0; i < setupAttrib.length; ++i) {
            cManager.addClientConnection(setupAttrib[i]);
        }
        setupAttrib = tConfig.getServerConnectionAttributes();
        for (i = 0; i < setupAttrib.length; ++i) {
            cManager.addServerConnection(setupAttrib[i]);
        }
        RoxAddress address = null;
        if (setupAttrib.length > 0) {
            address = new RoxAddress(setupAttrib[0].getAddress(), setupAttrib[0].getPort());
        }
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("LocalAddr:" + address + ":routes:" + routes, this);
        }
        return address;
    }

    private void checkFailedNodes(FailedNodeSet updateNodes, FailedNodeSet addNodes) throws TransportConfigUpdateFailure {
        if (updateNodes != null && !updateNodes.isEmpty()) {
            TransportConfigUpdateFailure tcuf = new TransportConfigUpdateFailure(updateNodes, null);
            if (Logger.isDebugEnabled(this)) {
                Logger.debug("Throwing update failure", tcuf, this);
            }
            throw tcuf;
        }
    }

    public void logRouteTree() {
        if (Logger.isInfoEnabled(this)) {
            Logger.info("RouteTree:" + this.routeTree, this);
        }
    }

    public void validateHostAdded(Host host) throws UpdateNotAcceptedException {
        AppInstance[] appInstances = host.getAppInstances();
        for (int i = 0; i < appInstances.length; ++i) {
            this.validateAppInstanceAdd(appInstances[i]);
        }
    }

    public void validateHostUpdated(Host newHost, Host oldHost) throws UpdateNotAcceptedException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Host Updated:" + newHost, this);
        }
        AppInstance oldRA = oldHost.getAppRA();
        AppInstance oldLD = oldHost.getAppLD();
        AppInstance newRA = newHost.getAppRA();
        AppInstance newLD = newHost.getAppLD();
        boolean raDeleted = false;
        if (oldRA != null && newRA == null || oldRA != null && newRA != null && this.checkModifiedAppInstance(oldRA, newRA)) {
            this.validateAppInstanceDelete(oldRA);
            raDeleted = true;
        }
        if (oldLD != null && newLD == null) {
            this.validateAppInstanceDelete(oldLD);
        }
        boolean ldModified = false;
        if (oldLD != null && newLD != null && this.checkModifiedAppInstance(oldLD, newLD)) {
            this.validateUpdateLD(oldLD, newLD);
            ldModified = true;
        }
        if (oldLD == null && newLD != null) {
            this.validateAppInstanceAdd(newLD);
        }
        if (oldRA == null && newRA != null || oldRA != null && newRA != null && this.checkModifiedAppInstance(oldRA, newRA)) {
            this.validateAppInstanceAdd(newRA);
            if (ldModified && (newRA.getParentID().equals(newLD.getID()) || oldRA != null && oldRA.getParentID().equals(oldLD.getID()))) {
                throw new UpdateNotAcceptedException(NetMessageCode.TRNS_HOSTDB_UPDHOST_INV_RA_LD_MOD.roxMessage());
            }
        }
    }

    public void validateHostDeleted(Host host) throws UpdateNotAcceptedException {
        AppInstance[] appInstances = host.getAppInstances();
        for (int i = 0; i < appInstances.length; ++i) {
            this.validateAppInstanceDelete(appInstances[i]);
        }
    }

    private void validateAppInstanceAdd(AppInstance appInstance) throws UpdateNotAcceptedException {
        RouteNode node;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Validating add app:" + appInstance, this);
        }
        AppInstanceID parentId = appInstance.getParentID();
        RouteNode parentNode = this.routeTree.getNodeForApp(parentId);
        try {
            node = new RouteNode(appInstance.getID(), HostDbRouteTree.createSetupAttribute(appInstance));
        }
        catch (RouteTranslationException rte) {
            throw new UpdateNotAcceptedException(NetMessageCode.TRNS_CONFIG_ADD_APP_INVALID_INFO.roxMessage(), (Throwable)rte);
        }
        catch (TransportException tex) {
            throw new UpdateNotAcceptedException(NetMessageCode.TRNS_CONFIG_ADD_APP_INVALID_INFO.roxMessage(), (Throwable)tex);
        }
        if (parentNode == null) {
            throw new UpdateNotAcceptedException(NetMessageCode.TRNS_CONFIG_ADD_APP_INVALID_PARENT.roxMessage(new String[]{parentId.toString()}));
        }
        this.validateNetworkCycle(parentNode, node);
    }

    private void validateAppInstanceDelete(AppInstance appInstance) throws UpdateNotAcceptedException {
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Validating delete app:" + appInstance, this);
        }
        AppInstanceID parentId = appInstance.getParentID();
        RouteNode node = this.routeTree.getNodeForApp(appInstance.getID());
        if (node == null) {
            throw new UpdateNotAcceptedException(NetMessageCode.TRNS_CONFIG_DEL_APP_NOT_FOUND.roxMessage(new String[]{appInstance.toString()}));
        }
        RouteNode parentNode = node.getParent();
        if (parentNode == null) {
            throw new UpdateNotAcceptedException(NetMessageCode.TRNS_CONFIG_DEL_APP_NO_PARENT.roxMessage(new String[]{node.toString()}));
        }
    }

    private void validateUpdateLD(AppInstance oldLD, AppInstance newLD) throws UpdateNotAcceptedException {
        RouteNode newNode;
        RouteNode oldNode;
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Validating update LD, OLD:" + oldLD + ":NEW:" + newLD, this);
        }
        if ((oldNode = this.routeTree.getNodeForApp(oldLD.getID())) == null) {
            throw new UpdateNotAcceptedException(NetMessageCode.TRNS_CONFIG_DEL_APP_NOT_FOUND.roxMessage(new String[]{oldLD.toString()}));
        }
        RouteNode oldParentNode = oldNode.getParent();
        if (oldParentNode == null) {
            throw new UpdateNotAcceptedException(NetMessageCode.TRNS_CONFIG_DEL_APP_NO_PARENT.roxMessage(new String[]{oldNode.toString()}));
        }
        try {
            newNode = new RouteNode(newLD.getID(), HostDbRouteTree.createSetupAttribute(newLD));
        }
        catch (RouteTranslationException rte) {
            throw new UpdateNotAcceptedException(NetMessageCode.TRNS_CONFIG_ADD_APP_INVALID_INFO.roxMessage(), (Throwable)rte);
        }
        catch (TransportException tex) {
            throw new UpdateNotAcceptedException(NetMessageCode.TRNS_CONFIG_ADD_APP_INVALID_INFO.roxMessage(), (Throwable)tex);
        }
        RouteNode newParentNode = this.routeTree.getNodeForApp(newLD.getParentID());
        if (newParentNode == null) {
            throw new UpdateNotAcceptedException(NetMessageCode.TRNS_CONFIG_ADD_APP_INVALID_PARENT.roxMessage(new String[]{newLD.getParentID().toString()}));
        }
        this.validateNetworkCycle(newParentNode, newNode);
    }

    private void validateNetworkCycle(RouteNode parent, RouteNode node) throws UpdateNotAcceptedException {
        HashSet<AppInstanceID> nodeSet = new HashSet<AppInstanceID>();
        nodeSet.add(node.getAppId());
        for (RouteNode tmp = parent; tmp != null; tmp = tmp.getParent()) {
            if (nodeSet.contains(tmp.getAppId())) {
                throw new UpdateNotAcceptedException(NetMessageCode.TRNS_CONFIG_ADD_APP_NET_CYCLE.roxMessage(new String[]{tmp.getRoxAddress().toString()}));
            }
            nodeSet.add(tmp.getAppId());
        }
    }

    private static class FailedNode {
        private RoxAddress addr;
        private AppInstanceID appID;

        FailedNode(RouteNode node) {
            this.addr = node.getRoxAddress();
            this.appID = node.getAppId();
        }

        public AppInstanceID getAppInstanceID() {
            return this.appID;
        }

        public String toString() {
            return this.addr + "{ID=" + this.appID + "}";
        }

        public int hashCode() {
            return this.addr.hashCode();
        }

        public boolean equals(Object obj) {
            FailedNode node;
            return obj instanceof FailedNode && (node = (FailedNode)obj) != null && (this.addr == null ? node.addr == null : this.addr.equals(node.addr)) && (this.appID == null ? node.appID == null : this.appID.equals(node.appID));
        }
    }

    static class FailedNodeSet {
        private HashSet nodeSet = new HashSet();

        FailedNodeSet() {
        }

        void add(RouteNode node) {
            this.nodeSet.add(new FailedNode(node));
        }

        boolean isEmpty() {
            return this.nodeSet.isEmpty();
        }

        Vector getFailedAppIDs() {
            Vector<AppInstanceID> v = new Vector<AppInstanceID>();
            Iterator iter = this.nodeSet.iterator();
            while (iter.hasNext()) {
                FailedNode node = (FailedNode)iter.next();
                v.add(node.getAppInstanceID());
            }
            return v;
        }

        public String toString() {
            return this.nodeSet.toString();
        }
    }
}

