/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport.config;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.ConnectionSetupAttribute;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.config.RouteNode;
import com.raplix.rolloutexpress.net.transport.config.RouteTranslationException;
import com.raplix.rolloutexpress.persist.exception.PersistenceManagerException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstance;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.ConnectionType;
import com.raplix.rolloutexpress.systemmodel.hostdbx.Host;
import com.raplix.rolloutexpress.systemmodel.hostdbx.HostSearchCriteria;
import com.raplix.rolloutexpress.systemmodel.hostdbx.MultiHostQuery;
import com.raplix.rolloutexpress.systemmodel.hostdbx.PhysicalCriteria;
import com.raplix.util.logger.Logger;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Set;

final class HostDbRouteTree {
    private RouteNode rootNode;
    private Hashtable hostNodeMap = new Hashtable();
    private Hashtable roxNodeMap = new Hashtable();
    static /* synthetic */ Class class$com$raplix$rolloutexpress$net$transport$config$HostDbRouteTree;

    HostDbRouteTree() throws RouteTranslationException {
        this.rootNode = HostDbRouteTree.fetchRouteTree(this.hostNodeMap, this.roxNodeMap);
        if (Logger.isDebugEnabled(this)) {
            Logger.debug("Tree:" + this.rootNode, this);
        }
    }

    public RouteNode getNodeForApp(AppInstanceID appId) {
        RouteNode rn = (RouteNode)this.hostNodeMap.get(appId);
        return rn;
    }

    public RouteNode getNodeForAddress(RoxAddress rox) {
        RouteNode rn = (RouteNode)this.roxNodeMap.get(rox);
        return rn;
    }

    public RouteNode getRootNode() {
        return this.rootNode;
    }

    public void addNode(RouteNode parent, RouteNode child) {
        parent.addChild(child);
        this.roxNodeMap.put(child.getRoxAddress(), child);
        this.hostNodeMap.put(child.getAppId(), child);
    }

    public void deleteNode(RouteNode node) {
        node.getParent().removeChild(node);
        this.roxNodeMap.remove(node.getRoxAddress());
        this.hostNodeMap.remove(node.getAppId());
    }

    static RouteNode fetchRouteTree(Hashtable hostNodeMap, Hashtable roxNodeMap) throws RouteTranslationException {
        try {
            HashSet<RouteNode> children;
            RouteNode routeNode;
            RouteNode root = null;
            PhysicalCriteria physCriteria = new PhysicalCriteria();
            physCriteria.setIncludePhysical(true);
            HostSearchCriteria hostSrchCriteria = new HostSearchCriteria();
            hostSrchCriteria.setPhysicalCriteria(physCriteria);
            MultiHostQuery mhq = hostSrchCriteria.getAllHostsQuery();
            mhq.setVisibilityFilter(null);
            Host[] hosts = mhq.select();
            Hashtable childMap = new Hashtable();
            for (int i = 0; i < hosts.length; ++i) {
                Host host = hosts[i];
                AppInstance[] appInstances = host.getAppInstances();
                for (int j = 0; j < appInstances.length; ++j) {
                    Object obj;
                    AppInstance appInstance = appInstances[j];
                    ConnectionSetupAttribute csa = HostDbRouteTree.createSetupAttribute(appInstance);
                    routeNode = new RouteNode(appInstance.getID(), csa);
                    RoxAddress address = routeNode.getRoxAddress();
                    if (appInstance.getParentID() != null) {
                        obj = childMap.get(appInstance.getParentID());
                        if (obj == null) {
                            children = new HashSet<RouteNode>();
                            childMap.put(appInstance.getParentID(), children);
                        } else {
                            children = (Set)obj;
                        }
                        children.add(routeNode);
                    } else {
                        root = routeNode;
                    }
                    obj = roxNodeMap.get(address);
                    if (obj != null) {
                        throw new RouteTranslationException(NetMessageCode.TRNS_HOSTDB_DUPLICATE_ADDR, (Object[])new String[]{obj.toString(), routeNode.toString()});
                    }
                    roxNodeMap.put(address, routeNode);
                    obj = hostNodeMap.get(appInstance.getID());
                    if (obj != null) {
                        throw new RouteTranslationException(NetMessageCode.TRNS_HOSTDB_DUPLICATE_APP, (Object[])new String[]{obj.toString(), routeNode.toString()});
                    }
                    hostNodeMap.put(appInstance.getID(), routeNode);
                }
            }
            Enumeration keys = childMap.keys();
            while (keys.hasMoreElements()) {
                AppInstanceID parentId = (AppInstanceID)keys.nextElement();
                RouteNode parent = (RouteNode)hostNodeMap.get(parentId);
                if (parent == null) {
                    throw new RouteTranslationException(NetMessageCode.TRNS_HOSTDB_NO_PARENT, (Object[])new String[]{parentId.toString()});
                }
                if (Logger.isDebugEnabled(class$com$raplix$rolloutexpress$net$transport$config$HostDbRouteTree == null ? HostDbRouteTree.class$("com.raplix.rolloutexpress.net.transport.config.HostDbRouteTree") : class$com$raplix$rolloutexpress$net$transport$config$HostDbRouteTree)) {
                    Logger.debug("Handling node:" + parent, class$com$raplix$rolloutexpress$net$transport$config$HostDbRouteTree == null ? HostDbRouteTree.class$("com.raplix.rolloutexpress.net.transport.config.HostDbRouteTree") : class$com$raplix$rolloutexpress$net$transport$config$HostDbRouteTree);
                }
                children = (HashSet<RouteNode>)childMap.get(parentId);
                Iterator iter = children.iterator();
                while (iter.hasNext()) {
                    routeNode = (RouteNode)iter.next();
                    parent.addChild(routeNode);
                }
            }
            if (root == null) {
                throw new RouteTranslationException(NetMessageCode.TRNS_HOSTDB_NO_ROOT_NODE, (Object[])new String[]{roxNodeMap.toString()});
            }
            Hashtable nodes = (Hashtable)roxNodeMap.clone();
            HostDbRouteTree.traverseTree(root, nodes);
            if (nodes.size() > 0) {
                throw new RouteTranslationException(NetMessageCode.TRNS_HOSTDB_ORPHANED_NODES, (Object[])new String[]{nodes.toString()});
            }
            return root;
        }
        catch (TransportException te) {
            throw new RouteTranslationException(NetMessageCode.TRNS_HOSTDB_TRANSPORT_ERROR, (Throwable)te);
        }
        catch (PersistenceManagerException pme) {
            throw new RouteTranslationException(NetMessageCode.TRNS_HOSTDB_ACCESS_ERROR, (Throwable)pme);
        }
        catch (RPCException rpc) {
            throw new RouteTranslationException(NetMessageCode.TRNS_HOSTDB_ACCESS_RPC_ERROR, (Throwable)rpc);
        }
    }

    static ConnectionSetupAttribute createSetupAttribute(AppInstance app) throws RouteTranslationException {
        StringBuffer parameters = new StringBuffer(app.getParameters());
        if (app.getConnectionType().equals(ConnectionType.SSH)) {
            parameters.append(",");
            parameters.append("appType");
            parameters.append("=");
            if (app.getType().equals(AppType.LD)) {
                parameters.append("ld");
            } else if (app.getType().equals(AppType.RA)) {
                parameters.append("ra");
            } else {
                throw new RouteTranslationException(NetMessageCode.TRNS_HOSTDB_INVALID_CONNECTION, (Object[])new String[]{app.getType().toString()});
            }
        }
        return new ConnectionSetupAttribute(app.getIPAddress(), app.getPort(), app.getConnectionType(), parameters.toString());
    }

    private static void traverseTree(RouteNode n, Hashtable nodes) throws RouteTranslationException, TransportException {
        RoxAddress address = n.getRoxAddress();
        Object obj = nodes.remove(address);
        if (obj == null) {
            throw new RouteTranslationException(NetMessageCode.TRNS_HOSTDB_TREE_TRAVERSAL, (Object[])new String[]{n.toString()});
        }
        RouteNode[] children = n.getChildren();
        if (children != null) {
            for (int i = 0; i < children.length; ++i) {
                HostDbRouteTree.traverseTree(children[i], nodes);
            }
        }
    }

    public String toString() {
        return this.getClass().getName() + ":nodeMap:" + this.roxNodeMap + "\nhostNodeMap:" + this.hostNodeMap;
    }
}

