/*
 * Decompiled with CFR 0.152.
 */
package com.raplix.rolloutexpress.net.transport;

import com.raplix.rolloutexpress.net.NetMessageCode;
import com.raplix.rolloutexpress.net.rpc.RPCException;
import com.raplix.rolloutexpress.net.transport.HostNotFound;
import com.raplix.rolloutexpress.net.transport.PingResult;
import com.raplix.rolloutexpress.net.transport.RemoteTransportException;
import com.raplix.rolloutexpress.net.transport.RoxAddress;
import com.raplix.rolloutexpress.net.transport.TraceFailed;
import com.raplix.rolloutexpress.net.transport.TraceResult;
import com.raplix.rolloutexpress.net.transport.TransportException;
import com.raplix.rolloutexpress.net.transport.TransportManager;
import com.raplix.rolloutexpress.net.transport.TransportServices;
import com.raplix.rolloutexpress.net.transport.config.TransportConfig;
import com.raplix.rolloutexpress.net.transport.config.TransportConfigException;
import com.raplix.rolloutexpress.systemmodel.hostdbx.AppInstanceID;

class TransportServicesImpl
implements TransportServices {
    private TransportManager tManager;

    public TransportServicesImpl(TransportManager tManager) {
        this.tManager = tManager;
    }

    public PingResult ping(RoxAddress destination) throws RPCException, RemoteTransportException, HostNotFound {
        try {
            return this.tManager.getControl().ping(destination);
        }
        catch (TransportException te) {
            throw new RemoteTransportException(NetMessageCode.TRNS_PING_FAILED, (Throwable)te, new String[]{destination.toString()});
        }
    }

    public TraceResult traceroute(RoxAddress destination) throws RPCException, TraceFailed, HostNotFound {
        return this.tManager.getControl().traceroute(destination);
    }

    public TransportConfig getTransportConfig(AppInstanceID appID) throws RPCException, RemoteTransportException {
        try {
            return this.tManager.getHostUpdateManager().createTransportConfigFor(appID);
        }
        catch (TransportException te) {
            throw new RemoteTransportException(NetMessageCode.TRNS_CONFIG_GEN_FAILED, (Throwable)te, new String[]{appID.toString()});
        }
        catch (TransportConfigException tce) {
            throw new RemoteTransportException(NetMessageCode.TRNS_CONFIG_GEN_FAILED, (Throwable)tce, new String[]{appID.toString()});
        }
    }
}

